# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PromptInjectionConfig(object):
    """
    The configuration details for prompt injection (PI) detection. This is for input only.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PromptInjectionConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param mode:
            The value to assign to the mode property of this PromptInjectionConfig.
        :type mode: str

        :param model_id:
            The value to assign to the model_id property of this PromptInjectionConfig.
        :type model_id: str

        :param is_enabled:
            The value to assign to the is_enabled property of this PromptInjectionConfig.
        :type is_enabled: bool

        """
        self.swagger_types = {
            'mode': 'str',
            'model_id': 'str',
            'is_enabled': 'bool'
        }
        self.attribute_map = {
            'mode': 'mode',
            'model_id': 'modelId',
            'is_enabled': 'isEnabled'
        }
        self._mode = None
        self._model_id = None
        self._is_enabled = None

    @property
    def mode(self):
        """
        Gets the mode of this PromptInjectionConfig.
        The mode of operation for prompt injection detection.


        :return: The mode of this PromptInjectionConfig.
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """
        Sets the mode of this PromptInjectionConfig.
        The mode of operation for prompt injection detection.


        :param mode: The mode of this PromptInjectionConfig.
        :type: str
        """
        self._mode = mode

    @property
    def model_id(self):
        """
        Gets the model_id of this PromptInjectionConfig.
        The OCID of the model used for the feature.


        :return: The model_id of this PromptInjectionConfig.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this PromptInjectionConfig.
        The OCID of the model used for the feature.


        :param model_id: The model_id of this PromptInjectionConfig.
        :type: str
        """
        self._model_id = model_id

    @property
    def is_enabled(self):
        """
        **[Required]** Gets the is_enabled of this PromptInjectionConfig.
        Whether to enable the prompt injection feature.


        :return: The is_enabled of this PromptInjectionConfig.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this PromptInjectionConfig.
        Whether to enable the prompt injection feature.


        :param is_enabled: The is_enabled of this PromptInjectionConfig.
        :type: bool
        """
        self._is_enabled = is_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
