# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .llm_selection import LlmSelection
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CustomGenAiModelLlmSelection(LlmSelection):
    """
    Custom LLM selection with specific Gen AI model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CustomGenAiModelLlmSelection object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.CustomGenAiModelLlmSelection.llm_selection_type` attribute
        of this class is ``CUSTOM_GEN_AI_MODEL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param llm_selection_type:
            The value to assign to the llm_selection_type property of this CustomGenAiModelLlmSelection.
            Allowed values for this property are: "DEFAULT", "CUSTOM_GEN_AI_MODEL", "CUSTOM_GEN_AI_ENDPOINT"
        :type llm_selection_type: str

        :param model_id:
            The value to assign to the model_id property of this CustomGenAiModelLlmSelection.
        :type model_id: str

        """
        self.swagger_types = {
            'llm_selection_type': 'str',
            'model_id': 'str'
        }
        self.attribute_map = {
            'llm_selection_type': 'llmSelectionType',
            'model_id': 'modelId'
        }
        self._llm_selection_type = None
        self._model_id = None
        self._llm_selection_type = 'CUSTOM_GEN_AI_MODEL'

    @property
    def model_id(self):
        """
        **[Required]** Gets the model_id of this CustomGenAiModelLlmSelection.
        The OCID of the GenAI model


        :return: The model_id of this CustomGenAiModelLlmSelection.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this CustomGenAiModelLlmSelection.
        The OCID of the GenAI model


        :param model_id: The model_id of this CustomGenAiModelLlmSelection.
        :type: str
        """
        self._model_id = model_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
