# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .llm_selection import LlmSelection
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DefaultLlmSelection(LlmSelection):
    """
    Default LLM selection using system-provided models.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DefaultLlmSelection object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.DefaultLlmSelection.llm_selection_type` attribute
        of this class is ``DEFAULT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param llm_selection_type:
            The value to assign to the llm_selection_type property of this DefaultLlmSelection.
            Allowed values for this property are: "DEFAULT", "CUSTOM_GEN_AI_MODEL", "CUSTOM_GEN_AI_ENDPOINT"
        :type llm_selection_type: str

        """
        self.swagger_types = {
            'llm_selection_type': 'str'
        }
        self.attribute_map = {
            'llm_selection_type': 'llmSelectionType'
        }
        self._llm_selection_type = None
        self._llm_selection_type = 'DEFAULT'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
