# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LlmCustomization(object):
    """
    Configuration to customize LLM.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LlmCustomization object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param llm_selection:
            The value to assign to the llm_selection property of this LlmCustomization.
        :type llm_selection: oci.generative_ai_agent.models.LlmSelection

        :param llm_hyper_parameters:
            The value to assign to the llm_hyper_parameters property of this LlmCustomization.
        :type llm_hyper_parameters: dict(str, object)

        :param instruction:
            The value to assign to the instruction property of this LlmCustomization.
        :type instruction: str

        """
        self.swagger_types = {
            'llm_selection': 'LlmSelection',
            'llm_hyper_parameters': 'dict(str, object)',
            'instruction': 'str'
        }
        self.attribute_map = {
            'llm_selection': 'llmSelection',
            'llm_hyper_parameters': 'llmHyperParameters',
            'instruction': 'instruction'
        }
        self._llm_selection = None
        self._llm_hyper_parameters = None
        self._instruction = None

    @property
    def llm_selection(self):
        """
        Gets the llm_selection of this LlmCustomization.

        :return: The llm_selection of this LlmCustomization.
        :rtype: oci.generative_ai_agent.models.LlmSelection
        """
        return self._llm_selection

    @llm_selection.setter
    def llm_selection(self, llm_selection):
        """
        Sets the llm_selection of this LlmCustomization.

        :param llm_selection: The llm_selection of this LlmCustomization.
        :type: oci.generative_ai_agent.models.LlmSelection
        """
        self._llm_selection = llm_selection

    @property
    def llm_hyper_parameters(self):
        """
        Gets the llm_hyper_parameters of this LlmCustomization.
        Hyper parameters for LLM configuration. Accepts Key-value pairs to configure various hyper parameters.
        Refer to the guide for examples and the JSON Schema documentation for details on the format.


        :return: The llm_hyper_parameters of this LlmCustomization.
        :rtype: dict(str, object)
        """
        return self._llm_hyper_parameters

    @llm_hyper_parameters.setter
    def llm_hyper_parameters(self, llm_hyper_parameters):
        """
        Sets the llm_hyper_parameters of this LlmCustomization.
        Hyper parameters for LLM configuration. Accepts Key-value pairs to configure various hyper parameters.
        Refer to the guide for examples and the JSON Schema documentation for details on the format.


        :param llm_hyper_parameters: The llm_hyper_parameters of this LlmCustomization.
        :type: dict(str, object)
        """
        self._llm_hyper_parameters = llm_hyper_parameters

    @property
    def instruction(self):
        """
        Gets the instruction of this LlmCustomization.
        If specified, the default instruction is replaced with provided instruction.


        :return: The instruction of this LlmCustomization.
        :rtype: str
        """
        return self._instruction

    @instruction.setter
    def instruction(self, instruction):
        """
        Sets the instruction of this LlmCustomization.
        If specified, the default instruction is replaced with provided instruction.


        :param instruction: The instruction of this LlmCustomization.
        :type: str
        """
        self._instruction = instruction

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
