# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ProvisionedCapacityConfig(object):
    """
    The configuration includes the provisioned capacity id and component runtime (tool versions, and other relevant information).
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ProvisionedCapacityConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param provisioned_capacity_id:
            The value to assign to the provisioned_capacity_id property of this ProvisionedCapacityConfig.
        :type provisioned_capacity_id: str

        :param platform_runtime_config:
            The value to assign to the platform_runtime_config property of this ProvisionedCapacityConfig.
        :type platform_runtime_config: oci.generative_ai_agent.models.PlatformRuntimeConfig

        :param tool_runtime_configs:
            The value to assign to the tool_runtime_configs property of this ProvisionedCapacityConfig.
        :type tool_runtime_configs: list[oci.generative_ai_agent.models.ToolRuntimeConfig]

        """
        self.swagger_types = {
            'provisioned_capacity_id': 'str',
            'platform_runtime_config': 'PlatformRuntimeConfig',
            'tool_runtime_configs': 'list[ToolRuntimeConfig]'
        }
        self.attribute_map = {
            'provisioned_capacity_id': 'provisionedCapacityId',
            'platform_runtime_config': 'platformRuntimeConfig',
            'tool_runtime_configs': 'toolRuntimeConfigs'
        }
        self._provisioned_capacity_id = None
        self._platform_runtime_config = None
        self._tool_runtime_configs = None

    @property
    def provisioned_capacity_id(self):
        """
        **[Required]** Gets the provisioned_capacity_id of this ProvisionedCapacityConfig.
        An OCID that uniquely identifies an Provisioned Capacity.


        :return: The provisioned_capacity_id of this ProvisionedCapacityConfig.
        :rtype: str
        """
        return self._provisioned_capacity_id

    @provisioned_capacity_id.setter
    def provisioned_capacity_id(self, provisioned_capacity_id):
        """
        Sets the provisioned_capacity_id of this ProvisionedCapacityConfig.
        An OCID that uniquely identifies an Provisioned Capacity.


        :param provisioned_capacity_id: The provisioned_capacity_id of this ProvisionedCapacityConfig.
        :type: str
        """
        self._provisioned_capacity_id = provisioned_capacity_id

    @property
    def platform_runtime_config(self):
        """
        Gets the platform_runtime_config of this ProvisionedCapacityConfig.

        :return: The platform_runtime_config of this ProvisionedCapacityConfig.
        :rtype: oci.generative_ai_agent.models.PlatformRuntimeConfig
        """
        return self._platform_runtime_config

    @platform_runtime_config.setter
    def platform_runtime_config(self, platform_runtime_config):
        """
        Sets the platform_runtime_config of this ProvisionedCapacityConfig.

        :param platform_runtime_config: The platform_runtime_config of this ProvisionedCapacityConfig.
        :type: oci.generative_ai_agent.models.PlatformRuntimeConfig
        """
        self._platform_runtime_config = platform_runtime_config

    @property
    def tool_runtime_configs(self):
        """
        Gets the tool_runtime_configs of this ProvisionedCapacityConfig.
        RAG and SQL will be tools.


        :return: The tool_runtime_configs of this ProvisionedCapacityConfig.
        :rtype: list[oci.generative_ai_agent.models.ToolRuntimeConfig]
        """
        return self._tool_runtime_configs

    @tool_runtime_configs.setter
    def tool_runtime_configs(self, tool_runtime_configs):
        """
        Sets the tool_runtime_configs of this ProvisionedCapacityConfig.
        RAG and SQL will be tools.


        :param tool_runtime_configs: The tool_runtime_configs of this ProvisionedCapacityConfig.
        :type: list[oci.generative_ai_agent.models.ToolRuntimeConfig]
        """
        self._tool_runtime_configs = tool_runtime_configs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
