# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SourceDetails(object):
    """
    The details of source of the event.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SourceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this SourceDetails.
        :type key: str

        :param name:
            The value to assign to the name property of this SourceDetails.
        :type name: str

        """
        self.swagger_types = {
            'key': 'str',
            'name': 'str'
        }
        self.attribute_map = {
            'key': 'key',
            'name': 'name'
        }
        self._key = None
        self._name = None

    @property
    def key(self):
        """
        Gets the key of this SourceDetails.
        Id of the source of the event.


        :return: The key of this SourceDetails.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this SourceDetails.
        Id of the source of the event.


        :param key: The key of this SourceDetails.
        :type: str
        """
        self._key = key

    @property
    def name(self):
        """
        Gets the name of this SourceDetails.
        Name of the source of the event.


        :return: The name of this SourceDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SourceDetails.
        Name of the source of the event.


        :param name: The name of this SourceDetails.
        :type: str
        """
        self._name = name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
