# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApproximateLocation(object):
    """
    To refine search results based on geography, you can specify an approximate user location using any of the following:
    - `city` and `region` are free-text strings, like \"Minneapolis\" and \"Minnesota\".
    - `country` is a two-letter ISO country code, like \"US\".
    - `timezone` is an IANA timezone string, like \"America/Chicago\".
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApproximateLocation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param city:
            The value to assign to the city property of this ApproximateLocation.
        :type city: str

        :param region:
            The value to assign to the region property of this ApproximateLocation.
        :type region: str

        :param country:
            The value to assign to the country property of this ApproximateLocation.
        :type country: str

        :param timezone:
            The value to assign to the timezone property of this ApproximateLocation.
        :type timezone: str

        """
        self.swagger_types = {
            'city': 'str',
            'region': 'str',
            'country': 'str',
            'timezone': 'str'
        }
        self.attribute_map = {
            'city': 'city',
            'region': 'region',
            'country': 'country',
            'timezone': 'timezone'
        }
        self._city = None
        self._region = None
        self._country = None
        self._timezone = None

    @property
    def city(self):
        """
        Gets the city of this ApproximateLocation.
        Approximate city name, like \"Minneapolis\".


        :return: The city of this ApproximateLocation.
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """
        Sets the city of this ApproximateLocation.
        Approximate city name, like \"Minneapolis\".


        :param city: The city of this ApproximateLocation.
        :type: str
        """
        self._city = city

    @property
    def region(self):
        """
        Gets the region of this ApproximateLocation.
        Approximate region or state, like \"Minnesota\".


        :return: The region of this ApproximateLocation.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this ApproximateLocation.
        Approximate region or state, like \"Minnesota\".


        :param region: The region of this ApproximateLocation.
        :type: str
        """
        self._region = region

    @property
    def country(self):
        """
        Gets the country of this ApproximateLocation.
        Two-letter ISO country code.


        :return: The country of this ApproximateLocation.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this ApproximateLocation.
        Two-letter ISO country code.


        :param country: The country of this ApproximateLocation.
        :type: str
        """
        self._country = country

    @property
    def timezone(self):
        """
        Gets the timezone of this ApproximateLocation.
        IANA timezone string.


        :return: The timezone of this ApproximateLocation.
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """
        Sets the timezone of this ApproximateLocation.
        IANA timezone string.


        :param timezone: The timezone of this ApproximateLocation.
        :type: str
        """
        self._timezone = timezone

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
