# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereCitationSourceV2(object):
    """
    A citation source object.
    """

    #: A constant which can be used with the type property of a CohereCitationSourceV2.
    #: This constant has a value of "TOOL"
    TYPE_TOOL = "TOOL"

    #: A constant which can be used with the type property of a CohereCitationSourceV2.
    #: This constant has a value of "DOCUMENT"
    TYPE_DOCUMENT = "DOCUMENT"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereCitationSourceV2 object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CohereCitationSourceV2.
            Allowed values for this property are: "TOOL", "DOCUMENT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param tool:
            The value to assign to the tool property of this CohereCitationSourceV2.
        :type tool: oci.generative_ai_inference.models.CohereCitationToolV2

        :param document:
            The value to assign to the document property of this CohereCitationSourceV2.
        :type document: oci.generative_ai_inference.models.CohereCitationDocument

        """
        self.swagger_types = {
            'type': 'str',
            'tool': 'CohereCitationToolV2',
            'document': 'CohereCitationDocument'
        }
        self.attribute_map = {
            'type': 'type',
            'tool': 'tool',
            'document': 'document'
        }
        self._type = None
        self._tool = None
        self._document = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CohereCitationSourceV2.
        The source type.

        Allowed values for this property are: "TOOL", "DOCUMENT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this CohereCitationSourceV2.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CohereCitationSourceV2.
        The source type.


        :param type: The type of this CohereCitationSourceV2.
        :type: str
        """
        allowed_values = ["TOOL", "DOCUMENT"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def tool(self):
        """
        Gets the tool of this CohereCitationSourceV2.

        :return: The tool of this CohereCitationSourceV2.
        :rtype: oci.generative_ai_inference.models.CohereCitationToolV2
        """
        return self._tool

    @tool.setter
    def tool(self, tool):
        """
        Sets the tool of this CohereCitationSourceV2.

        :param tool: The tool of this CohereCitationSourceV2.
        :type: oci.generative_ai_inference.models.CohereCitationToolV2
        """
        self._tool = tool

    @property
    def document(self):
        """
        Gets the document of this CohereCitationSourceV2.

        :return: The document of this CohereCitationSourceV2.
        :rtype: oci.generative_ai_inference.models.CohereCitationDocument
        """
        return self._document

    @document.setter
    def document(self, document):
        """
        Sets the document of this CohereCitationSourceV2.

        :param document: The document of this CohereCitationSourceV2.
        :type: oci.generative_ai_inference.models.CohereCitationDocument
        """
        self._document = document

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
