# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereToolCallV2(object):
    """
    A tool call generated by the model.
    """

    #: A constant which can be used with the type property of a CohereToolCallV2.
    #: This constant has a value of "FUNCTION"
    TYPE_FUNCTION = "FUNCTION"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereToolCallV2 object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CohereToolCallV2.
        :type id: str

        :param type:
            The value to assign to the type property of this CohereToolCallV2.
            Allowed values for this property are: "FUNCTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param function:
            The value to assign to the function property of this CohereToolCallV2.
        :type function: object

        """
        self.swagger_types = {
            'id': 'str',
            'type': 'str',
            'function': 'object'
        }
        self.attribute_map = {
            'id': 'id',
            'type': 'type',
            'function': 'function'
        }
        self._id = None
        self._type = None
        self._function = None

    @property
    def id(self):
        """
        Gets the id of this CohereToolCallV2.
        Id of the tool call.


        :return: The id of this CohereToolCallV2.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CohereToolCallV2.
        Id of the tool call.


        :param id: The id of this CohereToolCallV2.
        :type: str
        """
        self._id = id

    @property
    def type(self):
        """
        Gets the type of this CohereToolCallV2.
        Type of a tool call.

        Allowed values for this property are: "FUNCTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this CohereToolCallV2.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CohereToolCallV2.
        Type of a tool call.


        :param type: The type of this CohereToolCallV2.
        :type: str
        """
        allowed_values = ["FUNCTION"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def function(self):
        """
        Gets the function of this CohereToolCallV2.
        Function of a tool call.


        :return: The function of this CohereToolCallV2.
        :rtype: object
        """
        return self._function

    @function.setter
    def function(self, function):
        """
        Sets the function of this CohereToolCallV2.
        Function of a tool call.


        :param function: The function of this CohereToolCallV2.
        :type: object
        """
        self._function = function

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
