# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GroundingWebChunk(object):
    """
    object containing the web source.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GroundingWebChunk object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param uri:
            The value to assign to the uri property of this GroundingWebChunk.
        :type uri: str

        :param title:
            The value to assign to the title property of this GroundingWebChunk.
        :type title: str

        :param domain:
            The value to assign to the domain property of this GroundingWebChunk.
        :type domain: str

        """
        self.swagger_types = {
            'uri': 'str',
            'title': 'str',
            'domain': 'str'
        }
        self.attribute_map = {
            'uri': 'uri',
            'title': 'title',
            'domain': 'domain'
        }
        self._uri = None
        self._title = None
        self._domain = None

    @property
    def uri(self):
        """
        Gets the uri of this GroundingWebChunk.
        The web source's uri


        :return: The uri of this GroundingWebChunk.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this GroundingWebChunk.
        The web source's uri


        :param uri: The uri of this GroundingWebChunk.
        :type: str
        """
        self._uri = uri

    @property
    def title(self):
        """
        Gets the title of this GroundingWebChunk.
        The title of the web source


        :return: The title of this GroundingWebChunk.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this GroundingWebChunk.
        The title of the web source


        :param title: The title of this GroundingWebChunk.
        :type: str
        """
        self._title = title

    @property
    def domain(self):
        """
        Gets the domain of this GroundingWebChunk.
        the domain of the web source


        :return: The domain of this GroundingWebChunk.
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """
        Sets the domain of this GroundingWebChunk.
        the domain of the web source


        :param domain: The domain of this GroundingWebChunk.
        :type: str
        """
        self._domain = domain

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
