# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ToolCall(object):
    """
    The tool call generated by the model, such as function call.
    """

    #: A constant which can be used with the type property of a ToolCall.
    #: This constant has a value of "FUNCTION"
    TYPE_FUNCTION = "FUNCTION"

    def __init__(self, **kwargs):
        """
        Initializes a new ToolCall object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai_inference.models.FunctionCall`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ToolCall.
        :type id: str

        :param type:
            The value to assign to the type property of this ToolCall.
            Allowed values for this property are: "FUNCTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        """
        self.swagger_types = {
            'id': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'type': 'type'
        }
        self._id = None
        self._type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'FUNCTION':
            return 'FunctionCall'
        else:
            return 'ToolCall'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ToolCall.
        The ID of the tool call.


        :return: The id of this ToolCall.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ToolCall.
        The ID of the tool call.


        :param id: The id of this ToolCall.
        :type: str
        """
        self._id = id

    @property
    def type(self):
        """
        **[Required]** Gets the type of this ToolCall.
        The type of the tool.

        Allowed values for this property are: "FUNCTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this ToolCall.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ToolCall.
        The type of the tool.


        :param type: The type of this ToolCall.
        :type: str
        """
        allowed_values = ["FUNCTION"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
