# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230301


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivateEndpointSummary(object):
    """
    PrivateEndpoint resource summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivateEndpointSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PrivateEndpointSummary.
        :type id: str

        :param description:
            The value to assign to the description property of this PrivateEndpointSummary.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this PrivateEndpointSummary.
        :type compartment_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this PrivateEndpointSummary.
        :type subnet_id: str

        :param vcn_id:
            The value to assign to the vcn_id property of this PrivateEndpointSummary.
        :type vcn_id: str

        :param display_name:
            The value to assign to the display_name property of this PrivateEndpointSummary.
        :type display_name: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this PrivateEndpointSummary.
        :type nsg_ids: list[str]

        :param time_created:
            The value to assign to the time_created property of this PrivateEndpointSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this PrivateEndpointSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PrivateEndpointSummary.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this PrivateEndpointSummary.
        :type lifecycle_state_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this PrivateEndpointSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this PrivateEndpointSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this PrivateEndpointSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'subnet_id': 'str',
            'vcn_id': 'str',
            'display_name': 'str',
            'nsg_ids': 'list[str]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'subnet_id': 'subnetId',
            'vcn_id': 'vcnId',
            'display_name': 'displayName',
            'nsg_ids': 'nsgIds',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._description = None
        self._compartment_id = None
        self._subnet_id = None
        self._vcn_id = None
        self._display_name = None
        self._nsg_ids = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PrivateEndpointSummary.
        PrivateEndpoint identifier


        :return: The id of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PrivateEndpointSummary.
        PrivateEndpoint identifier


        :param id: The id of this PrivateEndpointSummary.
        :type: str
        """
        self._id = id

    @property
    def description(self):
        """
        Gets the description of this PrivateEndpointSummary.
        PrivateEndpoint description.


        :return: The description of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PrivateEndpointSummary.
        PrivateEndpoint description.


        :param description: The description of this PrivateEndpointSummary.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this PrivateEndpointSummary.
        Identifier of the compartment where private endpoint exists.


        :return: The compartment_id of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PrivateEndpointSummary.
        Identifier of the compartment where private endpoint exists.


        :param compartment_id: The compartment_id of this PrivateEndpointSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this PrivateEndpointSummary.
        Identifier of the customer subnet against which private endpoint is created.


        :return: The subnet_id of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this PrivateEndpointSummary.
        Identifier of the customer subnet against which private endpoint is created.


        :param subnet_id: The subnet_id of this PrivateEndpointSummary.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def vcn_id(self):
        """
        **[Required]** Gets the vcn_id of this PrivateEndpointSummary.
        Identifier of the VCN in which subnet exists.


        :return: The vcn_id of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this PrivateEndpointSummary.
        Identifier of the VCN in which subnet exists.


        :param vcn_id: The vcn_id of this PrivateEndpointSummary.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this PrivateEndpointSummary.
        Private endpoint display name.


        :return: The display_name of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PrivateEndpointSummary.
        Private endpoint display name.


        :param display_name: The display_name of this PrivateEndpointSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this PrivateEndpointSummary.
        The OCIDs of the network security groups that the private endpoint belongs to.


        :return: The nsg_ids of this PrivateEndpointSummary.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this PrivateEndpointSummary.
        The OCIDs of the network security groups that the private endpoint belongs to.


        :param nsg_ids: The nsg_ids of this PrivateEndpointSummary.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this PrivateEndpointSummary.
        The time the the private endpoint was created. An RFC3339 formatted datetime string


        :return: The time_created of this PrivateEndpointSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PrivateEndpointSummary.
        The time the the private endpoint was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this PrivateEndpointSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this PrivateEndpointSummary.
        The time the private endpoint was last updated. An RFC3339 formatted datetime string


        :return: The time_updated of this PrivateEndpointSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this PrivateEndpointSummary.
        The time the private endpoint was last updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this PrivateEndpointSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this PrivateEndpointSummary.
        Lifecycle state of private endpoint.


        :return: The lifecycle_state of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PrivateEndpointSummary.
        Lifecycle state of private endpoint.


        :param lifecycle_state: The lifecycle_state of this PrivateEndpointSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this PrivateEndpointSummary.
        Detailed message for the lifecycle state.


        :return: The lifecycle_state_details of this PrivateEndpointSummary.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this PrivateEndpointSummary.
        Detailed message for the lifecycle state.


        :param lifecycle_state_details: The lifecycle_state_details of this PrivateEndpointSummary.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this PrivateEndpointSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this PrivateEndpointSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this PrivateEndpointSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this PrivateEndpointSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this PrivateEndpointSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this PrivateEndpointSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this PrivateEndpointSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this PrivateEndpointSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this PrivateEndpointSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this PrivateEndpointSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this PrivateEndpointSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this PrivateEndpointSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
