# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdatePipelineDetails(object):
    """
    Information with which to update a pipeline.
    """

    #: A constant which can be used with the recipe_type property of a UpdatePipelineDetails.
    #: This constant has a value of "ZERO_ETL"
    RECIPE_TYPE_ZERO_ETL = "ZERO_ETL"

    #: A constant which can be used with the license_model property of a UpdatePipelineDetails.
    #: This constant has a value of "LICENSE_INCLUDED"
    LICENSE_MODEL_LICENSE_INCLUDED = "LICENSE_INCLUDED"

    #: A constant which can be used with the license_model property of a UpdatePipelineDetails.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_MODEL_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdatePipelineDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.golden_gate.models.UpdateZeroEtlPipelineDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param recipe_type:
            The value to assign to the recipe_type property of this UpdatePipelineDetails.
            Allowed values for this property are: "ZERO_ETL"
        :type recipe_type: str

        :param display_name:
            The value to assign to the display_name property of this UpdatePipelineDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdatePipelineDetails.
        :type description: str

        :param license_model:
            The value to assign to the license_model property of this UpdatePipelineDetails.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"
        :type license_model: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdatePipelineDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdatePipelineDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param subnet_id:
            The value to assign to the subnet_id property of this UpdatePipelineDetails.
        :type subnet_id: str

        """
        self.swagger_types = {
            'recipe_type': 'str',
            'display_name': 'str',
            'description': 'str',
            'license_model': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'subnet_id': 'str'
        }
        self.attribute_map = {
            'recipe_type': 'recipeType',
            'display_name': 'displayName',
            'description': 'description',
            'license_model': 'licenseModel',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'subnet_id': 'subnetId'
        }
        self._recipe_type = None
        self._display_name = None
        self._description = None
        self._license_model = None
        self._freeform_tags = None
        self._defined_tags = None
        self._subnet_id = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['recipeType']

        if type == 'ZERO_ETL':
            return 'UpdateZeroEtlPipelineDetails'
        else:
            return 'UpdatePipelineDetails'

    @property
    def recipe_type(self):
        """
        Gets the recipe_type of this UpdatePipelineDetails.
        The type of the recipe

        Allowed values for this property are: "ZERO_ETL"


        :return: The recipe_type of this UpdatePipelineDetails.
        :rtype: str
        """
        return self._recipe_type

    @recipe_type.setter
    def recipe_type(self, recipe_type):
        """
        Sets the recipe_type of this UpdatePipelineDetails.
        The type of the recipe


        :param recipe_type: The recipe_type of this UpdatePipelineDetails.
        :type: str
        """
        allowed_values = ["ZERO_ETL"]
        if not value_allowed_none_or_none_sentinel(recipe_type, allowed_values):
            raise ValueError(
                f"Invalid value for `recipe_type`, must be None or one of {allowed_values}"
            )
        self._recipe_type = recipe_type

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdatePipelineDetails.
        An object's Display Name.


        :return: The display_name of this UpdatePipelineDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdatePipelineDetails.
        An object's Display Name.


        :param display_name: The display_name of this UpdatePipelineDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdatePipelineDetails.
        Metadata about this specific object.


        :return: The description of this UpdatePipelineDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdatePipelineDetails.
        Metadata about this specific object.


        :param description: The description of this UpdatePipelineDetails.
        :type: str
        """
        self._description = description

    @property
    def license_model(self):
        """
        Gets the license_model of this UpdatePipelineDetails.
        The Oracle license model that applies to a Deployment.

        Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"


        :return: The license_model of this UpdatePipelineDetails.
        :rtype: str
        """
        return self._license_model

    @license_model.setter
    def license_model(self, license_model):
        """
        Sets the license_model of this UpdatePipelineDetails.
        The Oracle license model that applies to a Deployment.


        :param license_model: The license_model of this UpdatePipelineDetails.
        :type: str
        """
        allowed_values = ["LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_model, allowed_values):
            raise ValueError(
                f"Invalid value for `license_model`, must be None or one of {allowed_values}"
            )
        self._license_model = license_model

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdatePipelineDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists
        for cross-compatibility only.

        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdatePipelineDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdatePipelineDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists
        for cross-compatibility only.

        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdatePipelineDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdatePipelineDetails.
        Tags defined for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdatePipelineDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdatePipelineDetails.
        Tags defined for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdatePipelineDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this UpdatePipelineDetails.
        The `OCID`__ of the subnet of the pipeline's private endpoint.
        The subnet must be a private subnet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this UpdatePipelineDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this UpdatePipelineDetails.
        The `OCID`__ of the subnet of the pipeline's private endpoint.
        The subnet must be a private subnet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this UpdatePipelineDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
