# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppBundlePoolConfiguration(object):
    """
    Configurable options maintaining a pool of ICF connector instances. Values for sub attributes can be set only if the ConnectorBundle referenced in the App has connectorPoolingSupported set to true

    **SCIM++ Properties:**
    - idcsSearchable: false
    - multiValued: false
    - mutability: readWrite
    - required: false
    - returned: default
    - type: complex
    - uniqueness: none
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AppBundlePoolConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param max_idle:
            The value to assign to the max_idle property of this AppBundlePoolConfiguration.
        :type max_idle: int

        :param max_objects:
            The value to assign to the max_objects property of this AppBundlePoolConfiguration.
        :type max_objects: int

        :param max_wait:
            The value to assign to the max_wait property of this AppBundlePoolConfiguration.
        :type max_wait: int

        :param min_evictable_idle_time_millis:
            The value to assign to the min_evictable_idle_time_millis property of this AppBundlePoolConfiguration.
        :type min_evictable_idle_time_millis: int

        :param min_idle:
            The value to assign to the min_idle property of this AppBundlePoolConfiguration.
        :type min_idle: int

        """
        self.swagger_types = {
            'max_idle': 'int',
            'max_objects': 'int',
            'max_wait': 'int',
            'min_evictable_idle_time_millis': 'int',
            'min_idle': 'int'
        }
        self.attribute_map = {
            'max_idle': 'maxIdle',
            'max_objects': 'maxObjects',
            'max_wait': 'maxWait',
            'min_evictable_idle_time_millis': 'minEvictableIdleTimeMillis',
            'min_idle': 'minIdle'
        }
        self._max_idle = None
        self._max_objects = None
        self._max_wait = None
        self._min_evictable_idle_time_millis = None
        self._min_idle = None

    @property
    def max_idle(self):
        """
        Gets the max_idle of this AppBundlePoolConfiguration.
        Maximum number of connector instances in the pool that are idle and active.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The max_idle of this AppBundlePoolConfiguration.
        :rtype: int
        """
        return self._max_idle

    @max_idle.setter
    def max_idle(self, max_idle):
        """
        Sets the max_idle of this AppBundlePoolConfiguration.
        Maximum number of connector instances in the pool that are idle and active.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param max_idle: The max_idle of this AppBundlePoolConfiguration.
        :type: int
        """
        self._max_idle = max_idle

    @property
    def max_objects(self):
        """
        Gets the max_objects of this AppBundlePoolConfiguration.
        Maximum number of connector instances in the pool that are idle and active.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The max_objects of this AppBundlePoolConfiguration.
        :rtype: int
        """
        return self._max_objects

    @max_objects.setter
    def max_objects(self, max_objects):
        """
        Sets the max_objects of this AppBundlePoolConfiguration.
        Maximum number of connector instances in the pool that are idle and active.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param max_objects: The max_objects of this AppBundlePoolConfiguration.
        :type: int
        """
        self._max_objects = max_objects

    @property
    def max_wait(self):
        """
        Gets the max_wait of this AppBundlePoolConfiguration.
        Maximum time (in milliseconds) to wait for a free connector instance to become available before failing.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The max_wait of this AppBundlePoolConfiguration.
        :rtype: int
        """
        return self._max_wait

    @max_wait.setter
    def max_wait(self, max_wait):
        """
        Sets the max_wait of this AppBundlePoolConfiguration.
        Maximum time (in milliseconds) to wait for a free connector instance to become available before failing.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param max_wait: The max_wait of this AppBundlePoolConfiguration.
        :type: int
        """
        self._max_wait = max_wait

    @property
    def min_evictable_idle_time_millis(self):
        """
        Gets the min_evictable_idle_time_millis of this AppBundlePoolConfiguration.
        Minimum time (in milliseconds) to wait before evicting an idle conenctor instance from the pool.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The min_evictable_idle_time_millis of this AppBundlePoolConfiguration.
        :rtype: int
        """
        return self._min_evictable_idle_time_millis

    @min_evictable_idle_time_millis.setter
    def min_evictable_idle_time_millis(self, min_evictable_idle_time_millis):
        """
        Sets the min_evictable_idle_time_millis of this AppBundlePoolConfiguration.
        Minimum time (in milliseconds) to wait before evicting an idle conenctor instance from the pool.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param min_evictable_idle_time_millis: The min_evictable_idle_time_millis of this AppBundlePoolConfiguration.
        :type: int
        """
        self._min_evictable_idle_time_millis = min_evictable_idle_time_millis

    @property
    def min_idle(self):
        """
        Gets the min_idle of this AppBundlePoolConfiguration.
        Minimum number of idle connector instances in the pool.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The min_idle of this AppBundlePoolConfiguration.
        :rtype: int
        """
        return self._min_idle

    @min_idle.setter
    def min_idle(self, min_idle):
        """
        Sets the min_idle of this AppBundlePoolConfiguration.
        Minimum number of idle connector instances in the pool.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param min_idle: The min_idle of this AppBundlePoolConfiguration.
        :type: int
        """
        self._min_idle = min_idle

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
