# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppScopes(object):
    """
    Scopes defined by this App. Used when this App acts as an OAuth Resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AppScopes object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this AppScopes.
        :type value: str

        :param fqs:
            The value to assign to the fqs property of this AppScopes.
        :type fqs: str

        :param description:
            The value to assign to the description property of this AppScopes.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this AppScopes.
        :type display_name: str

        :param requires_consent:
            The value to assign to the requires_consent property of this AppScopes.
        :type requires_consent: bool

        :param read_only:
            The value to assign to the read_only property of this AppScopes.
        :type read_only: bool

        """
        self.swagger_types = {
            'value': 'str',
            'fqs': 'str',
            'description': 'str',
            'display_name': 'str',
            'requires_consent': 'bool',
            'read_only': 'bool'
        }
        self.attribute_map = {
            'value': 'value',
            'fqs': 'fqs',
            'description': 'description',
            'display_name': 'displayName',
            'requires_consent': 'requiresConsent',
            'read_only': 'readOnly'
        }
        self._value = None
        self._fqs = None
        self._description = None
        self._display_name = None
        self._requires_consent = None
        self._read_only = None

    @property
    def value(self):
        """
        **[Required]** Gets the value of this AppScopes.
        OAuth scope.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The value of this AppScopes.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this AppScopes.
        OAuth scope.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param value: The value of this AppScopes.
        :type: str
        """
        self._value = value

    @property
    def fqs(self):
        """
        Gets the fqs of this AppScopes.
        The fully qualified value of this scope within this App. A fully qualified scope combines the 'value' of each scope with the value of 'audience'. Each value of 'fqs' must be unique across the system. Used only when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :return: The fqs of this AppScopes.
        :rtype: str
        """
        return self._fqs

    @fqs.setter
    def fqs(self, fqs):
        """
        Sets the fqs of this AppScopes.
        The fully qualified value of this scope within this App. A fully qualified scope combines the 'value' of each scope with the value of 'audience'. Each value of 'fqs' must be unique across the system. Used only when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :param fqs: The fqs of this AppScopes.
        :type: str
        """
        self._fqs = fqs

    @property
    def description(self):
        """
        Gets the description of this AppScopes.
        OAuth scope description

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The description of this AppScopes.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AppScopes.
        OAuth scope description

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param description: The description of this AppScopes.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this AppScopes.
        OAuth scope display name

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The display_name of this AppScopes.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AppScopes.
        OAuth scope display name

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param display_name: The display_name of this AppScopes.
        :type: str
        """
        self._display_name = display_name

    @property
    def requires_consent(self):
        """
        Gets the requires_consent of this AppScopes.
        If true, indicates that a user must provide consent to access this scope. Note: Used only when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The requires_consent of this AppScopes.
        :rtype: bool
        """
        return self._requires_consent

    @requires_consent.setter
    def requires_consent(self, requires_consent):
        """
        Sets the requires_consent of this AppScopes.
        If true, indicates that a user must provide consent to access this scope. Note: Used only when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param requires_consent: The requires_consent of this AppScopes.
        :type: bool
        """
        self._requires_consent = requires_consent

    @property
    def read_only(self):
        """
        Gets the read_only of this AppScopes.
        If true, indicates that this value must be protected.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: boolean
         - uniqueness: none


        :return: The read_only of this AppScopes.
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """
        Sets the read_only of this AppScopes.
        If true, indicates that this value must be protected.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: boolean
         - uniqueness: none


        :param read_only: The read_only of this AppScopes.
        :type: bool
        """
        self._read_only = read_only

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
