# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MappedAttributeAttributeMappings(object):
    """
    A list of attribute mappings between Oracle Identity Cloud Service Resource Type and Account Object Class
    """

    #: A constant which can be used with the applies_to_actions property of a MappedAttributeAttributeMappings.
    #: This constant has a value of "create"
    APPLIES_TO_ACTIONS_CREATE = "create"

    #: A constant which can be used with the applies_to_actions property of a MappedAttributeAttributeMappings.
    #: This constant has a value of "update"
    APPLIES_TO_ACTIONS_UPDATE = "update"

    def __init__(self, **kwargs):
        """
        Initializes a new MappedAttributeAttributeMappings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param managed_object_attribute_name:
            The value to assign to the managed_object_attribute_name property of this MappedAttributeAttributeMappings.
        :type managed_object_attribute_name: str

        :param idcs_attribute_name:
            The value to assign to the idcs_attribute_name property of this MappedAttributeAttributeMappings.
        :type idcs_attribute_name: str

        :param required:
            The value to assign to the required property of this MappedAttributeAttributeMappings.
        :type required: bool

        :param applies_to_actions:
            The value to assign to the applies_to_actions property of this MappedAttributeAttributeMappings.
            Allowed values for items in this list are: "create", "update", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type applies_to_actions: list[str]

        :param saml_format:
            The value to assign to the saml_format property of this MappedAttributeAttributeMappings.
        :type saml_format: str

        """
        self.swagger_types = {
            'managed_object_attribute_name': 'str',
            'idcs_attribute_name': 'str',
            'required': 'bool',
            'applies_to_actions': 'list[str]',
            'saml_format': 'str'
        }
        self.attribute_map = {
            'managed_object_attribute_name': 'managedObjectAttributeName',
            'idcs_attribute_name': 'idcsAttributeName',
            'required': 'required',
            'applies_to_actions': 'appliesToActions',
            'saml_format': 'samlFormat'
        }
        self._managed_object_attribute_name = None
        self._idcs_attribute_name = None
        self._required = None
        self._applies_to_actions = None
        self._saml_format = None

    @property
    def managed_object_attribute_name(self):
        """
        **[Required]** Gets the managed_object_attribute_name of this MappedAttributeAttributeMappings.
        The name or expression of an attribute defined in the schema of the Managed Object Class. This is the SCIM compliant Oracle Identity Cloud Service Name of the attribute that maps to the \\\"idcsName\\\" attribute in the schema of an Managed Object Class.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The managed_object_attribute_name of this MappedAttributeAttributeMappings.
        :rtype: str
        """
        return self._managed_object_attribute_name

    @managed_object_attribute_name.setter
    def managed_object_attribute_name(self, managed_object_attribute_name):
        """
        Sets the managed_object_attribute_name of this MappedAttributeAttributeMappings.
        The name or expression of an attribute defined in the schema of the Managed Object Class. This is the SCIM compliant Oracle Identity Cloud Service Name of the attribute that maps to the \\\"idcsName\\\" attribute in the schema of an Managed Object Class.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param managed_object_attribute_name: The managed_object_attribute_name of this MappedAttributeAttributeMappings.
        :type: str
        """
        self._managed_object_attribute_name = managed_object_attribute_name

    @property
    def idcs_attribute_name(self):
        """
        **[Required]** Gets the idcs_attribute_name of this MappedAttributeAttributeMappings.
        The name or expression of an attribute that corresponds to the Oracle Identity Cloud Service Resource referred in the \\\"idcsResourceType\\\" attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_attribute_name of this MappedAttributeAttributeMappings.
        :rtype: str
        """
        return self._idcs_attribute_name

    @idcs_attribute_name.setter
    def idcs_attribute_name(self, idcs_attribute_name):
        """
        Sets the idcs_attribute_name of this MappedAttributeAttributeMappings.
        The name or expression of an attribute that corresponds to the Oracle Identity Cloud Service Resource referred in the \\\"idcsResourceType\\\" attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_attribute_name: The idcs_attribute_name of this MappedAttributeAttributeMappings.
        :type: str
        """
        self._idcs_attribute_name = idcs_attribute_name

    @property
    def required(self):
        """
        Gets the required of this MappedAttributeAttributeMappings.
        If true, indicates that this attribute must have a value. This attribute maps to the \\\"required\\\" sub-attribute in the schema of an Managed Object Class.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The required of this MappedAttributeAttributeMappings.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this MappedAttributeAttributeMappings.
        If true, indicates that this attribute must have a value. This attribute maps to the \\\"required\\\" sub-attribute in the schema of an Managed Object Class.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param required: The required of this MappedAttributeAttributeMappings.
        :type: bool
        """
        self._required = required

    @property
    def applies_to_actions(self):
        """
        Gets the applies_to_actions of this MappedAttributeAttributeMappings.
        If specified, indicates a subset of mappedActions to which this attribute-mapping applies.If not specified, this attribute-mapping applies to all mappedActions that use mappedAttributes

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "create", "update", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The applies_to_actions of this MappedAttributeAttributeMappings.
        :rtype: list[str]
        """
        return self._applies_to_actions

    @applies_to_actions.setter
    def applies_to_actions(self, applies_to_actions):
        """
        Sets the applies_to_actions of this MappedAttributeAttributeMappings.
        If specified, indicates a subset of mappedActions to which this attribute-mapping applies.If not specified, this attribute-mapping applies to all mappedActions that use mappedAttributes

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param applies_to_actions: The applies_to_actions of this MappedAttributeAttributeMappings.
        :type: list[str]
        """
        allowed_values = ["create", "update"]
        if applies_to_actions:
            applies_to_actions[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in applies_to_actions]
        self._applies_to_actions = applies_to_actions

    @property
    def saml_format(self):
        """
        Gets the saml_format of this MappedAttributeAttributeMappings.
        Indicates the format of the assertion attribute. Also stores AttributeNamespace for WSFed1.1.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The saml_format of this MappedAttributeAttributeMappings.
        :rtype: str
        """
        return self._saml_format

    @saml_format.setter
    def saml_format(self, saml_format):
        """
        Sets the saml_format of this MappedAttributeAttributeMappings.
        Indicates the format of the assertion attribute. Also stores AttributeNamespace for WSFed1.1.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param saml_format: The saml_format of this MappedAttributeAttributeMappings.
        :type: str
        """
        self._saml_format = saml_format

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
