# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDigitalTwinInstanceDetails(object):
    """
    The information about new digital twin instance to be created.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDigitalTwinInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param iot_domain_id:
            The value to assign to the iot_domain_id property of this CreateDigitalTwinInstanceDetails.
        :type iot_domain_id: str

        :param auth_id:
            The value to assign to the auth_id property of this CreateDigitalTwinInstanceDetails.
        :type auth_id: str

        :param external_key:
            The value to assign to the external_key property of this CreateDigitalTwinInstanceDetails.
        :type external_key: str

        :param display_name:
            The value to assign to the display_name property of this CreateDigitalTwinInstanceDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateDigitalTwinInstanceDetails.
        :type description: str

        :param digital_twin_adapter_id:
            The value to assign to the digital_twin_adapter_id property of this CreateDigitalTwinInstanceDetails.
        :type digital_twin_adapter_id: str

        :param digital_twin_model_id:
            The value to assign to the digital_twin_model_id property of this CreateDigitalTwinInstanceDetails.
        :type digital_twin_model_id: str

        :param digital_twin_model_spec_uri:
            The value to assign to the digital_twin_model_spec_uri property of this CreateDigitalTwinInstanceDetails.
        :type digital_twin_model_spec_uri: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDigitalTwinInstanceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDigitalTwinInstanceDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'iot_domain_id': 'str',
            'auth_id': 'str',
            'external_key': 'str',
            'display_name': 'str',
            'description': 'str',
            'digital_twin_adapter_id': 'str',
            'digital_twin_model_id': 'str',
            'digital_twin_model_spec_uri': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'iot_domain_id': 'iotDomainId',
            'auth_id': 'authId',
            'external_key': 'externalKey',
            'display_name': 'displayName',
            'description': 'description',
            'digital_twin_adapter_id': 'digitalTwinAdapterId',
            'digital_twin_model_id': 'digitalTwinModelId',
            'digital_twin_model_spec_uri': 'digitalTwinModelSpecUri',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._iot_domain_id = None
        self._auth_id = None
        self._external_key = None
        self._display_name = None
        self._description = None
        self._digital_twin_adapter_id = None
        self._digital_twin_model_id = None
        self._digital_twin_model_spec_uri = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def iot_domain_id(self):
        """
        **[Required]** Gets the iot_domain_id of this CreateDigitalTwinInstanceDetails.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The iot_domain_id of this CreateDigitalTwinInstanceDetails.
        :rtype: str
        """
        return self._iot_domain_id

    @iot_domain_id.setter
    def iot_domain_id(self, iot_domain_id):
        """
        Sets the iot_domain_id of this CreateDigitalTwinInstanceDetails.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param iot_domain_id: The iot_domain_id of this CreateDigitalTwinInstanceDetails.
        :type: str
        """
        self._iot_domain_id = iot_domain_id

    @property
    def auth_id(self):
        """
        Gets the auth_id of this CreateDigitalTwinInstanceDetails.
        The `OCID`__ of the resource (like VaultSecret, ClientCertificate etc.,) used to authenticate the digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The auth_id of this CreateDigitalTwinInstanceDetails.
        :rtype: str
        """
        return self._auth_id

    @auth_id.setter
    def auth_id(self, auth_id):
        """
        Sets the auth_id of this CreateDigitalTwinInstanceDetails.
        The `OCID`__ of the resource (like VaultSecret, ClientCertificate etc.,) used to authenticate the digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param auth_id: The auth_id of this CreateDigitalTwinInstanceDetails.
        :type: str
        """
        self._auth_id = auth_id

    @property
    def external_key(self):
        """
        Gets the external_key of this CreateDigitalTwinInstanceDetails.
        A unique identifier for the physical entity (typically an IoT device) represented by the digital twin instance.
        This could be a Bluetooth address, Ethernet MAC address, or serial number, depending on the use case.
        If not provided, the system will automatically generate one.


        :return: The external_key of this CreateDigitalTwinInstanceDetails.
        :rtype: str
        """
        return self._external_key

    @external_key.setter
    def external_key(self, external_key):
        """
        Sets the external_key of this CreateDigitalTwinInstanceDetails.
        A unique identifier for the physical entity (typically an IoT device) represented by the digital twin instance.
        This could be a Bluetooth address, Ethernet MAC address, or serial number, depending on the use case.
        If not provided, the system will automatically generate one.


        :param external_key: The external_key of this CreateDigitalTwinInstanceDetails.
        :type: str
        """
        self._external_key = external_key

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateDigitalTwinInstanceDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateDigitalTwinInstanceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDigitalTwinInstanceDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateDigitalTwinInstanceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateDigitalTwinInstanceDetails.
        A short description of the resource.


        :return: The description of this CreateDigitalTwinInstanceDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateDigitalTwinInstanceDetails.
        A short description of the resource.


        :param description: The description of this CreateDigitalTwinInstanceDetails.
        :type: str
        """
        self._description = description

    @property
    def digital_twin_adapter_id(self):
        """
        Gets the digital_twin_adapter_id of this CreateDigitalTwinInstanceDetails.
        The `OCID`__ of the digital twin adapter.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The digital_twin_adapter_id of this CreateDigitalTwinInstanceDetails.
        :rtype: str
        """
        return self._digital_twin_adapter_id

    @digital_twin_adapter_id.setter
    def digital_twin_adapter_id(self, digital_twin_adapter_id):
        """
        Sets the digital_twin_adapter_id of this CreateDigitalTwinInstanceDetails.
        The `OCID`__ of the digital twin adapter.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param digital_twin_adapter_id: The digital_twin_adapter_id of this CreateDigitalTwinInstanceDetails.
        :type: str
        """
        self._digital_twin_adapter_id = digital_twin_adapter_id

    @property
    def digital_twin_model_id(self):
        """
        Gets the digital_twin_model_id of this CreateDigitalTwinInstanceDetails.
        The `OCID`__ of the digital twin model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The digital_twin_model_id of this CreateDigitalTwinInstanceDetails.
        :rtype: str
        """
        return self._digital_twin_model_id

    @digital_twin_model_id.setter
    def digital_twin_model_id(self, digital_twin_model_id):
        """
        Sets the digital_twin_model_id of this CreateDigitalTwinInstanceDetails.
        The `OCID`__ of the digital twin model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param digital_twin_model_id: The digital_twin_model_id of this CreateDigitalTwinInstanceDetails.
        :type: str
        """
        self._digital_twin_model_id = digital_twin_model_id

    @property
    def digital_twin_model_spec_uri(self):
        """
        Gets the digital_twin_model_spec_uri of this CreateDigitalTwinInstanceDetails.
        The URI of the digital twin model specification.


        :return: The digital_twin_model_spec_uri of this CreateDigitalTwinInstanceDetails.
        :rtype: str
        """
        return self._digital_twin_model_spec_uri

    @digital_twin_model_spec_uri.setter
    def digital_twin_model_spec_uri(self, digital_twin_model_spec_uri):
        """
        Sets the digital_twin_model_spec_uri of this CreateDigitalTwinInstanceDetails.
        The URI of the digital twin model specification.


        :param digital_twin_model_spec_uri: The digital_twin_model_spec_uri of this CreateDigitalTwinInstanceDetails.
        :type: str
        """
        self._digital_twin_model_spec_uri = digital_twin_model_spec_uri

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDigitalTwinInstanceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateDigitalTwinInstanceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDigitalTwinInstanceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateDigitalTwinInstanceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDigitalTwinInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateDigitalTwinInstanceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDigitalTwinInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateDigitalTwinInstanceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
