# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDigitalTwinModelDetails(object):
    """
    The information about new digital twin model to be created.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDigitalTwinModelDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param iot_domain_id:
            The value to assign to the iot_domain_id property of this CreateDigitalTwinModelDetails.
        :type iot_domain_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateDigitalTwinModelDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateDigitalTwinModelDetails.
        :type description: str

        :param spec:
            The value to assign to the spec property of this CreateDigitalTwinModelDetails.
        :type spec: dict(str, object)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDigitalTwinModelDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDigitalTwinModelDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'iot_domain_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'spec': 'dict(str, object)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'iot_domain_id': 'iotDomainId',
            'display_name': 'displayName',
            'description': 'description',
            'spec': 'spec',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._iot_domain_id = None
        self._display_name = None
        self._description = None
        self._spec = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def iot_domain_id(self):
        """
        **[Required]** Gets the iot_domain_id of this CreateDigitalTwinModelDetails.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The iot_domain_id of this CreateDigitalTwinModelDetails.
        :rtype: str
        """
        return self._iot_domain_id

    @iot_domain_id.setter
    def iot_domain_id(self, iot_domain_id):
        """
        Sets the iot_domain_id of this CreateDigitalTwinModelDetails.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param iot_domain_id: The iot_domain_id of this CreateDigitalTwinModelDetails.
        :type: str
        """
        self._iot_domain_id = iot_domain_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateDigitalTwinModelDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        If left blank, the display name will be derived from the spec.


        :return: The display_name of this CreateDigitalTwinModelDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDigitalTwinModelDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        If left blank, the display name will be derived from the spec.


        :param display_name: The display_name of this CreateDigitalTwinModelDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateDigitalTwinModelDetails.
        A short description of the resource. If left blank, the description will be derived from the spec.


        :return: The description of this CreateDigitalTwinModelDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateDigitalTwinModelDetails.
        A short description of the resource. If left blank, the description will be derived from the spec.


        :param description: The description of this CreateDigitalTwinModelDetails.
        :type: str
        """
        self._description = description

    @property
    def spec(self):
        """
        **[Required]** Gets the spec of this CreateDigitalTwinModelDetails.
        The specification of the digital twin model (DTDL).


        :return: The spec of this CreateDigitalTwinModelDetails.
        :rtype: dict(str, object)
        """
        return self._spec

    @spec.setter
    def spec(self, spec):
        """
        Sets the spec of this CreateDigitalTwinModelDetails.
        The specification of the digital twin model (DTDL).


        :param spec: The spec of this CreateDigitalTwinModelDetails.
        :type: dict(str, object)
        """
        self._spec = spec

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDigitalTwinModelDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateDigitalTwinModelDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDigitalTwinModelDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateDigitalTwinModelDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDigitalTwinModelDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateDigitalTwinModelDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDigitalTwinModelDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateDigitalTwinModelDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
