# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DigitalTwinAdapterEnvelopeMapping(object):
    """
    Maps the metadata fields from the inbound payload using JQ.
    These mappings allow you to extract specific metadata such as timestamps using JQ expressions.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DigitalTwinAdapterEnvelopeMapping object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_observed:
            The value to assign to the time_observed property of this DigitalTwinAdapterEnvelopeMapping.
        :type time_observed: str

        """
        self.swagger_types = {
            'time_observed': 'str'
        }
        self.attribute_map = {
            'time_observed': 'timeObserved'
        }
        self._time_observed = None

    @property
    def time_observed(self):
        """
        Gets the time_observed of this DigitalTwinAdapterEnvelopeMapping.
        JQ expression to extract the observation timestamp from the payload. If not specified,
        the system will default to using `timeReceived` as the timestamp.

        Example: For payload `{\"time\": \"<timestamp>\",\"temp\": 65,\"hum\": 55}`
        'timeObserved' can be mapped as `JQ Expression`__ `$.time`.

        __ https://jqplay.org/


        :return: The time_observed of this DigitalTwinAdapterEnvelopeMapping.
        :rtype: str
        """
        return self._time_observed

    @time_observed.setter
    def time_observed(self, time_observed):
        """
        Sets the time_observed of this DigitalTwinAdapterEnvelopeMapping.
        JQ expression to extract the observation timestamp from the payload. If not specified,
        the system will default to using `timeReceived` as the timestamp.

        Example: For payload `{\"time\": \"<timestamp>\",\"temp\": 65,\"hum\": 55}`
        'timeObserved' can be mapped as `JQ Expression`__ `$.time`.

        __ https://jqplay.org/


        :param time_observed: The time_observed of this DigitalTwinAdapterEnvelopeMapping.
        :type: str
        """
        self._time_observed = time_observed

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
