# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LibraryUsage(object):
    """
    Library usage during a specified time period.
    """

    #: A constant which can be used with the confidence_level property of a LibraryUsage.
    #: This constant has a value of "HIGH"
    CONFIDENCE_LEVEL_HIGH = "HIGH"

    #: A constant which can be used with the confidence_level property of a LibraryUsage.
    #: This constant has a value of "MEDIUM"
    CONFIDENCE_LEVEL_MEDIUM = "MEDIUM"

    #: A constant which can be used with the confidence_level property of a LibraryUsage.
    #: This constant has a value of "LOW"
    CONFIDENCE_LEVEL_LOW = "LOW"

    def __init__(self, **kwargs):
        """
        Initializes a new LibraryUsage object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param library_key:
            The value to assign to the library_key property of this LibraryUsage.
        :type library_key: str

        :param fleet_id:
            The value to assign to the fleet_id property of this LibraryUsage.
        :type fleet_id: str

        :param library_name:
            The value to assign to the library_name property of this LibraryUsage.
        :type library_name: str

        :param library_version:
            The value to assign to the library_version property of this LibraryUsage.
        :type library_version: str

        :param cve_id:
            The value to assign to the cve_id property of this LibraryUsage.
        :type cve_id: str

        :param cvss_score:
            The value to assign to the cvss_score property of this LibraryUsage.
        :type cvss_score: float

        :param is_dynamically_detected:
            The value to assign to the is_dynamically_detected property of this LibraryUsage.
        :type is_dynamically_detected: bool

        :param highest_vulnerability_score:
            The value to assign to the highest_vulnerability_score property of this LibraryUsage.
        :type highest_vulnerability_score: float

        :param vulnerabilities:
            The value to assign to the vulnerabilities property of this LibraryUsage.
        :type vulnerabilities: list[oci.jms.models.LibraryVulnerability]

        :param confidence_level:
            The value to assign to the confidence_level property of this LibraryUsage.
            Allowed values for this property are: "HIGH", "MEDIUM", "LOW", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type confidence_level: str

        :param approximate_application_count:
            The value to assign to the approximate_application_count property of this LibraryUsage.
        :type approximate_application_count: int

        :param approximate_java_server_instance_count:
            The value to assign to the approximate_java_server_instance_count property of this LibraryUsage.
        :type approximate_java_server_instance_count: int

        :param approximate_deployed_application_count:
            The value to assign to the approximate_deployed_application_count property of this LibraryUsage.
        :type approximate_deployed_application_count: int

        :param approximate_managed_instance_count:
            The value to assign to the approximate_managed_instance_count property of this LibraryUsage.
        :type approximate_managed_instance_count: int

        :param time_start:
            The value to assign to the time_start property of this LibraryUsage.
        :type time_start: datetime

        :param time_end:
            The value to assign to the time_end property of this LibraryUsage.
        :type time_end: datetime

        :param time_first_seen:
            The value to assign to the time_first_seen property of this LibraryUsage.
        :type time_first_seen: datetime

        :param time_last_seen:
            The value to assign to the time_last_seen property of this LibraryUsage.
        :type time_last_seen: datetime

        :param time_last_cve_refreshed:
            The value to assign to the time_last_cve_refreshed property of this LibraryUsage.
        :type time_last_cve_refreshed: datetime

        """
        self.swagger_types = {
            'library_key': 'str',
            'fleet_id': 'str',
            'library_name': 'str',
            'library_version': 'str',
            'cve_id': 'str',
            'cvss_score': 'float',
            'is_dynamically_detected': 'bool',
            'highest_vulnerability_score': 'float',
            'vulnerabilities': 'list[LibraryVulnerability]',
            'confidence_level': 'str',
            'approximate_application_count': 'int',
            'approximate_java_server_instance_count': 'int',
            'approximate_deployed_application_count': 'int',
            'approximate_managed_instance_count': 'int',
            'time_start': 'datetime',
            'time_end': 'datetime',
            'time_first_seen': 'datetime',
            'time_last_seen': 'datetime',
            'time_last_cve_refreshed': 'datetime'
        }
        self.attribute_map = {
            'library_key': 'libraryKey',
            'fleet_id': 'fleetId',
            'library_name': 'libraryName',
            'library_version': 'libraryVersion',
            'cve_id': 'cveId',
            'cvss_score': 'cvssScore',
            'is_dynamically_detected': 'isDynamicallyDetected',
            'highest_vulnerability_score': 'highestVulnerabilityScore',
            'vulnerabilities': 'vulnerabilities',
            'confidence_level': 'confidenceLevel',
            'approximate_application_count': 'approximateApplicationCount',
            'approximate_java_server_instance_count': 'approximateJavaServerInstanceCount',
            'approximate_deployed_application_count': 'approximateDeployedApplicationCount',
            'approximate_managed_instance_count': 'approximateManagedInstanceCount',
            'time_start': 'timeStart',
            'time_end': 'timeEnd',
            'time_first_seen': 'timeFirstSeen',
            'time_last_seen': 'timeLastSeen',
            'time_last_cve_refreshed': 'timeLastCveRefreshed'
        }
        self._library_key = None
        self._fleet_id = None
        self._library_name = None
        self._library_version = None
        self._cve_id = None
        self._cvss_score = None
        self._is_dynamically_detected = None
        self._highest_vulnerability_score = None
        self._vulnerabilities = None
        self._confidence_level = None
        self._approximate_application_count = None
        self._approximate_java_server_instance_count = None
        self._approximate_deployed_application_count = None
        self._approximate_managed_instance_count = None
        self._time_start = None
        self._time_end = None
        self._time_first_seen = None
        self._time_last_seen = None
        self._time_last_cve_refreshed = None

    @property
    def library_key(self):
        """
        **[Required]** Gets the library_key of this LibraryUsage.
        The internal identifier of the library.


        :return: The library_key of this LibraryUsage.
        :rtype: str
        """
        return self._library_key

    @library_key.setter
    def library_key(self, library_key):
        """
        Sets the library_key of this LibraryUsage.
        The internal identifier of the library.


        :param library_key: The library_key of this LibraryUsage.
        :type: str
        """
        self._library_key = library_key

    @property
    def fleet_id(self):
        """
        **[Required]** Gets the fleet_id of this LibraryUsage.
        The `OCID`__ of the related fleet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The fleet_id of this LibraryUsage.
        :rtype: str
        """
        return self._fleet_id

    @fleet_id.setter
    def fleet_id(self, fleet_id):
        """
        Sets the fleet_id of this LibraryUsage.
        The `OCID`__ of the related fleet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param fleet_id: The fleet_id of this LibraryUsage.
        :type: str
        """
        self._fleet_id = fleet_id

    @property
    def library_name(self):
        """
        **[Required]** Gets the library_name of this LibraryUsage.
        The name of the library.


        :return: The library_name of this LibraryUsage.
        :rtype: str
        """
        return self._library_name

    @library_name.setter
    def library_name(self, library_name):
        """
        Sets the library_name of this LibraryUsage.
        The name of the library.


        :param library_name: The library_name of this LibraryUsage.
        :type: str
        """
        self._library_name = library_name

    @property
    def library_version(self):
        """
        Gets the library_version of this LibraryUsage.
        The version of the library.


        :return: The library_version of this LibraryUsage.
        :rtype: str
        """
        return self._library_version

    @library_version.setter
    def library_version(self, library_version):
        """
        Sets the library_version of this LibraryUsage.
        The version of the library.


        :param library_version: The library_version of this LibraryUsage.
        :type: str
        """
        self._library_version = library_version

    @property
    def cve_id(self):
        """
        Gets the cve_id of this LibraryUsage.
        Deprecated, use `vulnerabilities` instead.
        The Common Vulnerabilities and Exposures (CVE) ID.


        :return: The cve_id of this LibraryUsage.
        :rtype: str
        """
        return self._cve_id

    @cve_id.setter
    def cve_id(self, cve_id):
        """
        Sets the cve_id of this LibraryUsage.
        Deprecated, use `vulnerabilities` instead.
        The Common Vulnerabilities and Exposures (CVE) ID.


        :param cve_id: The cve_id of this LibraryUsage.
        :type: str
        """
        self._cve_id = cve_id

    @property
    def cvss_score(self):
        """
        Gets the cvss_score of this LibraryUsage.
        Deprecated, use `highestVulnerabilityScore` instead.
        The Common Vulnerability Scoring System (CVSS) score. If `cvssScore` is not available, it will be set to -1.0. It is set to 0.0 when `cveId` is null.


        :return: The cvss_score of this LibraryUsage.
        :rtype: float
        """
        return self._cvss_score

    @cvss_score.setter
    def cvss_score(self, cvss_score):
        """
        Sets the cvss_score of this LibraryUsage.
        Deprecated, use `highestVulnerabilityScore` instead.
        The Common Vulnerability Scoring System (CVSS) score. If `cvssScore` is not available, it will be set to -1.0. It is set to 0.0 when `cveId` is null.


        :param cvss_score: The cvss_score of this LibraryUsage.
        :type: float
        """
        self._cvss_score = cvss_score

    @property
    def is_dynamically_detected(self):
        """
        **[Required]** Gets the is_dynamically_detected of this LibraryUsage.
        Indicates whether the library was dynamically detected.


        :return: The is_dynamically_detected of this LibraryUsage.
        :rtype: bool
        """
        return self._is_dynamically_detected

    @is_dynamically_detected.setter
    def is_dynamically_detected(self, is_dynamically_detected):
        """
        Sets the is_dynamically_detected of this LibraryUsage.
        Indicates whether the library was dynamically detected.


        :param is_dynamically_detected: The is_dynamically_detected of this LibraryUsage.
        :type: bool
        """
        self._is_dynamically_detected = is_dynamically_detected

    @property
    def highest_vulnerability_score(self):
        """
        Gets the highest_vulnerability_score of this LibraryUsage.
        Highest CVSS score among the all vulnerabilities. If highest CVSS score is not available, it will be set to -1.0. It is set to 0.0 when there is no associated vulnerabilities.


        :return: The highest_vulnerability_score of this LibraryUsage.
        :rtype: float
        """
        return self._highest_vulnerability_score

    @highest_vulnerability_score.setter
    def highest_vulnerability_score(self, highest_vulnerability_score):
        """
        Sets the highest_vulnerability_score of this LibraryUsage.
        Highest CVSS score among the all vulnerabilities. If highest CVSS score is not available, it will be set to -1.0. It is set to 0.0 when there is no associated vulnerabilities.


        :param highest_vulnerability_score: The highest_vulnerability_score of this LibraryUsage.
        :type: float
        """
        self._highest_vulnerability_score = highest_vulnerability_score

    @property
    def vulnerabilities(self):
        """
        Gets the vulnerabilities of this LibraryUsage.
        The list of library vulnerabilities.


        :return: The vulnerabilities of this LibraryUsage.
        :rtype: list[oci.jms.models.LibraryVulnerability]
        """
        return self._vulnerabilities

    @vulnerabilities.setter
    def vulnerabilities(self, vulnerabilities):
        """
        Sets the vulnerabilities of this LibraryUsage.
        The list of library vulnerabilities.


        :param vulnerabilities: The vulnerabilities of this LibraryUsage.
        :type: list[oci.jms.models.LibraryVulnerability]
        """
        self._vulnerabilities = vulnerabilities

    @property
    def confidence_level(self):
        """
        Gets the confidence_level of this LibraryUsage.
        Confidence level of the assessed library's vulnerabilities.

        Allowed values for this property are: "HIGH", "MEDIUM", "LOW", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The confidence_level of this LibraryUsage.
        :rtype: str
        """
        return self._confidence_level

    @confidence_level.setter
    def confidence_level(self, confidence_level):
        """
        Sets the confidence_level of this LibraryUsage.
        Confidence level of the assessed library's vulnerabilities.


        :param confidence_level: The confidence_level of this LibraryUsage.
        :type: str
        """
        allowed_values = ["HIGH", "MEDIUM", "LOW"]
        if not value_allowed_none_or_none_sentinel(confidence_level, allowed_values):
            confidence_level = 'UNKNOWN_ENUM_VALUE'
        self._confidence_level = confidence_level

    @property
    def approximate_application_count(self):
        """
        Gets the approximate_application_count of this LibraryUsage.
        The approximate count of applications using the library.


        :return: The approximate_application_count of this LibraryUsage.
        :rtype: int
        """
        return self._approximate_application_count

    @approximate_application_count.setter
    def approximate_application_count(self, approximate_application_count):
        """
        Sets the approximate_application_count of this LibraryUsage.
        The approximate count of applications using the library.


        :param approximate_application_count: The approximate_application_count of this LibraryUsage.
        :type: int
        """
        self._approximate_application_count = approximate_application_count

    @property
    def approximate_java_server_instance_count(self):
        """
        Gets the approximate_java_server_instance_count of this LibraryUsage.
        The approximate count of Java Server instances using the library.


        :return: The approximate_java_server_instance_count of this LibraryUsage.
        :rtype: int
        """
        return self._approximate_java_server_instance_count

    @approximate_java_server_instance_count.setter
    def approximate_java_server_instance_count(self, approximate_java_server_instance_count):
        """
        Sets the approximate_java_server_instance_count of this LibraryUsage.
        The approximate count of Java Server instances using the library.


        :param approximate_java_server_instance_count: The approximate_java_server_instance_count of this LibraryUsage.
        :type: int
        """
        self._approximate_java_server_instance_count = approximate_java_server_instance_count

    @property
    def approximate_deployed_application_count(self):
        """
        Gets the approximate_deployed_application_count of this LibraryUsage.
        The approximate count of deployed applications using the library.


        :return: The approximate_deployed_application_count of this LibraryUsage.
        :rtype: int
        """
        return self._approximate_deployed_application_count

    @approximate_deployed_application_count.setter
    def approximate_deployed_application_count(self, approximate_deployed_application_count):
        """
        Sets the approximate_deployed_application_count of this LibraryUsage.
        The approximate count of deployed applications using the library.


        :param approximate_deployed_application_count: The approximate_deployed_application_count of this LibraryUsage.
        :type: int
        """
        self._approximate_deployed_application_count = approximate_deployed_application_count

    @property
    def approximate_managed_instance_count(self):
        """
        Gets the approximate_managed_instance_count of this LibraryUsage.
        The approximate count of managed instances using the library.


        :return: The approximate_managed_instance_count of this LibraryUsage.
        :rtype: int
        """
        return self._approximate_managed_instance_count

    @approximate_managed_instance_count.setter
    def approximate_managed_instance_count(self, approximate_managed_instance_count):
        """
        Sets the approximate_managed_instance_count of this LibraryUsage.
        The approximate count of managed instances using the library.


        :param approximate_managed_instance_count: The approximate_managed_instance_count of this LibraryUsage.
        :type: int
        """
        self._approximate_managed_instance_count = approximate_managed_instance_count

    @property
    def time_start(self):
        """
        Gets the time_start of this LibraryUsage.
        Lower bound of the specified time period filter. JMS provides a view of the data that is _per day_. The query uses only the date element of the parameter.


        :return: The time_start of this LibraryUsage.
        :rtype: datetime
        """
        return self._time_start

    @time_start.setter
    def time_start(self, time_start):
        """
        Sets the time_start of this LibraryUsage.
        Lower bound of the specified time period filter. JMS provides a view of the data that is _per day_. The query uses only the date element of the parameter.


        :param time_start: The time_start of this LibraryUsage.
        :type: datetime
        """
        self._time_start = time_start

    @property
    def time_end(self):
        """
        Gets the time_end of this LibraryUsage.
        Upper bound of the specified time period filter. JMS provides a view of the data that is _per day_. The query uses only the date element of the parameter.


        :return: The time_end of this LibraryUsage.
        :rtype: datetime
        """
        return self._time_end

    @time_end.setter
    def time_end(self, time_end):
        """
        Sets the time_end of this LibraryUsage.
        Upper bound of the specified time period filter. JMS provides a view of the data that is _per day_. The query uses only the date element of the parameter.


        :param time_end: The time_end of this LibraryUsage.
        :type: datetime
        """
        self._time_end = time_end

    @property
    def time_first_seen(self):
        """
        Gets the time_first_seen of this LibraryUsage.
        The date and time the resource was _first_ reported to JMS.
        This is potentially _before_ the specified time period provided by the filters.
        For example, a resource can be first reported to JMS before the start of a specified time period,
        if it is also reported during the time period.


        :return: The time_first_seen of this LibraryUsage.
        :rtype: datetime
        """
        return self._time_first_seen

    @time_first_seen.setter
    def time_first_seen(self, time_first_seen):
        """
        Sets the time_first_seen of this LibraryUsage.
        The date and time the resource was _first_ reported to JMS.
        This is potentially _before_ the specified time period provided by the filters.
        For example, a resource can be first reported to JMS before the start of a specified time period,
        if it is also reported during the time period.


        :param time_first_seen: The time_first_seen of this LibraryUsage.
        :type: datetime
        """
        self._time_first_seen = time_first_seen

    @property
    def time_last_seen(self):
        """
        Gets the time_last_seen of this LibraryUsage.
        The date and time the resource was _last_ reported to JMS.
        This is potentially _after_ the specified time period provided by the filters.
        For example, a resource can be last reported to JMS before the start of a specified time period,
        if it is also reported during the time period.


        :return: The time_last_seen of this LibraryUsage.
        :rtype: datetime
        """
        return self._time_last_seen

    @time_last_seen.setter
    def time_last_seen(self, time_last_seen):
        """
        Sets the time_last_seen of this LibraryUsage.
        The date and time the resource was _last_ reported to JMS.
        This is potentially _after_ the specified time period provided by the filters.
        For example, a resource can be last reported to JMS before the start of a specified time period,
        if it is also reported during the time period.


        :param time_last_seen: The time_last_seen of this LibraryUsage.
        :type: datetime
        """
        self._time_last_seen = time_last_seen

    @property
    def time_last_cve_refreshed(self):
        """
        Gets the time_last_cve_refreshed of this LibraryUsage.
        Deprecated.
        The date and time of the last CVEs refresh was completed.


        :return: The time_last_cve_refreshed of this LibraryUsage.
        :rtype: datetime
        """
        return self._time_last_cve_refreshed

    @time_last_cve_refreshed.setter
    def time_last_cve_refreshed(self, time_last_cve_refreshed):
        """
        Sets the time_last_cve_refreshed of this LibraryUsage.
        Deprecated.
        The date and time of the last CVEs refresh was completed.


        :param time_last_cve_refreshed: The time_last_cve_refreshed of this LibraryUsage.
        :type: datetime
        """
        self._time_last_cve_refreshed = time_last_cve_refreshed

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
