# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateTaskScheduleDetails(object):
    """
    Attributes to update a task schedule.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateTaskScheduleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param fleet_id:
            The value to assign to the fleet_id property of this UpdateTaskScheduleDetails.
        :type fleet_id: str

        :param execution_recurrences:
            The value to assign to the execution_recurrences property of this UpdateTaskScheduleDetails.
        :type execution_recurrences: str

        :param task_details:
            The value to assign to the task_details property of this UpdateTaskScheduleDetails.
        :type task_details: oci.jms.models.TaskDetails

        """
        self.swagger_types = {
            'fleet_id': 'str',
            'execution_recurrences': 'str',
            'task_details': 'TaskDetails'
        }
        self.attribute_map = {
            'fleet_id': 'fleetId',
            'execution_recurrences': 'executionRecurrences',
            'task_details': 'taskDetails'
        }
        self._fleet_id = None
        self._execution_recurrences = None
        self._task_details = None

    @property
    def fleet_id(self):
        """
        **[Required]** Gets the fleet_id of this UpdateTaskScheduleDetails.
        The `OCID`__ of the Fleet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The fleet_id of this UpdateTaskScheduleDetails.
        :rtype: str
        """
        return self._fleet_id

    @fleet_id.setter
    def fleet_id(self, fleet_id):
        """
        Sets the fleet_id of this UpdateTaskScheduleDetails.
        The `OCID`__ of the Fleet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param fleet_id: The fleet_id of this UpdateTaskScheduleDetails.
        :type: str
        """
        self._fleet_id = fleet_id

    @property
    def execution_recurrences(self):
        """
        **[Required]** Gets the execution_recurrences of this UpdateTaskScheduleDetails.
        Recurrence specification for the task schedule execution (formatted according to `RFC-5545`__). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000
        RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.

        __ https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/


        :return: The execution_recurrences of this UpdateTaskScheduleDetails.
        :rtype: str
        """
        return self._execution_recurrences

    @execution_recurrences.setter
    def execution_recurrences(self, execution_recurrences):
        """
        Sets the execution_recurrences of this UpdateTaskScheduleDetails.
        Recurrence specification for the task schedule execution (formatted according to `RFC-5545`__). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000
        RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.

        __ https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/


        :param execution_recurrences: The execution_recurrences of this UpdateTaskScheduleDetails.
        :type: str
        """
        self._execution_recurrences = execution_recurrences

    @property
    def task_details(self):
        """
        **[Required]** Gets the task_details of this UpdateTaskScheduleDetails.

        :return: The task_details of this UpdateTaskScheduleDetails.
        :rtype: oci.jms.models.TaskDetails
        """
        return self._task_details

    @task_details.setter
    def task_details(self, task_details):
        """
        Sets the task_details of this UpdateTaskScheduleDetails.

        :param task_details: The task_details of this UpdateTaskScheduleDetails.
        :type: oci.jms.models.TaskDetails
        """
        self._task_details = task_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
