# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateJavaLicenseAcceptanceRecordDetails(object):
    """
    The attributes for updating a Java license acceptance record.
    """

    #: A constant which can be used with the license_acceptance_status property of a UpdateJavaLicenseAcceptanceRecordDetails.
    #: This constant has a value of "ACCEPTED"
    LICENSE_ACCEPTANCE_STATUS_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the license_acceptance_status property of a UpdateJavaLicenseAcceptanceRecordDetails.
    #: This constant has a value of "REVOKED"
    LICENSE_ACCEPTANCE_STATUS_REVOKED = "REVOKED"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateJavaLicenseAcceptanceRecordDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param license_acceptance_status:
            The value to assign to the license_acceptance_status property of this UpdateJavaLicenseAcceptanceRecordDetails.
            Allowed values for this property are: "ACCEPTED", "REVOKED"
        :type license_acceptance_status: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateJavaLicenseAcceptanceRecordDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateJavaLicenseAcceptanceRecordDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'license_acceptance_status': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'license_acceptance_status': 'licenseAcceptanceStatus',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._license_acceptance_status = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def license_acceptance_status(self):
        """
        **[Required]** Gets the license_acceptance_status of this UpdateJavaLicenseAcceptanceRecordDetails.
        Status of license acceptance.

        Allowed values for this property are: "ACCEPTED", "REVOKED"


        :return: The license_acceptance_status of this UpdateJavaLicenseAcceptanceRecordDetails.
        :rtype: str
        """
        return self._license_acceptance_status

    @license_acceptance_status.setter
    def license_acceptance_status(self, license_acceptance_status):
        """
        Sets the license_acceptance_status of this UpdateJavaLicenseAcceptanceRecordDetails.
        Status of license acceptance.


        :param license_acceptance_status: The license_acceptance_status of this UpdateJavaLicenseAcceptanceRecordDetails.
        :type: str
        """
        allowed_values = ["ACCEPTED", "REVOKED"]
        if not value_allowed_none_or_none_sentinel(license_acceptance_status, allowed_values):
            raise ValueError(
                f"Invalid value for `license_acceptance_status`, must be None or one of {allowed_values}"
            )
        self._license_acceptance_status = license_acceptance_status

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateJavaLicenseAcceptanceRecordDetails.
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`. (See `Managing Tags and Tag Namespaces`__.)

        __ https://docs.cloud.oracle.com/Content/Tagging/Concepts/understandingfreeformtags.htm


        :return: The freeform_tags of this UpdateJavaLicenseAcceptanceRecordDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateJavaLicenseAcceptanceRecordDetails.
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`. (See `Managing Tags and Tag Namespaces`__.)

        __ https://docs.cloud.oracle.com/Content/Tagging/Concepts/understandingfreeformtags.htm


        :param freeform_tags: The freeform_tags of this UpdateJavaLicenseAcceptanceRecordDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateJavaLicenseAcceptanceRecordDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`. (See `Understanding Free-form Tags`__).

        __ https://docs.cloud.oracle.com/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm


        :return: The defined_tags of this UpdateJavaLicenseAcceptanceRecordDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateJavaLicenseAcceptanceRecordDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`. (See `Understanding Free-form Tags`__).

        __ https://docs.cloud.oracle.com/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm


        :param defined_tags: The defined_tags of this UpdateJavaLicenseAcceptanceRecordDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
