# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: release

from .replica_vault_metadata import ReplicaVaultMetadata
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReplicaExternalVaultMetadata(ReplicaVaultMetadata):
    """
    Metadata of the replica region External Vault
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReplicaExternalVaultMetadata object with values from keyword arguments. The default value of the :py:attr:`~oci.key_management.models.ReplicaExternalVaultMetadata.vault_type` attribute
        of this class is ``EXTERNAL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vault_type:
            The value to assign to the vault_type property of this ReplicaExternalVaultMetadata.
            Allowed values for this property are: "EXTERNAL"
        :type vault_type: str

        :param private_endpoint_id:
            The value to assign to the private_endpoint_id property of this ReplicaExternalVaultMetadata.
        :type private_endpoint_id: str

        :param idcs_account_name_url:
            The value to assign to the idcs_account_name_url property of this ReplicaExternalVaultMetadata.
        :type idcs_account_name_url: str

        """
        self.swagger_types = {
            'vault_type': 'str',
            'private_endpoint_id': 'str',
            'idcs_account_name_url': 'str'
        }
        self.attribute_map = {
            'vault_type': 'vaultType',
            'private_endpoint_id': 'privateEndpointId',
            'idcs_account_name_url': 'idcsAccountNameUrl'
        }
        self._vault_type = None
        self._private_endpoint_id = None
        self._idcs_account_name_url = None
        self._vault_type = 'EXTERNAL'

    @property
    def private_endpoint_id(self):
        """
        **[Required]** Gets the private_endpoint_id of this ReplicaExternalVaultMetadata.
        OCID of the EKMS private endpoint in the replica region and must be in ACTIVE state


        :return: The private_endpoint_id of this ReplicaExternalVaultMetadata.
        :rtype: str
        """
        return self._private_endpoint_id

    @private_endpoint_id.setter
    def private_endpoint_id(self, private_endpoint_id):
        """
        Sets the private_endpoint_id of this ReplicaExternalVaultMetadata.
        OCID of the EKMS private endpoint in the replica region and must be in ACTIVE state


        :param private_endpoint_id: The private_endpoint_id of this ReplicaExternalVaultMetadata.
        :type: str
        """
        self._private_endpoint_id = private_endpoint_id

    @property
    def idcs_account_name_url(self):
        """
        **[Required]** Gets the idcs_account_name_url of this ReplicaExternalVaultMetadata.
        Replica region URL of the IDCS domain


        :return: The idcs_account_name_url of this ReplicaExternalVaultMetadata.
        :rtype: str
        """
        return self._idcs_account_name_url

    @idcs_account_name_url.setter
    def idcs_account_name_url(self, idcs_account_name_url):
        """
        Sets the idcs_account_name_url of this ReplicaExternalVaultMetadata.
        Replica region URL of the IDCS domain


        :param idcs_account_name_url: The idcs_account_name_url of this ReplicaExternalVaultMetadata.
        :type: str
        """
        self._idcs_account_name_url = idcs_account_name_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
