# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RecalledDataInfo(object):
    """
    This is the synchronous result of a recall of archived data
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RecalledDataInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param collection_name:
            The value to assign to the collection_name property of this RecalledDataInfo.
        :type collection_name: str

        :param purpose:
            The value to assign to the purpose property of this RecalledDataInfo.
        :type purpose: str

        """
        self.swagger_types = {
            'collection_name': 'str',
            'purpose': 'str'
        }
        self.attribute_map = {
            'collection_name': 'collectionName',
            'purpose': 'purpose'
        }
        self._collection_name = None
        self._purpose = None

    @property
    def collection_name(self):
        """
        **[Required]** Gets the collection_name of this RecalledDataInfo.
        This is the parent name of the list of overlapping recalls


        :return: The collection_name of this RecalledDataInfo.
        :rtype: str
        """
        return self._collection_name

    @collection_name.setter
    def collection_name(self, collection_name):
        """
        Sets the collection_name of this RecalledDataInfo.
        This is the parent name of the list of overlapping recalls


        :param collection_name: The collection_name of this RecalledDataInfo.
        :type: str
        """
        self._collection_name = collection_name

    @property
    def purpose(self):
        """
        Gets the purpose of this RecalledDataInfo.
        This is the recall name made for a specific purpose


        :return: The purpose of this RecalledDataInfo.
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose):
        """
        Sets the purpose of this RecalledDataInfo.
        This is the recall name made for a specific purpose


        :param purpose: The purpose of this RecalledDataInfo.
        :type: str
        """
        self._purpose = purpose

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
