# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RootSquashConfiguration(object):
    """
    An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
    """

    #: A constant which can be used with the identity_squash property of a RootSquashConfiguration.
    #: This constant has a value of "NONE"
    IDENTITY_SQUASH_NONE = "NONE"

    #: A constant which can be used with the identity_squash property of a RootSquashConfiguration.
    #: This constant has a value of "ROOT"
    IDENTITY_SQUASH_ROOT = "ROOT"

    def __init__(self, **kwargs):
        """
        Initializes a new RootSquashConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param identity_squash:
            The value to assign to the identity_squash property of this RootSquashConfiguration.
            Allowed values for this property are: "NONE", "ROOT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type identity_squash: str

        :param squash_uid:
            The value to assign to the squash_uid property of this RootSquashConfiguration.
        :type squash_uid: int

        :param squash_gid:
            The value to assign to the squash_gid property of this RootSquashConfiguration.
        :type squash_gid: int

        :param client_exceptions:
            The value to assign to the client_exceptions property of this RootSquashConfiguration.
        :type client_exceptions: list[str]

        """
        self.swagger_types = {
            'identity_squash': 'str',
            'squash_uid': 'int',
            'squash_gid': 'int',
            'client_exceptions': 'list[str]'
        }
        self.attribute_map = {
            'identity_squash': 'identitySquash',
            'squash_uid': 'squashUid',
            'squash_gid': 'squashGid',
            'client_exceptions': 'clientExceptions'
        }
        self._identity_squash = None
        self._squash_uid = None
        self._squash_gid = None
        self._client_exceptions = None

    @property
    def identity_squash(self):
        """
        Gets the identity_squash of this RootSquashConfiguration.
        Used when clients accessing the Lustre file system have their UID and GID remapped to
        `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped;
        if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.

        Allowed values for this property are: "NONE", "ROOT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The identity_squash of this RootSquashConfiguration.
        :rtype: str
        """
        return self._identity_squash

    @identity_squash.setter
    def identity_squash(self, identity_squash):
        """
        Sets the identity_squash of this RootSquashConfiguration.
        Used when clients accessing the Lustre file system have their UID and GID remapped to
        `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped;
        if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.


        :param identity_squash: The identity_squash of this RootSquashConfiguration.
        :type: str
        """
        allowed_values = ["NONE", "ROOT"]
        if not value_allowed_none_or_none_sentinel(identity_squash, allowed_values):
            identity_squash = 'UNKNOWN_ENUM_VALUE'
        self._identity_squash = identity_squash

    @property
    def squash_uid(self):
        """
        Gets the squash_uid of this RootSquashConfiguration.
        The UID value to remap to when squashing a client UID. See
        `identitySquash` for more details. If unspecified, defaults
        to `65534`.


        :return: The squash_uid of this RootSquashConfiguration.
        :rtype: int
        """
        return self._squash_uid

    @squash_uid.setter
    def squash_uid(self, squash_uid):
        """
        Sets the squash_uid of this RootSquashConfiguration.
        The UID value to remap to when squashing a client UID. See
        `identitySquash` for more details. If unspecified, defaults
        to `65534`.


        :param squash_uid: The squash_uid of this RootSquashConfiguration.
        :type: int
        """
        self._squash_uid = squash_uid

    @property
    def squash_gid(self):
        """
        Gets the squash_gid of this RootSquashConfiguration.
        The GID value to remap to when squashing a client GID. See
        `identitySquash` for more details. If unspecified, defaults
        to `65534`.


        :return: The squash_gid of this RootSquashConfiguration.
        :rtype: int
        """
        return self._squash_gid

    @squash_gid.setter
    def squash_gid(self, squash_gid):
        """
        Sets the squash_gid of this RootSquashConfiguration.
        The GID value to remap to when squashing a client GID. See
        `identitySquash` for more details. If unspecified, defaults
        to `65534`.


        :param squash_gid: The squash_gid of this RootSquashConfiguration.
        :type: int
        """
        self._squash_gid = squash_gid

    @property
    def client_exceptions(self):
        """
        Gets the client_exceptions of this RootSquashConfiguration.
        A list of NIDs allowed with this lustre file system not to be squashed.
        A maximum of 10 is allowed.


        :return: The client_exceptions of this RootSquashConfiguration.
        :rtype: list[str]
        """
        return self._client_exceptions

    @client_exceptions.setter
    def client_exceptions(self, client_exceptions):
        """
        Sets the client_exceptions of this RootSquashConfiguration.
        A list of NIDs allowed with this lustre file system not to be squashed.
        A maximum of 10 is allowed.


        :param client_exceptions: The client_exceptions of this RootSquashConfiguration.
        :type: list[str]
        """
        self._client_exceptions = client_exceptions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
