# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListingPart(object):
    """
    A listing SKUs and meter information attached by marketplace admin.
    """

    #: A constant which can be used with the metric_type property of a ListingPart.
    #: This constant has a value of "OCPU_HOURS"
    METRIC_TYPE_OCPU_HOURS = "OCPU_HOURS"

    #: A constant which can be used with the metric_type property of a ListingPart.
    #: This constant has a value of "INSTANCE_HOURS"
    METRIC_TYPE_INSTANCE_HOURS = "INSTANCE_HOURS"

    #: A constant which can be used with the metric_type property of a ListingPart.
    #: This constant has a value of "CORE_HOURS"
    METRIC_TYPE_CORE_HOURS = "CORE_HOURS"

    def __init__(self, **kwargs):
        """
        Initializes a new ListingPart object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sku:
            The value to assign to the sku property of this ListingPart.
        :type sku: str

        :param metric_type:
            The value to assign to the metric_type property of this ListingPart.
            Allowed values for this property are: "OCPU_HOURS", "INSTANCE_HOURS", "CORE_HOURS"
        :type metric_type: str

        :param rate_allocation:
            The value to assign to the rate_allocation property of this ListingPart.
        :type rate_allocation: float

        :param has_gov_sku:
            The value to assign to the has_gov_sku property of this ListingPart.
        :type has_gov_sku: bool

        :param meters:
            The value to assign to the meters property of this ListingPart.
        :type meters: list[oci.marketplace_publisher.models.ListingMeter]

        """
        self.swagger_types = {
            'sku': 'str',
            'metric_type': 'str',
            'rate_allocation': 'float',
            'has_gov_sku': 'bool',
            'meters': 'list[ListingMeter]'
        }
        self.attribute_map = {
            'sku': 'sku',
            'metric_type': 'metricType',
            'rate_allocation': 'rateAllocation',
            'has_gov_sku': 'hasGovSku',
            'meters': 'meters'
        }
        self._sku = None
        self._metric_type = None
        self._rate_allocation = None
        self._has_gov_sku = None
        self._meters = None

    @property
    def sku(self):
        """
        **[Required]** Gets the sku of this ListingPart.
        The SKU/part name.


        :return: The sku of this ListingPart.
        :rtype: str
        """
        return self._sku

    @sku.setter
    def sku(self, sku):
        """
        Sets the sku of this ListingPart.
        The SKU/part name.


        :param sku: The sku of this ListingPart.
        :type: str
        """
        self._sku = sku

    @property
    def metric_type(self):
        """
        **[Required]** Gets the metric_type of this ListingPart.
        The part's metric.

        Allowed values for this property are: "OCPU_HOURS", "INSTANCE_HOURS", "CORE_HOURS"


        :return: The metric_type of this ListingPart.
        :rtype: str
        """
        return self._metric_type

    @metric_type.setter
    def metric_type(self, metric_type):
        """
        Sets the metric_type of this ListingPart.
        The part's metric.


        :param metric_type: The metric_type of this ListingPart.
        :type: str
        """
        allowed_values = ["OCPU_HOURS", "INSTANCE_HOURS", "CORE_HOURS"]
        if not value_allowed_none_or_none_sentinel(metric_type, allowed_values):
            raise ValueError(
                f"Invalid value for `metric_type`, must be None or one of {allowed_values}"
            )
        self._metric_type = metric_type

    @property
    def rate_allocation(self):
        """
        **[Required]** Gets the rate_allocation of this ListingPart.
        rate allocation, these are calculated based on rate information at listing revision.


        :return: The rate_allocation of this ListingPart.
        :rtype: float
        """
        return self._rate_allocation

    @rate_allocation.setter
    def rate_allocation(self, rate_allocation):
        """
        Sets the rate_allocation of this ListingPart.
        rate allocation, these are calculated based on rate information at listing revision.


        :param rate_allocation: The rate_allocation of this ListingPart.
        :type: float
        """
        self._rate_allocation = rate_allocation

    @property
    def has_gov_sku(self):
        """
        **[Required]** Gets the has_gov_sku of this ListingPart.
        Identifies whether part has Gov SKU.


        :return: The has_gov_sku of this ListingPart.
        :rtype: bool
        """
        return self._has_gov_sku

    @has_gov_sku.setter
    def has_gov_sku(self, has_gov_sku):
        """
        Sets the has_gov_sku of this ListingPart.
        Identifies whether part has Gov SKU.


        :param has_gov_sku: The has_gov_sku of this ListingPart.
        :type: bool
        """
        self._has_gov_sku = has_gov_sku

    @property
    def meters(self):
        """
        **[Required]** Gets the meters of this ListingPart.
        List of meters associated with the part.


        :return: The meters of this ListingPart.
        :rtype: list[oci.marketplace_publisher.models.ListingMeter]
        """
        return self._meters

    @meters.setter
    def meters(self, meters):
        """
        Sets the meters of this ListingPart.
        List of meters associated with the part.


        :param meters: The meters of this ListingPart.
        :type: list[oci.marketplace_publisher.models.ListingMeter]
        """
        self._meters = meters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
