# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SupportDoc(object):
    """
    The model for the supportDoc details.
    """

    #: A constant which can be used with the lifecycle_state property of a SupportDoc.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a SupportDoc.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new SupportDoc object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this SupportDoc.
        :type name: str

        :param code:
            The value to assign to the code property of this SupportDoc.
        :type code: str

        :param support_doc_group:
            The value to assign to the support_doc_group property of this SupportDoc.
        :type support_doc_group: str

        :param description:
            The value to assign to the description property of this SupportDoc.
        :type description: str

        :param content_url:
            The value to assign to the content_url property of this SupportDoc.
        :type content_url: str

        :param mime_type:
            The value to assign to the mime_type property of this SupportDoc.
        :type mime_type: str

        :param file_name:
            The value to assign to the file_name property of this SupportDoc.
        :type file_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SupportDoc.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this SupportDoc.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this SupportDoc.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'name': 'str',
            'code': 'str',
            'support_doc_group': 'str',
            'description': 'str',
            'content_url': 'str',
            'mime_type': 'str',
            'file_name': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'name': 'name',
            'code': 'code',
            'support_doc_group': 'supportDocGroup',
            'description': 'description',
            'content_url': 'contentUrl',
            'mime_type': 'mimeType',
            'file_name': 'fileName',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._name = None
        self._code = None
        self._support_doc_group = None
        self._description = None
        self._content_url = None
        self._mime_type = None
        self._file_name = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SupportDoc.
        The name for the supportDoc.


        :return: The name of this SupportDoc.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SupportDoc.
        The name for the supportDoc.


        :param name: The name of this SupportDoc.
        :type: str
        """
        self._name = name

    @property
    def code(self):
        """
        **[Required]** Gets the code of this SupportDoc.
        The code for the supportDoc.


        :return: The code of this SupportDoc.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this SupportDoc.
        The code for the supportDoc.


        :param code: The code of this SupportDoc.
        :type: str
        """
        self._code = code

    @property
    def support_doc_group(self):
        """
        **[Required]** Gets the support_doc_group of this SupportDoc.
        The supportDoc group for the supportDoc.


        :return: The support_doc_group of this SupportDoc.
        :rtype: str
        """
        return self._support_doc_group

    @support_doc_group.setter
    def support_doc_group(self, support_doc_group):
        """
        Sets the support_doc_group of this SupportDoc.
        The supportDoc group for the supportDoc.


        :param support_doc_group: The support_doc_group of this SupportDoc.
        :type: str
        """
        self._support_doc_group = support_doc_group

    @property
    def description(self):
        """
        Gets the description of this SupportDoc.
        The description of the supportDoc.


        :return: The description of this SupportDoc.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SupportDoc.
        The description of the supportDoc.


        :param description: The description of this SupportDoc.
        :type: str
        """
        self._description = description

    @property
    def content_url(self):
        """
        Gets the content_url of this SupportDoc.
        The URL of the specified attachment.


        :return: The content_url of this SupportDoc.
        :rtype: str
        """
        return self._content_url

    @content_url.setter
    def content_url(self, content_url):
        """
        Sets the content_url of this SupportDoc.
        The URL of the specified attachment.


        :param content_url: The content_url of this SupportDoc.
        :type: str
        """
        self._content_url = content_url

    @property
    def mime_type(self):
        """
        Gets the mime_type of this SupportDoc.
        The MIME type of the attachment.


        :return: The mime_type of this SupportDoc.
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """
        Sets the mime_type of this SupportDoc.
        The MIME type of the attachment.


        :param mime_type: The mime_type of this SupportDoc.
        :type: str
        """
        self._mime_type = mime_type

    @property
    def file_name(self):
        """
        Gets the file_name of this SupportDoc.
        The file name of the attachment.


        :return: The file_name of this SupportDoc.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """
        Sets the file_name of this SupportDoc.
        The file name of the attachment.


        :param file_name: The file_name of this SupportDoc.
        :type: str
        """
        self._file_name = file_name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SupportDoc.
        The current state for the supportDoc.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SupportDoc.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SupportDoc.
        The current state for the supportDoc.


        :param lifecycle_state: The lifecycle_state of this SupportDoc.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this SupportDoc.
        The date and time the supportDoc was created, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this SupportDoc.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this SupportDoc.
        The date and time the supportDoc was created, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this SupportDoc.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this SupportDoc.
        The date and time the supportDoc was updated, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this SupportDoc.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this SupportDoc.
        The date and time the supportDoc was updated, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this SupportDoc.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
