# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalLocationMappingMetadatumSummary(object):
    """
    Flat Map of CSP Region -> CSP-Physical-AZ -> OCI Site Group
    All fields in this object has immutable mappings. Please don't add any field that case change
    for any customer as this is only for Oracle Cloud Infrastructure internal service use.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalLocationMappingMetadatumSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ExternalLocationMappingMetadatumSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ExternalLocationMappingMetadatumSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ExternalLocationMappingMetadatumSummary.
        :type system_tags: dict(str, dict(str, object))

        :param external_location:
            The value to assign to the external_location property of this ExternalLocationMappingMetadatumSummary.
        :type external_location: oci.multicloud.models.ExternalLocation

        :param oci_physical_ad:
            The value to assign to the oci_physical_ad property of this ExternalLocationMappingMetadatumSummary.
        :type oci_physical_ad: str

        :param oci_logical_ad:
            The value to assign to the oci_logical_ad property of this ExternalLocationMappingMetadatumSummary.
        :type oci_logical_ad: str

        :param oci_region:
            The value to assign to the oci_region property of this ExternalLocationMappingMetadatumSummary.
        :type oci_region: str

        """
        self.swagger_types = {
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'external_location': 'ExternalLocation',
            'oci_physical_ad': 'str',
            'oci_logical_ad': 'str',
            'oci_region': 'str'
        }
        self.attribute_map = {
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'external_location': 'externalLocation',
            'oci_physical_ad': 'ociPhysicalAd',
            'oci_logical_ad': 'ociLogicalAd',
            'oci_region': 'ociRegion'
        }
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._external_location = None
        self._oci_physical_ad = None
        self._oci_logical_ad = None
        self._oci_region = None

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this ExternalLocationMappingMetadatumSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ExternalLocationMappingMetadatumSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ExternalLocationMappingMetadatumSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ExternalLocationMappingMetadatumSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this ExternalLocationMappingMetadatumSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ExternalLocationMappingMetadatumSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ExternalLocationMappingMetadatumSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ExternalLocationMappingMetadatumSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ExternalLocationMappingMetadatumSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ExternalLocationMappingMetadatumSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ExternalLocationMappingMetadatumSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ExternalLocationMappingMetadatumSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def external_location(self):
        """
        **[Required]** Gets the external_location of this ExternalLocationMappingMetadatumSummary.

        :return: The external_location of this ExternalLocationMappingMetadatumSummary.
        :rtype: oci.multicloud.models.ExternalLocation
        """
        return self._external_location

    @external_location.setter
    def external_location(self, external_location):
        """
        Sets the external_location of this ExternalLocationMappingMetadatumSummary.

        :param external_location: The external_location of this ExternalLocationMappingMetadatumSummary.
        :type: oci.multicloud.models.ExternalLocation
        """
        self._external_location = external_location

    @property
    def oci_physical_ad(self):
        """
        **[Required]** Gets the oci_physical_ad of this ExternalLocationMappingMetadatumSummary.
        OCI physical ad name


        :return: The oci_physical_ad of this ExternalLocationMappingMetadatumSummary.
        :rtype: str
        """
        return self._oci_physical_ad

    @oci_physical_ad.setter
    def oci_physical_ad(self, oci_physical_ad):
        """
        Sets the oci_physical_ad of this ExternalLocationMappingMetadatumSummary.
        OCI physical ad name


        :param oci_physical_ad: The oci_physical_ad of this ExternalLocationMappingMetadatumSummary.
        :type: str
        """
        self._oci_physical_ad = oci_physical_ad

    @property
    def oci_logical_ad(self):
        """
        **[Required]** Gets the oci_logical_ad of this ExternalLocationMappingMetadatumSummary.
        OCI logical ad name


        :return: The oci_logical_ad of this ExternalLocationMappingMetadatumSummary.
        :rtype: str
        """
        return self._oci_logical_ad

    @oci_logical_ad.setter
    def oci_logical_ad(self, oci_logical_ad):
        """
        Sets the oci_logical_ad of this ExternalLocationMappingMetadatumSummary.
        OCI logical ad name


        :param oci_logical_ad: The oci_logical_ad of this ExternalLocationMappingMetadatumSummary.
        :type: str
        """
        self._oci_logical_ad = oci_logical_ad

    @property
    def oci_region(self):
        """
        **[Required]** Gets the oci_region of this ExternalLocationMappingMetadatumSummary.
        OCI region identifier https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm


        :return: The oci_region of this ExternalLocationMappingMetadatumSummary.
        :rtype: str
        """
        return self._oci_region

    @oci_region.setter
    def oci_region(self, oci_region):
        """
        Sets the oci_region of this ExternalLocationMappingMetadatumSummary.
        OCI region identifier https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm


        :param oci_region: The oci_region of this ExternalLocationMappingMetadatumSummary.
        :type: str
        """
        self._oci_region = oci_region

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
