# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagementApplianceConfiguration(object):
    """
    Configuration of management appliance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManagementApplianceConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_metrics_collection_enabled:
            The value to assign to the is_metrics_collection_enabled property of this ManagementApplianceConfiguration.
        :type is_metrics_collection_enabled: bool

        :param is_log_ingestion_enabled:
            The value to assign to the is_log_ingestion_enabled property of this ManagementApplianceConfiguration.
        :type is_log_ingestion_enabled: bool

        :param support_bundle_bucket_id:
            The value to assign to the support_bundle_bucket_id property of this ManagementApplianceConfiguration.
        :type support_bundle_bucket_id: str

        :param metrics:
            The value to assign to the metrics property of this ManagementApplianceConfiguration.
        :type metrics: list[str]

        """
        self.swagger_types = {
            'is_metrics_collection_enabled': 'bool',
            'is_log_ingestion_enabled': 'bool',
            'support_bundle_bucket_id': 'str',
            'metrics': 'list[str]'
        }
        self.attribute_map = {
            'is_metrics_collection_enabled': 'isMetricsCollectionEnabled',
            'is_log_ingestion_enabled': 'isLogIngestionEnabled',
            'support_bundle_bucket_id': 'supportBundleBucketId',
            'metrics': 'metrics'
        }
        self._is_metrics_collection_enabled = None
        self._is_log_ingestion_enabled = None
        self._support_bundle_bucket_id = None
        self._metrics = None

    @property
    def is_metrics_collection_enabled(self):
        """
        **[Required]** Gets the is_metrics_collection_enabled of this ManagementApplianceConfiguration.
        Is metrics collection and publishing is enabled for appliance.


        :return: The is_metrics_collection_enabled of this ManagementApplianceConfiguration.
        :rtype: bool
        """
        return self._is_metrics_collection_enabled

    @is_metrics_collection_enabled.setter
    def is_metrics_collection_enabled(self, is_metrics_collection_enabled):
        """
        Sets the is_metrics_collection_enabled of this ManagementApplianceConfiguration.
        Is metrics collection and publishing is enabled for appliance.


        :param is_metrics_collection_enabled: The is_metrics_collection_enabled of this ManagementApplianceConfiguration.
        :type: bool
        """
        self._is_metrics_collection_enabled = is_metrics_collection_enabled

    @property
    def is_log_ingestion_enabled(self):
        """
        **[Required]** Gets the is_log_ingestion_enabled of this ManagementApplianceConfiguration.
        Is log ingestion from SDDC to OCI enabled.


        :return: The is_log_ingestion_enabled of this ManagementApplianceConfiguration.
        :rtype: bool
        """
        return self._is_log_ingestion_enabled

    @is_log_ingestion_enabled.setter
    def is_log_ingestion_enabled(self, is_log_ingestion_enabled):
        """
        Sets the is_log_ingestion_enabled of this ManagementApplianceConfiguration.
        Is log ingestion from SDDC to OCI enabled.


        :param is_log_ingestion_enabled: The is_log_ingestion_enabled of this ManagementApplianceConfiguration.
        :type: bool
        """
        self._is_log_ingestion_enabled = is_log_ingestion_enabled

    @property
    def support_bundle_bucket_id(self):
        """
        Gets the support_bundle_bucket_id of this ManagementApplianceConfiguration.
        The `OCID`__ of support bundle Object Storage bucket.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The support_bundle_bucket_id of this ManagementApplianceConfiguration.
        :rtype: str
        """
        return self._support_bundle_bucket_id

    @support_bundle_bucket_id.setter
    def support_bundle_bucket_id(self, support_bundle_bucket_id):
        """
        Sets the support_bundle_bucket_id of this ManagementApplianceConfiguration.
        The `OCID`__ of support bundle Object Storage bucket.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param support_bundle_bucket_id: The support_bundle_bucket_id of this ManagementApplianceConfiguration.
        :type: str
        """
        self._support_bundle_bucket_id = support_bundle_bucket_id

    @property
    def metrics(self):
        """
        Gets the metrics of this ManagementApplianceConfiguration.
        Array of metrics ids to collect.


        :return: The metrics of this ManagementApplianceConfiguration.
        :rtype: list[str]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this ManagementApplianceConfiguration.
        Array of metrics ids to collect.


        :param metrics: The metrics of this ManagementApplianceConfiguration.
        :type: list[str]
        """
        self._metrics = metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
