# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagementApplianceConnection(object):
    """
    Management appliance connection.
    """

    #: A constant which can be used with the type property of a ManagementApplianceConnection.
    #: This constant has a value of "VCENTER"
    TYPE_VCENTER = "VCENTER"

    #: A constant which can be used with the type property of a ManagementApplianceConnection.
    #: This constant has a value of "ADMIN_VCENTER"
    TYPE_ADMIN_VCENTER = "ADMIN_VCENTER"

    #: A constant which can be used with the type property of a ManagementApplianceConnection.
    #: This constant has a value of "NSX"
    TYPE_NSX = "NSX"

    def __init__(self, **kwargs):
        """
        Initializes a new ManagementApplianceConnection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ManagementApplianceConnection.
            Allowed values for this property are: "VCENTER", "ADMIN_VCENTER", "NSX", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param credentials_secret_id:
            The value to assign to the credentials_secret_id property of this ManagementApplianceConnection.
        :type credentials_secret_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'credentials_secret_id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'credentials_secret_id': 'credentialsSecretId'
        }
        self._type = None
        self._credentials_secret_id = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this ManagementApplianceConnection.
        Type of connection.

        Allowed values for this property are: "VCENTER", "ADMIN_VCENTER", "NSX", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this ManagementApplianceConnection.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ManagementApplianceConnection.
        Type of connection.


        :param type: The type of this ManagementApplianceConnection.
        :type: str
        """
        allowed_values = ["VCENTER", "ADMIN_VCENTER", "NSX"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def credentials_secret_id(self):
        """
        **[Required]** Gets the credentials_secret_id of this ManagementApplianceConnection.
        The `OCID`__ of secret in OCI vault, that is used for storage of username and password in JSON format.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The credentials_secret_id of this ManagementApplianceConnection.
        :rtype: str
        """
        return self._credentials_secret_id

    @credentials_secret_id.setter
    def credentials_secret_id(self, credentials_secret_id):
        """
        Sets the credentials_secret_id of this ManagementApplianceConnection.
        The `OCID`__ of secret in OCI vault, that is used for storage of username and password in JSON format.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param credentials_secret_id: The credentials_secret_id of this ManagementApplianceConnection.
        :type: str
        """
        self._credentials_secret_id = credentials_secret_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
