# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagementApplianceConnectionStatus(object):
    """
    Current state of management appliance connection.
    """

    #: A constant which can be used with the type property of a ManagementApplianceConnectionStatus.
    #: This constant has a value of "VCENTER"
    TYPE_VCENTER = "VCENTER"

    #: A constant which can be used with the type property of a ManagementApplianceConnectionStatus.
    #: This constant has a value of "ADMIN_VCENTER"
    TYPE_ADMIN_VCENTER = "ADMIN_VCENTER"

    #: A constant which can be used with the type property of a ManagementApplianceConnectionStatus.
    #: This constant has a value of "UI_PLUGIN_REGISTRATION"
    TYPE_UI_PLUGIN_REGISTRATION = "UI_PLUGIN_REGISTRATION"

    #: A constant which can be used with the type property of a ManagementApplianceConnectionStatus.
    #: This constant has a value of "NSX"
    TYPE_NSX = "NSX"

    #: A constant which can be used with the state property of a ManagementApplianceConnectionStatus.
    #: This constant has a value of "INACTIVE"
    STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the state property of a ManagementApplianceConnectionStatus.
    #: This constant has a value of "HEALTHY"
    STATE_HEALTHY = "HEALTHY"

    #: A constant which can be used with the state property of a ManagementApplianceConnectionStatus.
    #: This constant has a value of "UNHEALTHY"
    STATE_UNHEALTHY = "UNHEALTHY"

    def __init__(self, **kwargs):
        """
        Initializes a new ManagementApplianceConnectionStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ManagementApplianceConnectionStatus.
            Allowed values for this property are: "VCENTER", "ADMIN_VCENTER", "UI_PLUGIN_REGISTRATION", "NSX", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param state:
            The value to assign to the state property of this ManagementApplianceConnectionStatus.
            Allowed values for this property are: "INACTIVE", "HEALTHY", "UNHEALTHY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param details:
            The value to assign to the details property of this ManagementApplianceConnectionStatus.
        :type details: str

        """
        self.swagger_types = {
            'type': 'str',
            'state': 'str',
            'details': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'state': 'state',
            'details': 'details'
        }
        self._type = None
        self._state = None
        self._details = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this ManagementApplianceConnectionStatus.
        Type of connection.

        Allowed values for this property are: "VCENTER", "ADMIN_VCENTER", "UI_PLUGIN_REGISTRATION", "NSX", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this ManagementApplianceConnectionStatus.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ManagementApplianceConnectionStatus.
        Type of connection.


        :param type: The type of this ManagementApplianceConnectionStatus.
        :type: str
        """
        allowed_values = ["VCENTER", "ADMIN_VCENTER", "UI_PLUGIN_REGISTRATION", "NSX"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def state(self):
        """
        **[Required]** Gets the state of this ManagementApplianceConnectionStatus.
        Current connection status.

        Allowed values for this property are: "INACTIVE", "HEALTHY", "UNHEALTHY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this ManagementApplianceConnectionStatus.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this ManagementApplianceConnectionStatus.
        Current connection status.


        :param state: The state of this ManagementApplianceConnectionStatus.
        :type: str
        """
        allowed_values = ["INACTIVE", "HEALTHY", "UNHEALTHY"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def details(self):
        """
        Gets the details of this ManagementApplianceConnectionStatus.
        Information about current connection status.


        :return: The details of this ManagementApplianceConnectionStatus.
        :rtype: str
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this ManagementApplianceConnectionStatus.
        Information about current connection status.


        :param details: The details of this ManagementApplianceConnectionStatus.
        :type: str
        """
        self._details = details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
