# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdatePipelineStatusDetails(object):
    """
    update pipeline status.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdatePipelineStatusDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param pipeline_id:
            The value to assign to the pipeline_id property of this UpdatePipelineStatusDetails.
        :type pipeline_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this UpdatePipelineStatusDetails.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'pipeline_id': 'str',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'pipeline_id': 'pipelineId',
            'lifecycle_state': 'lifecycleState'
        }
        self._pipeline_id = None
        self._lifecycle_state = None

    @property
    def pipeline_id(self):
        """
        **[Required]** Gets the pipeline_id of this UpdatePipelineStatusDetails.
        OCID of the OpenSearch Pipeline.


        :return: The pipeline_id of this UpdatePipelineStatusDetails.
        :rtype: str
        """
        return self._pipeline_id

    @pipeline_id.setter
    def pipeline_id(self, pipeline_id):
        """
        Sets the pipeline_id of this UpdatePipelineStatusDetails.
        OCID of the OpenSearch Pipeline.


        :param pipeline_id: The pipeline_id of this UpdatePipelineStatusDetails.
        :type: str
        """
        self._pipeline_id = pipeline_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this UpdatePipelineStatusDetails.
        the new status of the OpenSearch Pipeline


        :return: The lifecycle_state of this UpdatePipelineStatusDetails.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this UpdatePipelineStatusDetails.
        the new status of the OpenSearch Pipeline


        :param lifecycle_state: The lifecycle_state of this UpdatePipelineStatusDetails.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
