# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IoUsageTrend(object):
    """
    Usage data for IO interface per usage unit.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IoUsageTrend object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param end_timestamp:
            The value to assign to the end_timestamp property of this IoUsageTrend.
        :type end_timestamp: datetime

        :param disk_bytes_read_in_mbs:
            The value to assign to the disk_bytes_read_in_mbs property of this IoUsageTrend.
        :type disk_bytes_read_in_mbs: float

        :param disk_bytes_written_in_mbs:
            The value to assign to the disk_bytes_written_in_mbs property of this IoUsageTrend.
        :type disk_bytes_written_in_mbs: float

        :param disk_iops_read:
            The value to assign to the disk_iops_read property of this IoUsageTrend.
        :type disk_iops_read: float

        :param disk_iops_written:
            The value to assign to the disk_iops_written property of this IoUsageTrend.
        :type disk_iops_written: float

        :param disk_iops:
            The value to assign to the disk_iops property of this IoUsageTrend.
        :type disk_iops: float

        """
        self.swagger_types = {
            'end_timestamp': 'datetime',
            'disk_bytes_read_in_mbs': 'float',
            'disk_bytes_written_in_mbs': 'float',
            'disk_iops_read': 'float',
            'disk_iops_written': 'float',
            'disk_iops': 'float'
        }
        self.attribute_map = {
            'end_timestamp': 'endTimestamp',
            'disk_bytes_read_in_mbs': 'diskBytesReadInMBs',
            'disk_bytes_written_in_mbs': 'diskBytesWrittenInMBs',
            'disk_iops_read': 'diskIopsRead',
            'disk_iops_written': 'diskIopsWritten',
            'disk_iops': 'diskIops'
        }
        self._end_timestamp = None
        self._disk_bytes_read_in_mbs = None
        self._disk_bytes_written_in_mbs = None
        self._disk_iops_read = None
        self._disk_iops_written = None
        self._disk_iops = None

    @property
    def end_timestamp(self):
        """
        **[Required]** Gets the end_timestamp of this IoUsageTrend.
        The timestamp in which the current sampling period ends in RFC 3339 format.


        :return: The end_timestamp of this IoUsageTrend.
        :rtype: datetime
        """
        return self._end_timestamp

    @end_timestamp.setter
    def end_timestamp(self, end_timestamp):
        """
        Sets the end_timestamp of this IoUsageTrend.
        The timestamp in which the current sampling period ends in RFC 3339 format.


        :param end_timestamp: The end_timestamp of this IoUsageTrend.
        :type: datetime
        """
        self._end_timestamp = end_timestamp

    @property
    def disk_bytes_read_in_mbs(self):
        """
        **[Required]** Gets the disk_bytes_read_in_mbs of this IoUsageTrend.
        MBs Read.


        :return: The disk_bytes_read_in_mbs of this IoUsageTrend.
        :rtype: float
        """
        return self._disk_bytes_read_in_mbs

    @disk_bytes_read_in_mbs.setter
    def disk_bytes_read_in_mbs(self, disk_bytes_read_in_mbs):
        """
        Sets the disk_bytes_read_in_mbs of this IoUsageTrend.
        MBs Read.


        :param disk_bytes_read_in_mbs: The disk_bytes_read_in_mbs of this IoUsageTrend.
        :type: float
        """
        self._disk_bytes_read_in_mbs = disk_bytes_read_in_mbs

    @property
    def disk_bytes_written_in_mbs(self):
        """
        **[Required]** Gets the disk_bytes_written_in_mbs of this IoUsageTrend.
        MBs Written.


        :return: The disk_bytes_written_in_mbs of this IoUsageTrend.
        :rtype: float
        """
        return self._disk_bytes_written_in_mbs

    @disk_bytes_written_in_mbs.setter
    def disk_bytes_written_in_mbs(self, disk_bytes_written_in_mbs):
        """
        Sets the disk_bytes_written_in_mbs of this IoUsageTrend.
        MBs Written.


        :param disk_bytes_written_in_mbs: The disk_bytes_written_in_mbs of this IoUsageTrend.
        :type: float
        """
        self._disk_bytes_written_in_mbs = disk_bytes_written_in_mbs

    @property
    def disk_iops_read(self):
        """
        **[Required]** Gets the disk_iops_read of this IoUsageTrend.
        Read IO operations per second.


        :return: The disk_iops_read of this IoUsageTrend.
        :rtype: float
        """
        return self._disk_iops_read

    @disk_iops_read.setter
    def disk_iops_read(self, disk_iops_read):
        """
        Sets the disk_iops_read of this IoUsageTrend.
        Read IO operations per second.


        :param disk_iops_read: The disk_iops_read of this IoUsageTrend.
        :type: float
        """
        self._disk_iops_read = disk_iops_read

    @property
    def disk_iops_written(self):
        """
        **[Required]** Gets the disk_iops_written of this IoUsageTrend.
        Write IO operations per second.


        :return: The disk_iops_written of this IoUsageTrend.
        :rtype: float
        """
        return self._disk_iops_written

    @disk_iops_written.setter
    def disk_iops_written(self, disk_iops_written):
        """
        Sets the disk_iops_written of this IoUsageTrend.
        Write IO operations per second.


        :param disk_iops_written: The disk_iops_written of this IoUsageTrend.
        :type: float
        """
        self._disk_iops_written = disk_iops_written

    @property
    def disk_iops(self):
        """
        **[Required]** Gets the disk_iops of this IoUsageTrend.
        IO operations per second.


        :return: The disk_iops of this IoUsageTrend.
        :rtype: float
        """
        return self._disk_iops

    @disk_iops.setter
    def disk_iops(self, disk_iops):
        """
        Sets the disk_iops of this IoUsageTrend.
        IO operations per second.


        :param disk_iops: The disk_iops of this IoUsageTrend.
        :type: float
        """
        self._disk_iops = disk_iops

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
