# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateResourceAnalyticsInstanceDetails(object):
    """
    The data to create a ResourceAnalyticsInstance.
    """

    #: A constant which can be used with the license_model property of a CreateResourceAnalyticsInstanceDetails.
    #: This constant has a value of "LICENSE_INCLUDED"
    LICENSE_MODEL_LICENSE_INCLUDED = "LICENSE_INCLUDED"

    #: A constant which can be used with the license_model property of a CreateResourceAnalyticsInstanceDetails.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_MODEL_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateResourceAnalyticsInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateResourceAnalyticsInstanceDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateResourceAnalyticsInstanceDetails.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this CreateResourceAnalyticsInstanceDetails.
        :type description: str

        :param adw_admin_password:
            The value to assign to the adw_admin_password property of this CreateResourceAnalyticsInstanceDetails.
        :type adw_admin_password: oci.resource_analytics.models.AdwAdminPasswordDetails

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateResourceAnalyticsInstanceDetails.
        :type subnet_id: str

        :param is_mutual_tls_required:
            The value to assign to the is_mutual_tls_required property of this CreateResourceAnalyticsInstanceDetails.
        :type is_mutual_tls_required: bool

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreateResourceAnalyticsInstanceDetails.
        :type nsg_ids: list[str]

        :param license_model:
            The value to assign to the license_model property of this CreateResourceAnalyticsInstanceDetails.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"
        :type license_model: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateResourceAnalyticsInstanceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateResourceAnalyticsInstanceDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'adw_admin_password': 'AdwAdminPasswordDetails',
            'subnet_id': 'str',
            'is_mutual_tls_required': 'bool',
            'nsg_ids': 'list[str]',
            'license_model': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'adw_admin_password': 'adwAdminPassword',
            'subnet_id': 'subnetId',
            'is_mutual_tls_required': 'isMutualTlsRequired',
            'nsg_ids': 'nsgIds',
            'license_model': 'licenseModel',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._description = None
        self._adw_admin_password = None
        self._subnet_id = None
        self._is_mutual_tls_required = None
        self._nsg_ids = None
        self._license_model = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateResourceAnalyticsInstanceDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateResourceAnalyticsInstanceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateResourceAnalyticsInstanceDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateResourceAnalyticsInstanceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateResourceAnalyticsInstanceDetails.
        The `OCID`__ of the compartment to create the ResourceAnalyticsInstance in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateResourceAnalyticsInstanceDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateResourceAnalyticsInstanceDetails.
        The `OCID`__ of the compartment to create the ResourceAnalyticsInstance in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateResourceAnalyticsInstanceDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this CreateResourceAnalyticsInstanceDetails.
        A description of the ResourceAnalyticsInstance instance.


        :return: The description of this CreateResourceAnalyticsInstanceDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateResourceAnalyticsInstanceDetails.
        A description of the ResourceAnalyticsInstance instance.


        :param description: The description of this CreateResourceAnalyticsInstanceDetails.
        :type: str
        """
        self._description = description

    @property
    def adw_admin_password(self):
        """
        **[Required]** Gets the adw_admin_password of this CreateResourceAnalyticsInstanceDetails.

        :return: The adw_admin_password of this CreateResourceAnalyticsInstanceDetails.
        :rtype: oci.resource_analytics.models.AdwAdminPasswordDetails
        """
        return self._adw_admin_password

    @adw_admin_password.setter
    def adw_admin_password(self, adw_admin_password):
        """
        Sets the adw_admin_password of this CreateResourceAnalyticsInstanceDetails.

        :param adw_admin_password: The adw_admin_password of this CreateResourceAnalyticsInstanceDetails.
        :type: oci.resource_analytics.models.AdwAdminPasswordDetails
        """
        self._adw_admin_password = adw_admin_password

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateResourceAnalyticsInstanceDetails.
        The `OCID`__ of the subnet the resource is associated with.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this CreateResourceAnalyticsInstanceDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateResourceAnalyticsInstanceDetails.
        The `OCID`__ of the subnet the resource is associated with.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this CreateResourceAnalyticsInstanceDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def is_mutual_tls_required(self):
        """
        Gets the is_mutual_tls_required of this CreateResourceAnalyticsInstanceDetails.
        Require mutual TLS (mTLS) when authenticating connections to the ADW database.


        :return: The is_mutual_tls_required of this CreateResourceAnalyticsInstanceDetails.
        :rtype: bool
        """
        return self._is_mutual_tls_required

    @is_mutual_tls_required.setter
    def is_mutual_tls_required(self, is_mutual_tls_required):
        """
        Sets the is_mutual_tls_required of this CreateResourceAnalyticsInstanceDetails.
        Require mutual TLS (mTLS) when authenticating connections to the ADW database.


        :param is_mutual_tls_required: The is_mutual_tls_required of this CreateResourceAnalyticsInstanceDetails.
        :type: bool
        """
        self._is_mutual_tls_required = is_mutual_tls_required

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreateResourceAnalyticsInstanceDetails.
        List of Network Security Group `OCID`__'s.

        Example: `[\"ocid...\", \"ocid...\"]`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The nsg_ids of this CreateResourceAnalyticsInstanceDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreateResourceAnalyticsInstanceDetails.
        List of Network Security Group `OCID`__'s.

        Example: `[\"ocid...\", \"ocid...\"]`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param nsg_ids: The nsg_ids of this CreateResourceAnalyticsInstanceDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def license_model(self):
        """
        Gets the license_model of this CreateResourceAnalyticsInstanceDetails.
        The Oracle license model that applies to the ADW instance.

        Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"


        :return: The license_model of this CreateResourceAnalyticsInstanceDetails.
        :rtype: str
        """
        return self._license_model

    @license_model.setter
    def license_model(self, license_model):
        """
        Sets the license_model of this CreateResourceAnalyticsInstanceDetails.
        The Oracle license model that applies to the ADW instance.


        :param license_model: The license_model of this CreateResourceAnalyticsInstanceDetails.
        :type: str
        """
        allowed_values = ["LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_model, allowed_values):
            raise ValueError(
                f"Invalid value for `license_model`, must be None or one of {allowed_values}"
            )
        self._license_model = license_model

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateResourceAnalyticsInstanceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateResourceAnalyticsInstanceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateResourceAnalyticsInstanceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateResourceAnalyticsInstanceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateResourceAnalyticsInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateResourceAnalyticsInstanceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateResourceAnalyticsInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateResourceAnalyticsInstanceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
