# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Condition(object):
    """
    The Monitoring Template Alarm Condition.
    """

    #: A constant which can be used with the severity property of a Condition.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    #: A constant which can be used with the severity property of a Condition.
    #: This constant has a value of "WARNING"
    SEVERITY_WARNING = "WARNING"

    def __init__(self, **kwargs):
        """
        Initializes a new Condition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param severity:
            The value to assign to the severity property of this Condition.
            Allowed values for this property are: "CRITICAL", "WARNING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param query:
            The value to assign to the query property of this Condition.
        :type query: str

        :param body:
            The value to assign to the body property of this Condition.
        :type body: str

        :param should_append_note:
            The value to assign to the should_append_note property of this Condition.
        :type should_append_note: bool

        :param should_append_url:
            The value to assign to the should_append_url property of this Condition.
        :type should_append_url: bool

        :param trigger_delay:
            The value to assign to the trigger_delay property of this Condition.
        :type trigger_delay: str

        """
        self.swagger_types = {
            'severity': 'str',
            'query': 'str',
            'body': 'str',
            'should_append_note': 'bool',
            'should_append_url': 'bool',
            'trigger_delay': 'str'
        }
        self.attribute_map = {
            'severity': 'severity',
            'query': 'query',
            'body': 'body',
            'should_append_note': 'shouldAppendNote',
            'should_append_url': 'shouldAppendUrl',
            'trigger_delay': 'triggerDelay'
        }
        self._severity = None
        self._query = None
        self._body = None
        self._should_append_note = None
        self._should_append_url = None
        self._trigger_delay = None

    @property
    def severity(self):
        """
        **[Required]** Gets the severity of this Condition.
        Severity - Critical/Warning

        Allowed values for this property are: "CRITICAL", "WARNING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this Condition.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this Condition.
        Severity - Critical/Warning


        :param severity: The severity of this Condition.
        :type: str
        """
        allowed_values = ["CRITICAL", "WARNING"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def query(self):
        """
        **[Required]** Gets the query of this Condition.
        The Monitoring Query Language (MQL) expression to evaluate for the alarm.


        :return: The query of this Condition.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this Condition.
        The Monitoring Query Language (MQL) expression to evaluate for the alarm.


        :param query: The query of this Condition.
        :type: str
        """
        self._query = query

    @property
    def body(self):
        """
        Gets the body of this Condition.
        The human-readable content of the delivered alarm notification. Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.


        :return: The body of this Condition.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this Condition.
        The human-readable content of the delivered alarm notification. Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.


        :param body: The body of this Condition.
        :type: str
        """
        self._body = body

    @property
    def should_append_note(self):
        """
        Gets the should_append_note of this Condition.
        Whether the note need to add into bottom of the body for mapping the alarms information with template or not.


        :return: The should_append_note of this Condition.
        :rtype: bool
        """
        return self._should_append_note

    @should_append_note.setter
    def should_append_note(self, should_append_note):
        """
        Sets the should_append_note of this Condition.
        Whether the note need to add into bottom of the body for mapping the alarms information with template or not.


        :param should_append_note: The should_append_note of this Condition.
        :type: bool
        """
        self._should_append_note = should_append_note

    @property
    def should_append_url(self):
        """
        Gets the should_append_url of this Condition.
        Whether the URL need to add into bottom of the body for mapping the alarms information with template or not.


        :return: The should_append_url of this Condition.
        :rtype: bool
        """
        return self._should_append_url

    @should_append_url.setter
    def should_append_url(self, should_append_url):
        """
        Sets the should_append_url of this Condition.
        Whether the URL need to add into bottom of the body for mapping the alarms information with template or not.


        :param should_append_url: The should_append_url of this Condition.
        :type: bool
        """
        self._should_append_url = should_append_url

    @property
    def trigger_delay(self):
        """
        Gets the trigger_delay of this Condition.
        The period of time that the condition defined in the alarm must persist before the alarm state changes from \"OK\" to \"FIRING\".


        :return: The trigger_delay of this Condition.
        :rtype: str
        """
        return self._trigger_delay

    @trigger_delay.setter
    def trigger_delay(self, trigger_delay):
        """
        Sets the trigger_delay of this Condition.
        The period of time that the condition defined in the alarm must persist before the alarm state changes from \"OK\" to \"FIRING\".


        :param trigger_delay: The trigger_delay of this Condition.
        :type: str
        """
        self._trigger_delay = trigger_delay

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
