# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330

from .config_summary import ConfigSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OnboardConfigSummary(ConfigSummary):
    """
    A configuration of the ONBOARD type, contains fields describing Onboarding customization: policies,
    dynamic groups, user groups.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OnboardConfigSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.stack_monitoring.models.OnboardConfigSummary.config_type` attribute
        of this class is ``ONBOARD`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OnboardConfigSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OnboardConfigSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this OnboardConfigSummary.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this OnboardConfigSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OnboardConfigSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OnboardConfigSummary.
        :type lifecycle_state: str

        :param config_type:
            The value to assign to the config_type property of this OnboardConfigSummary.
        :type config_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OnboardConfigSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OnboardConfigSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OnboardConfigSummary.
        :type system_tags: dict(str, dict(str, object))

        :param version:
            The value to assign to the version property of this OnboardConfigSummary.
        :type version: str

        :param is_manually_onboarded:
            The value to assign to the is_manually_onboarded property of this OnboardConfigSummary.
        :type is_manually_onboarded: bool

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'config_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'version': 'str',
            'is_manually_onboarded': 'bool'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'config_type': 'configType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'version': 'version',
            'is_manually_onboarded': 'isManuallyOnboarded'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._config_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._version = None
        self._is_manually_onboarded = None
        self._config_type = 'ONBOARD'

    @property
    def version(self):
        """
        Gets the version of this OnboardConfigSummary.
        Assigned version to given onboard configuration.


        :return: The version of this OnboardConfigSummary.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this OnboardConfigSummary.
        Assigned version to given onboard configuration.


        :param version: The version of this OnboardConfigSummary.
        :type: str
        """
        self._version = version

    @property
    def is_manually_onboarded(self):
        """
        **[Required]** Gets the is_manually_onboarded of this OnboardConfigSummary.
        True if customer decides marks configuration as manually configured.


        :return: The is_manually_onboarded of this OnboardConfigSummary.
        :rtype: bool
        """
        return self._is_manually_onboarded

    @is_manually_onboarded.setter
    def is_manually_onboarded(self, is_manually_onboarded):
        """
        Sets the is_manually_onboarded of this OnboardConfigSummary.
        True if customer decides marks configuration as manually configured.


        :param is_manually_onboarded: The is_manually_onboarded of this OnboardConfigSummary.
        :type: bool
        """
        self._is_manually_onboarded = is_manually_onboarded

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
