# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateEmailRecipientsGroupDetails(object):
    """
    The saved email recipient group to receive usage statement emails.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateEmailRecipientsGroupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateEmailRecipientsGroupDetails.
        :type compartment_id: str

        :param recipients_list:
            The value to assign to the recipients_list property of this CreateEmailRecipientsGroupDetails.
        :type recipients_list: list[oci.usage_api.models.EmailRecipient]

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'recipients_list': 'list[EmailRecipient]'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'recipients_list': 'recipientsList'
        }
        self._compartment_id = None
        self._recipients_list = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateEmailRecipientsGroupDetails.
        The customer tenancy.


        :return: The compartment_id of this CreateEmailRecipientsGroupDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateEmailRecipientsGroupDetails.
        The customer tenancy.


        :param compartment_id: The compartment_id of this CreateEmailRecipientsGroupDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def recipients_list(self):
        """
        **[Required]** Gets the recipients_list of this CreateEmailRecipientsGroupDetails.
        The list of recipients that will receive usage statement emails.


        :return: The recipients_list of this CreateEmailRecipientsGroupDetails.
        :rtype: list[oci.usage_api.models.EmailRecipient]
        """
        return self._recipients_list

    @recipients_list.setter
    def recipients_list(self, recipients_list):
        """
        Sets the recipients_list of this CreateEmailRecipientsGroupDetails.
        The list of recipients that will receive usage statement emails.


        :param recipients_list: The recipients_list of this CreateEmailRecipientsGroupDetails.
        :type: list[oci.usage_api.models.EmailRecipient]
        """
        self._recipients_list = recipients_list

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
