# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EmailRecipientsGroup(object):
    """
    The recipients group to receive usage statement emails.
    """

    #: A constant which can be used with the lifecycle_state property of a EmailRecipientsGroup.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a EmailRecipientsGroup.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new EmailRecipientsGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this EmailRecipientsGroup.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this EmailRecipientsGroup.
        :type compartment_id: str

        :param recipients_list:
            The value to assign to the recipients_list property of this EmailRecipientsGroup.
        :type recipients_list: list[oci.usage_api.models.EmailRecipient]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this EmailRecipientsGroup.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'recipients_list': 'list[EmailRecipient]',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'recipients_list': 'recipientsList',
            'lifecycle_state': 'lifecycleState'
        }
        self._id = None
        self._compartment_id = None
        self._recipients_list = None
        self._lifecycle_state = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this EmailRecipientsGroup.
        The usage statement email recipients group OCID.


        :return: The id of this EmailRecipientsGroup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EmailRecipientsGroup.
        The usage statement email recipients group OCID.


        :param id: The id of this EmailRecipientsGroup.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this EmailRecipientsGroup.
        The customer tenancy OCID.


        :return: The compartment_id of this EmailRecipientsGroup.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this EmailRecipientsGroup.
        The customer tenancy OCID.


        :param compartment_id: The compartment_id of this EmailRecipientsGroup.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def recipients_list(self):
        """
        **[Required]** Gets the recipients_list of this EmailRecipientsGroup.
        The list of recipients that will receive usage statement emails.


        :return: The recipients_list of this EmailRecipientsGroup.
        :rtype: list[oci.usage_api.models.EmailRecipient]
        """
        return self._recipients_list

    @recipients_list.setter
    def recipients_list(self, recipients_list):
        """
        Sets the recipients_list of this EmailRecipientsGroup.
        The list of recipients that will receive usage statement emails.


        :param recipients_list: The recipients_list of this EmailRecipientsGroup.
        :type: list[oci.usage_api.models.EmailRecipient]
        """
        self._recipients_list = recipients_list

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this EmailRecipientsGroup.
        The email recipients group lifecycle state.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this EmailRecipientsGroup.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this EmailRecipientsGroup.
        The email recipients group lifecycle state.


        :param lifecycle_state: The lifecycle_state of this EmailRecipientsGroup.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
