# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .drg_attachment_network_details import DrgAttachmentNetworkDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LoopBackDrgAttachmentNetworkDetails(DrgAttachmentNetworkDetails):
    """
    Specifies the loopback attachment on the DRG. A loopback attachment can be used to terminate a virtual circuit that is carrying an IPSec tunnel, routing traffic directly to the IPSec tunnel attachment where the tunnel can terminate.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LoopBackDrgAttachmentNetworkDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.LoopBackDrgAttachmentNetworkDetails.type` attribute
        of this class is ``LOOPBACK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this LoopBackDrgAttachmentNetworkDetails.
            Allowed values for this property are: "VCN", "IPSEC_TUNNEL", "VIRTUAL_CIRCUIT", "REMOTE_PEERING_CONNECTION", "FLEX_TUNNEL", "LOOPBACK", "INTERNET"
        :type type: str

        :param id:
            The value to assign to the id property of this LoopBackDrgAttachmentNetworkDetails.
        :type id: str

        :param ids:
            The value to assign to the ids property of this LoopBackDrgAttachmentNetworkDetails.
        :type ids: list[str]

        :param mpls_label:
            The value to assign to the mpls_label property of this LoopBackDrgAttachmentNetworkDetails.
        :type mpls_label: int

        :param import_route_target:
            The value to assign to the import_route_target property of this LoopBackDrgAttachmentNetworkDetails.
        :type import_route_target: str

        :param export_route_target:
            The value to assign to the export_route_target property of this LoopBackDrgAttachmentNetworkDetails.
        :type export_route_target: str

        """
        self.swagger_types = {
            'type': 'str',
            'id': 'str',
            'ids': 'list[str]',
            'mpls_label': 'int',
            'import_route_target': 'str',
            'export_route_target': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'id': 'id',
            'ids': 'ids',
            'mpls_label': 'mplsLabel',
            'import_route_target': 'importRouteTarget',
            'export_route_target': 'exportRouteTarget'
        }
        self._type = None
        self._id = None
        self._ids = None
        self._mpls_label = None
        self._import_route_target = None
        self._export_route_target = None
        self._type = 'LOOPBACK'

    @property
    def ids(self):
        """
        Gets the ids of this LoopBackDrgAttachmentNetworkDetails.
        The `OCID`__ of the target IPSec tunnel attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The ids of this LoopBackDrgAttachmentNetworkDetails.
        :rtype: list[str]
        """
        return self._ids

    @ids.setter
    def ids(self, ids):
        """
        Sets the ids of this LoopBackDrgAttachmentNetworkDetails.
        The `OCID`__ of the target IPSec tunnel attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param ids: The ids of this LoopBackDrgAttachmentNetworkDetails.
        :type: list[str]
        """
        self._ids = ids

    @property
    def mpls_label(self):
        """
        Gets the mpls_label of this LoopBackDrgAttachmentNetworkDetails.
        The MPLS label of the DRG attachment.


        :return: The mpls_label of this LoopBackDrgAttachmentNetworkDetails.
        :rtype: int
        """
        return self._mpls_label

    @mpls_label.setter
    def mpls_label(self, mpls_label):
        """
        Sets the mpls_label of this LoopBackDrgAttachmentNetworkDetails.
        The MPLS label of the DRG attachment.


        :param mpls_label: The mpls_label of this LoopBackDrgAttachmentNetworkDetails.
        :type: int
        """
        self._mpls_label = mpls_label

    @property
    def import_route_target(self):
        """
        Gets the import_route_target of this LoopBackDrgAttachmentNetworkDetails.
        Routes which may be imported from the attachment (subject to import policy) appear in the route reflectors
        tagged with the attachment's import route target.


        :return: The import_route_target of this LoopBackDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._import_route_target

    @import_route_target.setter
    def import_route_target(self, import_route_target):
        """
        Sets the import_route_target of this LoopBackDrgAttachmentNetworkDetails.
        Routes which may be imported from the attachment (subject to import policy) appear in the route reflectors
        tagged with the attachment's import route target.


        :param import_route_target: The import_route_target of this LoopBackDrgAttachmentNetworkDetails.
        :type: str
        """
        self._import_route_target = import_route_target

    @property
    def export_route_target(self):
        """
        Gets the export_route_target of this LoopBackDrgAttachmentNetworkDetails.
        Routes which are exported to the attachment are exported to the route reflectors
        with the route target set to the value of the attachment's export route target.


        :return: The export_route_target of this LoopBackDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._export_route_target

    @export_route_target.setter
    def export_route_target(self, export_route_target):
        """
        Sets the export_route_target of this LoopBackDrgAttachmentNetworkDetails.
        Routes which are exported to the attachment are exported to the route reflectors
        with the route target set to the value of the attachment's export route target.


        :param export_route_target: The export_route_target of this LoopBackDrgAttachmentNetworkDetails.
        :type: str
        """
        self._export_route_target = export_route_target

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
