# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostCisBenchmarkScanResultScore(object):
    """
    A single CIS (Center for Internet Security) benchmark executed in a host scan
    """

    #: A constant which can be used with the score property of a HostCisBenchmarkScanResultScore.
    #: This constant has a value of "PASS"
    SCORE_PASS = "PASS"

    #: A constant which can be used with the score property of a HostCisBenchmarkScanResultScore.
    #: This constant has a value of "FAIL"
    SCORE_FAIL = "FAIL"

    def __init__(self, **kwargs):
        """
        Initializes a new HostCisBenchmarkScanResultScore object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param benchmark_identifier:
            The value to assign to the benchmark_identifier property of this HostCisBenchmarkScanResultScore.
        :type benchmark_identifier: str

        :param description:
            The value to assign to the description property of this HostCisBenchmarkScanResultScore.
        :type description: str

        :param score:
            The value to assign to the score property of this HostCisBenchmarkScanResultScore.
            Allowed values for this property are: "PASS", "FAIL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type score: str

        """
        self.swagger_types = {
            'benchmark_identifier': 'str',
            'description': 'str',
            'score': 'str'
        }
        self.attribute_map = {
            'benchmark_identifier': 'benchmarkIdentifier',
            'description': 'description',
            'score': 'score'
        }
        self._benchmark_identifier = None
        self._description = None
        self._score = None

    @property
    def benchmark_identifier(self):
        """
        **[Required]** Gets the benchmark_identifier of this HostCisBenchmarkScanResultScore.
        Identifier for this CIS (Center for Internet Security) benchmark


        :return: The benchmark_identifier of this HostCisBenchmarkScanResultScore.
        :rtype: str
        """
        return self._benchmark_identifier

    @benchmark_identifier.setter
    def benchmark_identifier(self, benchmark_identifier):
        """
        Sets the benchmark_identifier of this HostCisBenchmarkScanResultScore.
        Identifier for this CIS (Center for Internet Security) benchmark


        :param benchmark_identifier: The benchmark_identifier of this HostCisBenchmarkScanResultScore.
        :type: str
        """
        self._benchmark_identifier = benchmark_identifier

    @property
    def description(self):
        """
        **[Required]** Gets the description of this HostCisBenchmarkScanResultScore.
        Details about what this CIS (Center for Internet Security) benchmark represents


        :return: The description of this HostCisBenchmarkScanResultScore.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this HostCisBenchmarkScanResultScore.
        Details about what this CIS (Center for Internet Security) benchmark represents


        :param description: The description of this HostCisBenchmarkScanResultScore.
        :type: str
        """
        self._description = description

    @property
    def score(self):
        """
        **[Required]** Gets the score of this HostCisBenchmarkScanResultScore.
        Result score of CIS (Center for Internet Security) benchmark execution (Pass/Fail)

        Allowed values for this property are: "PASS", "FAIL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The score of this HostCisBenchmarkScanResultScore.
        :rtype: str
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this HostCisBenchmarkScanResultScore.
        Result score of CIS (Center for Internet Security) benchmark execution (Pass/Fail)


        :param score: The score of this HostCisBenchmarkScanResultScore.
        :type: str
        """
        allowed_values = ["PASS", "FAIL"]
        if not value_allowed_none_or_none_sentinel(score, allowed_values):
            score = 'UNKNOWN_ENUM_VALUE'
        self._score = score

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
