# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Agreement(object):
    """
    The terms of use agreement which must be accepted prior to accessing certain product features.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Agreement object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param uuid:
            The value to assign to the uuid property of this Agreement.
        :type uuid: str

        :param terms_and_conditions_text:
            The value to assign to the terms_and_conditions_text property of this Agreement.
        :type terms_and_conditions_text: str

        :param signature:
            The value to assign to the signature property of this Agreement.
        :type signature: str

        """
        self.swagger_types = {
            'uuid': 'str',
            'terms_and_conditions_text': 'str',
            'signature': 'str'
        }
        self.attribute_map = {
            'uuid': 'uuid',
            'terms_and_conditions_text': 'termsAndConditionsText',
            'signature': 'signature'
        }
        self._uuid = None
        self._terms_and_conditions_text = None
        self._signature = None

    @property
    def uuid(self):
        """
        **[Required]** Gets the uuid of this Agreement.
        The ID of the terms of use agreement.


        :return: The uuid of this Agreement.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """
        Sets the uuid of this Agreement.
        The ID of the terms of use agreement.


        :param uuid: The uuid of this Agreement.
        :type: str
        """
        self._uuid = uuid

    @property
    def terms_and_conditions_text(self):
        """
        **[Required]** Gets the terms_and_conditions_text of this Agreement.
        The content of the terms and conditions.


        :return: The terms_and_conditions_text of this Agreement.
        :rtype: str
        """
        return self._terms_and_conditions_text

    @terms_and_conditions_text.setter
    def terms_and_conditions_text(self, terms_and_conditions_text):
        """
        Sets the terms_and_conditions_text of this Agreement.
        The content of the terms and conditions.


        :param terms_and_conditions_text: The terms_and_conditions_text of this Agreement.
        :type: str
        """
        self._terms_and_conditions_text = terms_and_conditions_text

    @property
    def signature(self):
        """
        **[Required]** Gets the signature of this Agreement.
        The signature for the terms of use agreement. The signature attribute is a Base64-encoded string associated with the agreement.


        :return: The signature of this Agreement.
        :rtype: str
        """
        return self._signature

    @signature.setter
    def signature(self, signature):
        """
        Sets the signature of this Agreement.
        The signature for the terms of use agreement. The signature attribute is a Base64-encoded string associated with the agreement.


        :param signature: The signature of this Agreement.
        :type: str
        """
        self._signature = signature

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
