# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAgreementRecordDetails(object):
    """
    This object represents the fields to create a terms of use agreement record for a domain.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAgreementRecordDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param agreement_uuid:
            The value to assign to the agreement_uuid property of this CreateAgreementRecordDetails.
        :type agreement_uuid: str

        :param agreement_signature:
            The value to assign to the agreement_signature property of this CreateAgreementRecordDetails.
        :type agreement_signature: str

        """
        self.swagger_types = {
            'agreement_uuid': 'str',
            'agreement_signature': 'str'
        }
        self.attribute_map = {
            'agreement_uuid': 'agreementUuid',
            'agreement_signature': 'agreementSignature'
        }
        self._agreement_uuid = None
        self._agreement_signature = None

    @property
    def agreement_uuid(self):
        """
        **[Required]** Gets the agreement_uuid of this CreateAgreementRecordDetails.
        The ID of the agreement to accept.


        :return: The agreement_uuid of this CreateAgreementRecordDetails.
        :rtype: str
        """
        return self._agreement_uuid

    @agreement_uuid.setter
    def agreement_uuid(self, agreement_uuid):
        """
        Sets the agreement_uuid of this CreateAgreementRecordDetails.
        The ID of the agreement to accept.


        :param agreement_uuid: The agreement_uuid of this CreateAgreementRecordDetails.
        :type: str
        """
        self._agreement_uuid = agreement_uuid

    @property
    def agreement_signature(self):
        """
        **[Required]** Gets the agreement_signature of this CreateAgreementRecordDetails.
        The agreement signature.


        :return: The agreement_signature of this CreateAgreementRecordDetails.
        :rtype: str
        """
        return self._agreement_signature

    @agreement_signature.setter
    def agreement_signature(self, agreement_signature):
        """
        Sets the agreement_signature of this CreateAgreementRecordDetails.
        The agreement signature.


        :param agreement_signature: The agreement_signature of this CreateAgreementRecordDetails.
        :type: str
        """
        self._agreement_signature = agreement_signature

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
