# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RequiredPolicySummary(object):
    """
    The summary information about the required policy for WebLogic Management Service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RequiredPolicySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this RequiredPolicySummary.
        :type name: str

        :param description:
            The value to assign to the description property of this RequiredPolicySummary.
        :type description: str

        :param statements:
            The value to assign to the statements property of this RequiredPolicySummary.
        :type statements: list[str]

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'statements': 'list[str]'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'statements': 'statements'
        }
        self._name = None
        self._description = None
        self._statements = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this RequiredPolicySummary.
        The name of the policy.


        :return: The name of this RequiredPolicySummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this RequiredPolicySummary.
        The name of the policy.


        :param name: The name of this RequiredPolicySummary.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this RequiredPolicySummary.
        A short description about the policy.


        :return: The description of this RequiredPolicySummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this RequiredPolicySummary.
        A short description about the policy.


        :param description: The description of this RequiredPolicySummary.
        :type: str
        """
        self._description = description

    @property
    def statements(self):
        """
        **[Required]** Gets the statements of this RequiredPolicySummary.
        The list of the statements in the policy.


        :return: The statements of this RequiredPolicySummary.
        :rtype: list[str]
        """
        return self._statements

    @statements.setter
    def statements(self, statements):
        """
        Sets the statements of this RequiredPolicySummary.
        The list of the statements in the policy.


        :param statements: The statements of this RequiredPolicySummary.
        :type: list[str]
        """
        self._statements = statements

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
