# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScanResultSummary(object):
    """
    The result of a server check in a managed instance.
    """

    #: A constant which can be used with the server_check_status property of a ScanResultSummary.
    #: This constant has a value of "OK"
    SERVER_CHECK_STATUS_OK = "OK"

    #: A constant which can be used with the server_check_status property of a ScanResultSummary.
    #: This constant has a value of "WARNING"
    SERVER_CHECK_STATUS_WARNING = "WARNING"

    #: A constant which can be used with the server_check_status property of a ScanResultSummary.
    #: This constant has a value of "FAILURE"
    SERVER_CHECK_STATUS_FAILURE = "FAILURE"

    def __init__(self, **kwargs):
        """
        Initializes a new ScanResultSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param wls_domain_id:
            The value to assign to the wls_domain_id property of this ScanResultSummary.
        :type wls_domain_id: str

        :param server_name:
            The value to assign to the server_name property of this ScanResultSummary.
        :type server_name: str

        :param time_of_server_check:
            The value to assign to the time_of_server_check property of this ScanResultSummary.
        :type time_of_server_check: datetime

        :param server_check_status:
            The value to assign to the server_check_status property of this ScanResultSummary.
            Allowed values for this property are: "OK", "WARNING", "FAILURE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type server_check_status: str

        :param server_check_name:
            The value to assign to the server_check_name property of this ScanResultSummary.
        :type server_check_name: str

        :param server_check_result_id:
            The value to assign to the server_check_result_id property of this ScanResultSummary.
        :type server_check_result_id: str

        :param server_check_result:
            The value to assign to the server_check_result property of this ScanResultSummary.
        :type server_check_result: str

        """
        self.swagger_types = {
            'wls_domain_id': 'str',
            'server_name': 'str',
            'time_of_server_check': 'datetime',
            'server_check_status': 'str',
            'server_check_name': 'str',
            'server_check_result_id': 'str',
            'server_check_result': 'str'
        }
        self.attribute_map = {
            'wls_domain_id': 'wlsDomainId',
            'server_name': 'serverName',
            'time_of_server_check': 'timeOfServerCheck',
            'server_check_status': 'serverCheckStatus',
            'server_check_name': 'serverCheckName',
            'server_check_result_id': 'serverCheckResultId',
            'server_check_result': 'serverCheckResult'
        }
        self._wls_domain_id = None
        self._server_name = None
        self._time_of_server_check = None
        self._server_check_status = None
        self._server_check_name = None
        self._server_check_result_id = None
        self._server_check_result = None

    @property
    def wls_domain_id(self):
        """
        **[Required]** Gets the wls_domain_id of this ScanResultSummary.
        The `OCID`__ of the WebLogic domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The wls_domain_id of this ScanResultSummary.
        :rtype: str
        """
        return self._wls_domain_id

    @wls_domain_id.setter
    def wls_domain_id(self, wls_domain_id):
        """
        Sets the wls_domain_id of this ScanResultSummary.
        The `OCID`__ of the WebLogic domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param wls_domain_id: The wls_domain_id of this ScanResultSummary.
        :type: str
        """
        self._wls_domain_id = wls_domain_id

    @property
    def server_name(self):
        """
        **[Required]** Gets the server_name of this ScanResultSummary.
        The name of the WebLogic server to which the server check belongs.


        :return: The server_name of this ScanResultSummary.
        :rtype: str
        """
        return self._server_name

    @server_name.setter
    def server_name(self, server_name):
        """
        Sets the server_name of this ScanResultSummary.
        The name of the WebLogic server to which the server check belongs.


        :param server_name: The server_name of this ScanResultSummary.
        :type: str
        """
        self._server_name = server_name

    @property
    def time_of_server_check(self):
        """
        **[Required]** Gets the time_of_server_check of this ScanResultSummary.
        The date when the WebLogic server health check is performed (in `RFC 3339`__ format).

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_of_server_check of this ScanResultSummary.
        :rtype: datetime
        """
        return self._time_of_server_check

    @time_of_server_check.setter
    def time_of_server_check(self, time_of_server_check):
        """
        Sets the time_of_server_check of this ScanResultSummary.
        The date when the WebLogic server health check is performed (in `RFC 3339`__ format).

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_of_server_check: The time_of_server_check of this ScanResultSummary.
        :type: datetime
        """
        self._time_of_server_check = time_of_server_check

    @property
    def server_check_status(self):
        """
        **[Required]** Gets the server_check_status of this ScanResultSummary.
        The status of the server check which is OK, FAILURE, or WARNING.

        Allowed values for this property are: "OK", "WARNING", "FAILURE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The server_check_status of this ScanResultSummary.
        :rtype: str
        """
        return self._server_check_status

    @server_check_status.setter
    def server_check_status(self, server_check_status):
        """
        Sets the server_check_status of this ScanResultSummary.
        The status of the server check which is OK, FAILURE, or WARNING.


        :param server_check_status: The server_check_status of this ScanResultSummary.
        :type: str
        """
        allowed_values = ["OK", "WARNING", "FAILURE"]
        if not value_allowed_none_or_none_sentinel(server_check_status, allowed_values):
            server_check_status = 'UNKNOWN_ENUM_VALUE'
        self._server_check_status = server_check_status

    @property
    def server_check_name(self):
        """
        **[Required]** Gets the server_check_name of this ScanResultSummary.
        The name of the check performed.


        :return: The server_check_name of this ScanResultSummary.
        :rtype: str
        """
        return self._server_check_name

    @server_check_name.setter
    def server_check_name(self, server_check_name):
        """
        Sets the server_check_name of this ScanResultSummary.
        The name of the check performed.


        :param server_check_name: The server_check_name of this ScanResultSummary.
        :type: str
        """
        self._server_check_name = server_check_name

    @property
    def server_check_result_id(self):
        """
        Gets the server_check_result_id of this ScanResultSummary.
        The identifier of the the server check result.


        :return: The server_check_result_id of this ScanResultSummary.
        :rtype: str
        """
        return self._server_check_result_id

    @server_check_result_id.setter
    def server_check_result_id(self, server_check_result_id):
        """
        Sets the server_check_result_id of this ScanResultSummary.
        The identifier of the the server check result.


        :param server_check_result_id: The server_check_result_id of this ScanResultSummary.
        :type: str
        """
        self._server_check_result_id = server_check_result_id

    @property
    def server_check_result(self):
        """
        **[Required]** Gets the server_check_result of this ScanResultSummary.
        The result of the server check.


        :return: The server_check_result of this ScanResultSummary.
        :rtype: str
        """
        return self._server_check_result

    @server_check_result.setter
    def server_check_result(self, server_check_result):
        """
        Sets the server_check_result of this ScanResultSummary.
        The result of the server check.


        :param server_check_result: The server_check_result of this ScanResultSummary.
        :type: str
        """
        self._server_check_result = server_check_result

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
