/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 29 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector0100QSize.cpp"

#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qsize.sip"
#include <qsize.h>
#line 33 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector0100QSize.cpp"


extern "C" {static void assign_QVector_0100QSize(void *, Py_ssize_t, void *);}
static void assign_QVector_0100QSize(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<QVector< ::QSize> *>(sipDst)[sipDstIdx] = *reinterpret_cast<QVector< ::QSize> *>(sipSrc);
}


extern "C" {static void *array_QVector_0100QSize(Py_ssize_t);}
static void *array_QVector_0100QSize(Py_ssize_t sipNrElem)
{
    return new QVector< ::QSize>[sipNrElem];
}


extern "C" {static void *copy_QVector_0100QSize(const void *, Py_ssize_t);}
static void *copy_QVector_0100QSize(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new QVector< ::QSize>(reinterpret_cast<const QVector< ::QSize> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QVector_0100QSize(void *, int);}
static void release_QVector_0100QSize(void *sipCppV, int)
{
    QVector< ::QSize> *sipCpp = reinterpret_cast<QVector< ::QSize> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QVector_0100QSize(PyObject *, void **, int *, PyObject *);}
static int convertTo_QVector_0100QSize(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    QVector< ::QSize> **sipCppPtr = reinterpret_cast<QVector< ::QSize> **>(sipCppPtrV);

#line 58 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpycore_qvector.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter
#if PY_MAJOR_VERSION < 3
                && !PyString_Check(sipPy)
#endif
                && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QVector<QSize> *qv = new QVector<QSize>;
 
    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete qv;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        int state;
        QSize *t = reinterpret_cast<QSize *>(
                sipForceConvertToType(itm, sipType_QSize, sipTransferObj,
                        SIP_NOT_NONE, &state, sipIsErr));

        if (*sipIsErr)
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'QSize' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete qv;
            Py_DECREF(iter);

            return 0;
        }

        qv->append(*t);

        sipReleaseType(t, sipType_QSize, state);
        Py_DECREF(itm);
    }

    Py_DECREF(iter);
 
    *sipCppPtr = qv;
 
    return sipGetState(sipTransferObj);
#line 144 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector0100QSize.cpp"
}


extern "C" {static PyObject *convertFrom_QVector_0100QSize(void *, PyObject *);}
static PyObject *convertFrom_QVector_0100QSize(void *sipCppV, PyObject *sipTransferObj)
{
    QVector< ::QSize> *sipCpp = reinterpret_cast<QVector< ::QSize> *>(sipCppV);

#line 32 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpycore_qvector.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        QSize *t = new QSize(sipCpp->at(i));
        PyObject *tobj = sipConvertFromNewType(t, sipType_QSize,
                sipTransferObj);

        if (!tobj)
        {
            delete t;
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, tobj);
    }

    return l;
#line 177 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector0100QSize.cpp"
}


sipMappedTypeDef sipTypeDef_QtGui_QVector_0100QSize = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_27182,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_QVector_0100QSize,
    array_QVector_0100QSize,
    copy_QVector_0100QSize,
    release_QVector_0100QSize,
    convertTo_QVector_0100QSize,
    convertFrom_QVector_0100QSize
};
