import logging
import threading
import time

logger = logging.getLogger(__name__)


class Trigger:
    _value: float
    _lock: threading.Lock

    def __init__(self, delay: float = 0.0):
        self._lock = threading.Lock()
        self._value = 0
        self._delay = delay

    def emit(self):
        with self._lock:
            self._value = time.monotonic() + self._delay
        logger.debug("Trigger scheduled with delay=%s", self._delay)

    def emit_now(self):
        with self._lock:
            self._value = time.monotonic()
        logger.debug("Trigger scheduled for immediate run")

    def is_active(self):
        return self._value != 0

    def release(self):
        with self._lock:
            self._value = 0
        logger.debug("Trigger released")

    def check(self):
        return self._value > 0 and time.monotonic() > self._value
