// This file was generated by qtwaylandscanner
// source file is /build/qt5-wayland-decorations/src/kde-qtwayland/src/extensions/xcomposite.xml

#ifndef QT_WAYLAND_SERVER_XCOMPOSITE
#define QT_WAYLAND_SERVER_XCOMPOSITE

#include "wayland-server-core.h"
#include "wayland-xcomposite-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  qt_xcomposite
    {
    public:
        qt_xcomposite(struct ::wl_client *client, int id, int version);
        qt_xcomposite(struct ::wl_display *display, int version);
        qt_xcomposite(struct ::wl_resource *resource);
        qt_xcomposite();

        virtual ~qt_xcomposite();

        class Resource
        {
        public:
            Resource() : xcomposite_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            qt_xcomposite *xcomposite_object;
            qt_xcomposite *object() { return xcomposite_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_root(const QString &display_name, uint32_t root_window);
        void send_root(struct ::wl_resource *resource, const QString &display_name, uint32_t root_window);

    protected:
        virtual Resource *xcomposite_allocate();

        virtual void xcomposite_bind_resource(Resource *resource);
        virtual void xcomposite_destroy_resource(Resource *resource);

        virtual void xcomposite_create_buffer(Resource *resource, uint32_t id, uint32_t x_window, int32_t width, int32_t height);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::qt_xcomposite_interface m_qt_xcomposite_interface;

        static void handle_create_buffer(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            uint32_t x_window,
            int32_t width,
            int32_t height);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        uint32_t m_globalVersion;
        struct DisplayDestroyedListener : ::wl_listener {
            qt_xcomposite *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
