/*
 *  Copyright (C) 2019-2025 Andrés Martínez Mera - andresmmera@protonmail.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef LOWPASSPROTOTYPECOEFFS_H
#define LOWPASSPROTOTYPECOEFFS_H
#include "../../Schematic/Network.h"
#include "../../Schematic/structures.h"
#include <deque>
#include <QDebug>


class LowpassPrototypeCoeffs {
public:
  LowpassPrototypeCoeffs(FilterSpecifications);
  std::deque<double> getCoefficients();

private:
  FilterSpecifications Specification;

  std::deque<double> calcButterworth_gi();
  std::deque<double> calcChebyshev_gi();
  std::deque<double> calcBessel_gi();
  std::deque<double> calcGaussian_gi();
  std::deque<double> calcLegendre_gi();
};

#endif // LOWPASSPROTOTYPECOEFFS_H
