#include "GLFunctions.h"

#define ASSIGN_PROC_ADR(proc_type, proc_name) ptr##proc_name = gl##proc_name

#ifdef OS_WINDOWS

#define glGetProcAddress wglGetProcAddress
#define GL_GET_PROC_ADR(proc_type, proc_name) ptr##proc_name = (proc_type) glGetProcAddress("gl"#proc_name)

#elif defined(VERO4K) || defined(ODROID) || defined(VC)
#include <dlfcn.h>

#define GL_GET_PROC_ADR(proc_type, proc_name) ptr##proc_name = (proc_type) dlsym(gles2so, "gl"#proc_name);

#elif defined(EGL)

#define glGetProcAddress eglGetProcAddress
#define GL_GET_PROC_ADR(proc_type, proc_name) ptr##proc_name = (proc_type) glGetProcAddress("gl"#proc_name)
#define GL_GET_PROC_ADR_EGL(proc_type, proc_name) ptr##proc_name = (proc_type) glGetProcAddress("egl"#proc_name)

#elif defined(OS_LINUX)

#include <X11/Xutil.h>
typedef XID GLXContextID;
typedef XID GLXPixmap;
typedef XID GLXDrawable;
typedef XID GLXPbuffer;
typedef XID GLXWindow;
typedef XID GLXFBConfigID;
typedef struct __GLXcontextRec *GLXContext;
typedef struct __GLXFBConfigRec *GLXFBConfig;
#define GLX_GLXEXT_PROTOTYPES
#include <GL/glxext.h>
#define glGetProcAddress glXGetProcAddress
#define GL_GET_PROC_ADR(proc_type, proc_name) ptr##proc_name = (proc_type) glGetProcAddress((const GLubyte*)"gl"#proc_name)

#elif defined(OS_MAC_OS_X)
#include <dlfcn.h>

static void* AppleGLGetProcAddress (const char *name)
{
	static void* image = NULL;
	if (NULL == image)
		image = dlopen("/System/Library/Frameworks/OpenGL.framework/Versions/Current/OpenGL", RTLD_LAZY);

	return (image ? dlsym(image, name) : NULL);
}
#define glGetProcAddress AppleGLGetProcAddress
#define GL_GET_PROC_ADR(proc_type, proc_name) ptr##proc_name = (proc_type) glGetProcAddress("gl"#proc_name)

#elif defined(OS_IOS)
#include <dlfcn.h>

static void* IOSGLGetProcAddress (const char *name)
{
    return dlsym(RTLD_DEFAULT, name);
}

#define glGetProcAddress IOSGLGetProcAddress
#define GL_GET_PROC_ADR(proc_type, proc_name) ptr##proc_name = (proc_type)glGetProcAddress("gl"#proc_name)

#elif defined(OS_FREEBSD)
  #include <GL/glx.h>

  #ifndef glGetProcAddress
    #define glGetProcAddress glXGetProcAddress
  #endif

  #undef GL_GET_PROC_ADR
  #define GL_GET_PROC_ADR(proc_type, proc_name) \
      ptr##proc_name = (proc_type) glGetProcAddress((const GLubyte*)"gl" #proc_name)
#endif

//GL Functions
PFNGLBLENDFUNCPROC ptrBlendFunc;
PFNGLBLENDFUNCSEPARATEPROC ptrBlendFuncSeparate;
PFNGLPIXELSTOREIPROC ptrPixelStorei;
PFNGLCLEARCOLORPROC ptrClearColor;
PFNGLCULLFACEPROC ptrCullFace;
PFNGLDEPTHFUNCPROC ptrDepthFunc;
PFNGLDEPTHMASKPROC ptrDepthMask;
PFNGLDISABLEPROC ptrDisable;
PFNGLENABLEPROC ptrEnable;
PFNGLPOLYGONOFFSETPROC ptrPolygonOffset;
PFNGLSCISSORPROC ptrScissor;
PFNGLVIEWPORTPROC ptrViewport;
PFNGLBINDTEXTUREPROC ptrBindTexture;
PFNGLTEXIMAGE2DPROC ptrTexImage2D;
PFNGLTEXPARAMETERIPROC ptrTexParameteri;
PFNGLGETINTEGERVPROC ptrGetIntegerv;
PFNGLGETSTRINGPROC ptrGetString;
PFNGLREADPIXELSPROC ptrReadPixels;
PFNGLTEXSUBIMAGE2DPROC ptrTexSubImage2D;
PFNGLDRAWARRAYSPROC ptrDrawArrays;
PFNGLGETERRORPROC ptrGetError;
PFNGLDRAWELEMENTSPROC ptrDrawElements;
PFNGLLINEWIDTHPROC ptrLineWidth;
PFNGLCLEARPROC ptrClear;
PFNGLGETFLOATVPROC ptrGetFloatv;
PFNGLDELETETEXTURESPROC ptrDeleteTextures;
PFNGLGENTEXTURESPROC ptrGenTextures;
PFNGLTEXPARAMETERFPROC ptrTexParameterf;
PFNGLACTIVETEXTUREPROC ptrActiveTexture;
PFNGLBLENDCOLORPROC ptrBlendColor;
PFNGLREADBUFFERPROC ptrReadBuffer;
PFNGLFINISHPROC ptrFinish;
PFNGLFLUSHPROC ptrFlush;
#if defined(OS_ANDROID)
PFNEGLGETNATIVECLIENTBUFFERANDROIDPROC ptrGetNativeClientBufferANDROID;
#endif

PFNGLCREATESHADERPROC ptrCreateShader;
PFNGLCOMPILESHADERPROC ptrCompileShader;
PFNGLSHADERSOURCEPROC ptrShaderSource;
PFNGLCREATEPROGRAMPROC ptrCreateProgram;
PFNGLATTACHSHADERPROC ptrAttachShader;
PFNGLLINKPROGRAMPROC ptrLinkProgram;
PFNGLUSEPROGRAMPROC ptrUseProgram;
PFNGLGETUNIFORMLOCATIONPROC ptrGetUniformLocation;
PFNGLUNIFORM1IPROC ptrUniform1i;
PFNGLUNIFORM1FPROC ptrUniform1f;
PFNGLUNIFORM2FPROC ptrUniform2f;
PFNGLUNIFORM2IPROC ptrUniform2i;
PFNGLUNIFORM4IPROC ptrUniform4i;
PFNGLUNIFORM4FPROC ptrUniform4f;
PFNGLUNIFORM3FVPROC ptrUniform3fv;
PFNGLUNIFORM4FVPROC ptrUniform4fv;
PFNGLDETACHSHADERPROC ptrDetachShader;
PFNGLDELETESHADERPROC ptrDeleteShader;
PFNGLDELETEPROGRAMPROC ptrDeleteProgram;
PFNGLGETPROGRAMINFOLOGPROC ptrGetProgramInfoLog;
PFNGLGETSHADERINFOLOGPROC ptrGetShaderInfoLog;
PFNGLGETSHADERIVPROC ptrGetShaderiv;
PFNGLGETPROGRAMIVPROC ptrGetProgramiv;

PFNGLENABLEVERTEXATTRIBARRAYPROC ptrEnableVertexAttribArray;
PFNGLDISABLEVERTEXATTRIBARRAYPROC ptrDisableVertexAttribArray;
PFNGLVERTEXATTRIBPOINTERPROC ptrVertexAttribPointer;
PFNGLBINDATTRIBLOCATIONPROC ptrBindAttribLocation;
PFNGLVERTEXATTRIB1FPROC ptrVertexAttrib1f;
PFNGLVERTEXATTRIB4FPROC ptrVertexAttrib4f;
PFNGLVERTEXATTRIB4FVPROC ptrVertexAttrib4fv;

// multitexture functions
PFNGLDEPTHRANGEFPROC ptrDepthRangef;
PFNGLCLEARDEPTHFPROC ptrClearDepthf;

PFNGLDRAWBUFFERSPROC ptrDrawBuffers;
PFNGLBINDFRAMEBUFFERPROC ptrBindFramebuffer;
PFNGLDELETEFRAMEBUFFERSPROC ptrDeleteFramebuffers;
PFNGLGENFRAMEBUFFERSPROC ptrGenFramebuffers;
PFNGLFRAMEBUFFERTEXTURE2DPROC ptrFramebufferTexture2D;
PFNGLTEXIMAGE2DMULTISAMPLEPROC ptrTexImage2DMultisample;
PFNGLTEXSTORAGE2DMULTISAMPLEPROC ptrTexStorage2DMultisample;
PFNGLGENRENDERBUFFERSPROC ptrGenRenderbuffers;
PFNGLBINDRENDERBUFFERPROC ptrBindRenderbuffer;
PFNGLRENDERBUFFERSTORAGEPROC ptrRenderbufferStorage;
PFNGLFRAMEBUFFERRENDERBUFFERPROC ptrFramebufferRenderbuffer;
PFNGLDELETERENDERBUFFERSPROC ptrDeleteRenderbuffers;
PFNGLCHECKFRAMEBUFFERSTATUSPROC ptrCheckFramebufferStatus;
PFNGLBLITFRAMEBUFFERPROC ptrBlitFramebuffer;
PFNGLGENVERTEXARRAYSPROC ptrGenVertexArrays;
PFNGLBINDVERTEXARRAYPROC ptrBindVertexArray;
PFNGLDELETEVERTEXARRAYSPROC ptrDeleteVertexArrays;
PFNGLGENBUFFERSPROC ptrGenBuffers;
PFNGLBINDBUFFERPROC ptrBindBuffer;
PFNGLBUFFERDATAPROC ptrBufferData;
PFNGLMAPBUFFERPROC ptrMapBuffer;
PFNGLMAPBUFFERRANGEPROC ptrMapBufferRange;
PFNGLUNMAPBUFFERPROC ptrUnmapBuffer;
PFNGLDELETEBUFFERSPROC ptrDeleteBuffers;
PFNGLBINDIMAGETEXTUREPROC ptrBindImageTexture;
PFNGLMEMORYBARRIERPROC ptrMemoryBarrier;
PFNGLGETSTRINGIPROC ptrGetStringi;
PFNGLINVALIDATEFRAMEBUFFERPROC ptrInvalidateFramebuffer;
PFNGLBUFFERSTORAGEPROC ptrBufferStorage;
PFNGLFENCESYNCPROC ptrFenceSync;
PFNGLCLIENTWAITSYNCPROC ptrClientWaitSync;
PFNGLDELETESYNCPROC ptrDeleteSync;

PFNGLGETUNIFORMBLOCKINDEXPROC ptrGetUniformBlockIndex;
PFNGLUNIFORMBLOCKBINDINGPROC ptrUniformBlockBinding;
PFNGLGETACTIVEUNIFORMBLOCKIVPROC ptrGetActiveUniformBlockiv;
PFNGLGETUNIFORMINDICESPROC ptrGetUniformIndices;
PFNGLGETACTIVEUNIFORMSIVPROC ptrGetActiveUniformsiv;
PFNGLBINDBUFFERBASEPROC ptrBindBufferBase;
PFNGLBUFFERSUBDATAPROC ptrBufferSubData;

PFNGLGETPROGRAMBINARYPROC ptrGetProgramBinary;
PFNGLPROGRAMBINARYPROC ptrProgramBinary;
PFNGLPROGRAMPARAMETERIPROC ptrProgramParameteri;

PFNGLTEXSTORAGE2DPROC ptrTexStorage2D;
PFNGLTEXTURESTORAGE2DPROC ptrTextureStorage2D;
PFNGLTEXTURESUBIMAGE2DPROC ptrTextureSubImage2D;
PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC ptrTextureStorage2DMultisample;
PFNGLTEXTUREPARAMETERIPROC ptrTextureParameteri;
PFNGLTEXTUREPARAMETERFPROC ptrTextureParameterf;
PFNGLCREATETEXTURESPROC ptrCreateTextures;
PFNGLCREATEBUFFERSPROC ptrCreateBuffers;
PFNGLCREATEFRAMEBUFFERSPROC ptrCreateFramebuffers;
PFNGLNAMEDFRAMEBUFFERTEXTUREPROC ptrNamedFramebufferTexture;
PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC ptrDrawRangeElementsBaseVertex;
PFNGLFLUSHMAPPEDBUFFERRANGEPROC ptrFlushMappedBufferRange;
PFNGLTEXTUREBARRIERPROC ptrTextureBarrier;
PFNGLTEXTUREBARRIERNVPROC ptrTextureBarrierNV;
PFNGLCLEARBUFFERFVPROC ptrClearBufferfv;
PFNGLENABLEIPROC ptrEnablei;
PFNGLDISABLEIPROC ptrDisablei;
PFNGLDEBUGMESSAGECALLBACKPROC ptrDebugMessageCallback;
PFNGLDEBUGMESSAGECONTROLPROC ptrDebugMessageControl;
PFNGLCOPYTEXIMAGE2DPROC ptrCopyTexImage2D;
PFNGLEGLIMAGETARGETTEXTURE2DOESPROC ptrEGLImageTargetTexture2DOES;
PFNGLEGLIMAGETARGETRENDERBUFFERSTORAGEOESPROC ptrEGLImageTargetRenderbufferStorageOES;

void initGLFunctions()
{
#ifdef VC
	void *gles2so = dlopen("/opt/vc/lib/libbrcmGLESv2.so", RTLD_NOW);
#elif defined(ODROID)
	void *gles2so = dlopen("/usr/lib/arm-linux-gnueabihf/libGLESv2.so", RTLD_NOW);
#elif defined(VERO4K)
       void *gles2so = dlopen("/opt/vero3/lib/libGLESv2.so", RTLD_NOW);
#endif

#if defined(EGL) || defined(OS_IOS)
	GL_GET_PROC_ADR(PFNGLBLENDFUNCPROC, BlendFunc);
	GL_GET_PROC_ADR(PFNGLPIXELSTOREIPROC, PixelStorei);
	GL_GET_PROC_ADR(PFNGLCLEARCOLORPROC, ClearColor);
	GL_GET_PROC_ADR(PFNGLCULLFACEPROC, CullFace);
	GL_GET_PROC_ADR(PFNGLDEPTHFUNCPROC, DepthFunc);
	GL_GET_PROC_ADR(PFNGLDEPTHMASKPROC, DepthMask);
	GL_GET_PROC_ADR(PFNGLDISABLEPROC, Disable);
	GL_GET_PROC_ADR(PFNGLENABLEPROC, Enable);
	GL_GET_PROC_ADR(PFNGLPOLYGONOFFSETPROC, PolygonOffset);
	GL_GET_PROC_ADR(PFNGLSCISSORPROC, Scissor);
	GL_GET_PROC_ADR(PFNGLVIEWPORTPROC, Viewport);
	GL_GET_PROC_ADR(PFNGLBINDTEXTUREPROC, BindTexture);
	GL_GET_PROC_ADR(PFNGLTEXIMAGE2DPROC, TexImage2D);
	GL_GET_PROC_ADR(PFNGLTEXPARAMETERIPROC, TexParameteri);
	GL_GET_PROC_ADR(PFNGLGETINTEGERVPROC, GetIntegerv);
	GL_GET_PROC_ADR(PFNGLGETSTRINGPROC, GetString);
	GL_GET_PROC_ADR(PFNGLREADPIXELSPROC, ReadPixels);
	GL_GET_PROC_ADR(PFNGLTEXSUBIMAGE2DPROC, TexSubImage2D);
	GL_GET_PROC_ADR(PFNGLDRAWARRAYSPROC, DrawArrays);
	GL_GET_PROC_ADR(PFNGLGETERRORPROC, GetError);
	GL_GET_PROC_ADR(PFNGLDRAWELEMENTSPROC, DrawElements);
	GL_GET_PROC_ADR(PFNGLLINEWIDTHPROC, LineWidth);
	GL_GET_PROC_ADR(PFNGLCLEARPROC, Clear);
	GL_GET_PROC_ADR(PFNGLGETFLOATVPROC, GetFloatv);
	GL_GET_PROC_ADR(PFNGLDELETETEXTURESPROC, DeleteTextures);
	GL_GET_PROC_ADR(PFNGLGENTEXTURESPROC, GenTextures);
	GL_GET_PROC_ADR(PFNGLTEXPARAMETERFPROC, TexParameterf);
	GL_GET_PROC_ADR(PFNGLACTIVETEXTUREPROC, ActiveTexture);
	GL_GET_PROC_ADR(PFNGLBLENDCOLORPROC, BlendColor);
	GL_GET_PROC_ADR(PFNGLREADBUFFERPROC, ReadBuffer);
	GL_GET_PROC_ADR(PFNGLFINISHPROC, Finish);
	GL_GET_PROC_ADR(PFNGLFLUSHPROC, Flush);
#if defined(OS_ANDROID)
	GL_GET_PROC_ADR_EGL(PFNEGLGETNATIVECLIENTBUFFERANDROIDPROC, GetNativeClientBufferANDROID);
#endif
#else
#ifdef OS_WINDOWS
	GL_GET_PROC_ADR(PFNGLACTIVETEXTUREPROC, ActiveTexture);
	GL_GET_PROC_ADR(PFNGLBLENDCOLORPROC, BlendColor);
#else
	ASSIGN_PROC_ADR(PFNGLACTIVETEXTUREPROC, ActiveTexture);
	ASSIGN_PROC_ADR(PFNGLBLENDCOLORPROC, BlendColor);
#endif
	ASSIGN_PROC_ADR(PFNGLBLENDFUNCPROC, BlendFunc);
	ASSIGN_PROC_ADR(PFNGLPIXELSTOREIPROC, PixelStorei);
	ASSIGN_PROC_ADR(PFNGLCLEARCOLORPROC, ClearColor);
	ASSIGN_PROC_ADR(PFNGLCULLFACEPROC, CullFace);
	ASSIGN_PROC_ADR(PFNGLDEPTHFUNCPROC, DepthFunc);
	ASSIGN_PROC_ADR(PFNGLDEPTHMASKPROC, DepthMask);
	ASSIGN_PROC_ADR(PFNGLDISABLEPROC, Disable);
	ASSIGN_PROC_ADR(PFNGLENABLEPROC, Enable);
	ASSIGN_PROC_ADR(PFNGLPOLYGONOFFSETPROC, PolygonOffset);
	ASSIGN_PROC_ADR(PFNGLSCISSORPROC, Scissor);
	ASSIGN_PROC_ADR(PFNGLVIEWPORTPROC, Viewport);
	ASSIGN_PROC_ADR(PFNGLBINDTEXTUREPROC, BindTexture);
	ASSIGN_PROC_ADR(PFNGLTEXIMAGE2DPROC, TexImage2D);
	ASSIGN_PROC_ADR(PFNGLTEXPARAMETERIPROC, TexParameteri);
	ASSIGN_PROC_ADR(PFNGLGETINTEGERVPROC, GetIntegerv);
	ASSIGN_PROC_ADR(PFNGLGETSTRINGPROC, GetString);
	ASSIGN_PROC_ADR(PFNGLREADPIXELSPROC, ReadPixels);
	ASSIGN_PROC_ADR(PFNGLTEXSUBIMAGE2DPROC, TexSubImage2D);
	ASSIGN_PROC_ADR(PFNGLDRAWARRAYSPROC, DrawArrays);
	ASSIGN_PROC_ADR(PFNGLGETERRORPROC, GetError);
	ASSIGN_PROC_ADR(PFNGLDRAWELEMENTSPROC, DrawElements);
	ASSIGN_PROC_ADR(PFNGLLINEWIDTHPROC, LineWidth);
	ASSIGN_PROC_ADR(PFNGLCLEARPROC, Clear);
	ASSIGN_PROC_ADR(PFNGLGETFLOATVPROC, GetFloatv);
	ASSIGN_PROC_ADR(PFNGLDELETETEXTURESPROC, DeleteTextures);
	ASSIGN_PROC_ADR(PFNGLGENTEXTURESPROC, GenTextures);
	ASSIGN_PROC_ADR(PFNGLTEXPARAMETERFPROC, TexParameterf);
	ASSIGN_PROC_ADR(PFNGLREADBUFFERPROC, ReadBuffer);
	ASSIGN_PROC_ADR(PFNGLFINISHPROC, Finish);
#endif

	GL_GET_PROC_ADR(PFNGLCREATESHADERPROC, CreateShader);
	GL_GET_PROC_ADR(PFNGLCOMPILESHADERPROC, CompileShader);
	GL_GET_PROC_ADR(PFNGLSHADERSOURCEPROC, ShaderSource);
	GL_GET_PROC_ADR(PFNGLCREATEPROGRAMPROC, CreateProgram);
	GL_GET_PROC_ADR(PFNGLATTACHSHADERPROC, AttachShader);
	GL_GET_PROC_ADR(PFNGLLINKPROGRAMPROC, LinkProgram);
	GL_GET_PROC_ADR(PFNGLUSEPROGRAMPROC, UseProgram);
	GL_GET_PROC_ADR(PFNGLGETUNIFORMLOCATIONPROC, GetUniformLocation);
	GL_GET_PROC_ADR(PFNGLUNIFORM1IPROC, Uniform1i);
	GL_GET_PROC_ADR(PFNGLUNIFORM1FPROC, Uniform1f);
	GL_GET_PROC_ADR(PFNGLUNIFORM2FPROC, Uniform2f);
	GL_GET_PROC_ADR(PFNGLUNIFORM2IPROC, Uniform2i);
	GL_GET_PROC_ADR(PFNGLUNIFORM4IPROC, Uniform4i);
	GL_GET_PROC_ADR(PFNGLUNIFORM4FPROC, Uniform4f);
	GL_GET_PROC_ADR(PFNGLUNIFORM3FVPROC, Uniform3fv);
	GL_GET_PROC_ADR(PFNGLUNIFORM4FVPROC, Uniform4fv);
	GL_GET_PROC_ADR(PFNGLDETACHSHADERPROC, DetachShader);
	GL_GET_PROC_ADR(PFNGLDELETESHADERPROC, DeleteShader);
	GL_GET_PROC_ADR(PFNGLDELETEPROGRAMPROC, DeleteProgram);
	GL_GET_PROC_ADR(PFNGLGETPROGRAMINFOLOGPROC, GetProgramInfoLog);
	GL_GET_PROC_ADR(PFNGLGETSHADERINFOLOGPROC, GetShaderInfoLog);
	GL_GET_PROC_ADR(PFNGLGETSHADERIVPROC, GetShaderiv);
	GL_GET_PROC_ADR(PFNGLGETPROGRAMIVPROC, GetProgramiv);

	GL_GET_PROC_ADR(PFNGLENABLEVERTEXATTRIBARRAYPROC, EnableVertexAttribArray);
	GL_GET_PROC_ADR(PFNGLDISABLEVERTEXATTRIBARRAYPROC, DisableVertexAttribArray);
	GL_GET_PROC_ADR(PFNGLVERTEXATTRIBPOINTERPROC, VertexAttribPointer);
	GL_GET_PROC_ADR(PFNGLBINDATTRIBLOCATIONPROC, BindAttribLocation);
	GL_GET_PROC_ADR(PFNGLVERTEXATTRIB1FPROC, VertexAttrib1f);
	GL_GET_PROC_ADR(PFNGLVERTEXATTRIB4FPROC, VertexAttrib4f);
	GL_GET_PROC_ADR(PFNGLVERTEXATTRIB4FVPROC, VertexAttrib4fv);

	GL_GET_PROC_ADR(PFNGLDEPTHRANGEFPROC, DepthRangef);
	GL_GET_PROC_ADR(PFNGLCLEARDEPTHFPROC, ClearDepthf);

	GL_GET_PROC_ADR(PFNGLDRAWBUFFERSPROC, DrawBuffers);
	GL_GET_PROC_ADR(PFNGLBINDFRAMEBUFFERPROC, BindFramebuffer);
	GL_GET_PROC_ADR(PFNGLDELETEFRAMEBUFFERSPROC, DeleteFramebuffers);
	GL_GET_PROC_ADR(PFNGLGENFRAMEBUFFERSPROC, GenFramebuffers);
	GL_GET_PROC_ADR(PFNGLFRAMEBUFFERTEXTURE2DPROC, FramebufferTexture2D);
	GL_GET_PROC_ADR(PFNGLTEXIMAGE2DMULTISAMPLEPROC, TexImage2DMultisample);
	GL_GET_PROC_ADR(PFNGLTEXSTORAGE2DMULTISAMPLEPROC, TexStorage2DMultisample);
	GL_GET_PROC_ADR(PFNGLGENRENDERBUFFERSPROC, GenRenderbuffers);
	GL_GET_PROC_ADR(PFNGLBINDRENDERBUFFERPROC, BindRenderbuffer);
	GL_GET_PROC_ADR(PFNGLRENDERBUFFERSTORAGEPROC, RenderbufferStorage);
	GL_GET_PROC_ADR(PFNGLFRAMEBUFFERRENDERBUFFERPROC, FramebufferRenderbuffer);
	GL_GET_PROC_ADR(PFNGLDELETERENDERBUFFERSPROC, DeleteRenderbuffers);
	GL_GET_PROC_ADR(PFNGLCHECKFRAMEBUFFERSTATUSPROC, CheckFramebufferStatus);
	GL_GET_PROC_ADR(PFNGLBLITFRAMEBUFFERPROC, BlitFramebuffer);
	GL_GET_PROC_ADR(PFNGLGENVERTEXARRAYSPROC, GenVertexArrays);
	GL_GET_PROC_ADR(PFNGLBINDVERTEXARRAYPROC, BindVertexArray);
	GL_GET_PROC_ADR(PFNGLDELETEVERTEXARRAYSPROC, DeleteVertexArrays);
	GL_GET_PROC_ADR(PFNGLGENBUFFERSPROC, GenBuffers);
	GL_GET_PROC_ADR(PFNGLBINDBUFFERPROC, BindBuffer);
	GL_GET_PROC_ADR(PFNGLBUFFERDATAPROC, BufferData);
	GL_GET_PROC_ADR(PFNGLMAPBUFFERPROC, MapBuffer);
	GL_GET_PROC_ADR(PFNGLMAPBUFFERRANGEPROC, MapBufferRange);
	GL_GET_PROC_ADR(PFNGLUNMAPBUFFERPROC, UnmapBuffer);
	GL_GET_PROC_ADR(PFNGLDELETEBUFFERSPROC, DeleteBuffers);
	GL_GET_PROC_ADR(PFNGLBINDIMAGETEXTUREPROC, BindImageTexture);
	GL_GET_PROC_ADR(PFNGLMEMORYBARRIERPROC, MemoryBarrier);
	GL_GET_PROC_ADR(PFNGLGETSTRINGIPROC, GetStringi);
	GL_GET_PROC_ADR(PFNGLINVALIDATEFRAMEBUFFERPROC, InvalidateFramebuffer);
	GL_GET_PROC_ADR(PFNGLBUFFERSTORAGEPROC, BufferStorage);
	GL_GET_PROC_ADR(PFNGLFENCESYNCPROC, FenceSync);
	GL_GET_PROC_ADR(PFNGLCLIENTWAITSYNCPROC, ClientWaitSync);
	GL_GET_PROC_ADR(PFNGLDELETESYNCPROC, DeleteSync);

	GL_GET_PROC_ADR(PFNGLGETUNIFORMBLOCKINDEXPROC, GetUniformBlockIndex);
	GL_GET_PROC_ADR(PFNGLUNIFORMBLOCKBINDINGPROC, UniformBlockBinding);
	GL_GET_PROC_ADR(PFNGLGETACTIVEUNIFORMBLOCKIVPROC, GetActiveUniformBlockiv);
	GL_GET_PROC_ADR(PFNGLGETUNIFORMINDICESPROC, GetUniformIndices);
	GL_GET_PROC_ADR(PFNGLGETACTIVEUNIFORMSIVPROC, GetActiveUniformsiv);
	GL_GET_PROC_ADR(PFNGLBINDBUFFERBASEPROC, BindBufferBase);
	GL_GET_PROC_ADR(PFNGLBUFFERSUBDATAPROC, BufferSubData);

	GL_GET_PROC_ADR(PFNGLGETPROGRAMBINARYPROC, GetProgramBinary);
	GL_GET_PROC_ADR(PFNGLPROGRAMBINARYPROC, ProgramBinary);
	GL_GET_PROC_ADR(PFNGLPROGRAMPARAMETERIPROC, ProgramParameteri);

	GL_GET_PROC_ADR(PFNGLTEXSTORAGE2DPROC, TexStorage2D);
	GL_GET_PROC_ADR(PFNGLTEXTURESTORAGE2DPROC, TextureStorage2D);
	GL_GET_PROC_ADR(PFNGLTEXTURESUBIMAGE2DPROC, TextureSubImage2D);
	GL_GET_PROC_ADR(PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC, TextureStorage2DMultisample);

	GL_GET_PROC_ADR(PFNGLTEXTUREPARAMETERIPROC, TextureParameteri);
	GL_GET_PROC_ADR(PFNGLTEXTUREPARAMETERFPROC, TextureParameterf);
	GL_GET_PROC_ADR(PFNGLCREATETEXTURESPROC, CreateTextures);
	GL_GET_PROC_ADR(PFNGLCREATEBUFFERSPROC, CreateBuffers);
	GL_GET_PROC_ADR(PFNGLCREATEFRAMEBUFFERSPROC, CreateFramebuffers);
	GL_GET_PROC_ADR(PFNGLNAMEDFRAMEBUFFERTEXTUREPROC, NamedFramebufferTexture);
	GL_GET_PROC_ADR(PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC, DrawRangeElementsBaseVertex);
	GL_GET_PROC_ADR(PFNGLFLUSHMAPPEDBUFFERRANGEPROC, FlushMappedBufferRange);
	GL_GET_PROC_ADR(PFNGLTEXTUREBARRIERPROC, TextureBarrier);
	GL_GET_PROC_ADR(PFNGLTEXTUREBARRIERNVPROC, TextureBarrierNV);
	GL_GET_PROC_ADR(PFNGLCLEARBUFFERFVPROC, ClearBufferfv);
	GL_GET_PROC_ADR(PFNGLENABLEIPROC, Enablei);
	GL_GET_PROC_ADR(PFNGLDISABLEIPROC, Disablei);
	GL_GET_PROC_ADR(PFNGLDEBUGMESSAGECALLBACKPROC, DebugMessageCallback);
	GL_GET_PROC_ADR(PFNGLDEBUGMESSAGECONTROLPROC, DebugMessageControl);
	GL_GET_PROC_ADR(PFNGLCOPYTEXIMAGE2DPROC, CopyTexImage2D);

	GL_GET_PROC_ADR(PFNGLEGLIMAGETARGETTEXTURE2DOESPROC, EGLImageTargetTexture2DOES);
	GL_GET_PROC_ADR(PFNGLEGLIMAGETARGETRENDERBUFFERSTORAGEOESPROC, EGLImageTargetRenderbufferStorageOES);

	GL_GET_PROC_ADR(PFNGLBLENDFUNCSEPARATEPROC, BlendFuncSeparate);

}
