#include "gcm_printing.h"
#include "rsx_decode.h"
#include <unordered_map>
#include <Utilities/StrFmt.h>

namespace
{
	constexpr u32 opcode_list[] = {NV4097_SET_VIEWPORT_HORIZONTAL, NV4097_SET_VIEWPORT_VERTICAL,
		NV4097_SET_SCISSOR_HORIZONTAL, NV4097_SET_SCISSOR_VERTICAL, NV4097_SET_SURFACE_CLIP_HORIZONTAL,
		NV4097_SET_SURFACE_CLIP_VERTICAL, NV4097_SET_CLEAR_RECT_HORIZONTAL,
		NV4097_SET_CLEAR_RECT_VERTICAL, NV3089_CLIP_POINT, NV3089_CLIP_SIZE, NV3089_IMAGE_OUT_POINT,
		NV3089_IMAGE_OUT_SIZE, NV3089_IMAGE_IN_SIZE, NV3062_SET_PITCH, NV308A_POINT,
		NV4097_SET_DEPTH_TEST_ENABLE, NV4097_SET_DEPTH_MASK, NV4097_SET_ALPHA_TEST_ENABLE,
		NV4097_SET_STENCIL_TEST_ENABLE, NV4097_SET_RESTART_INDEX_ENABLE,
		NV4097_SET_DEPTH_BOUNDS_TEST_ENABLE, NV4097_SET_LOGIC_OP_ENABLE, NV4097_SET_DITHER_ENABLE,
		NV4097_SET_BLEND_ENABLE, NV4097_SET_LINE_SMOOTH_ENABLE, NV4097_SET_POLY_OFFSET_POINT_ENABLE,
		NV4097_SET_POLY_OFFSET_LINE_ENABLE, NV4097_SET_POLY_OFFSET_FILL_ENABLE,
		NV4097_SET_CULL_FACE_ENABLE, NV4097_SET_POLY_SMOOTH_ENABLE,
		NV4097_SET_TWO_SIDED_STENCIL_TEST_ENABLE, NV4097_SET_TWO_SIDE_LIGHT_EN,
		NV4097_SET_RESTART_INDEX, NV4097_SET_SURFACE_COLOR_AOFFSET, NV4097_SET_SURFACE_COLOR_BOFFSET,
		NV4097_SET_SURFACE_COLOR_COFFSET, NV4097_SET_SURFACE_COLOR_DOFFSET, NV4097_SET_SURFACE_PITCH_A,
		NV4097_SET_SURFACE_PITCH_B, NV4097_SET_SURFACE_PITCH_C, NV4097_SET_SURFACE_PITCH_D,
		NV4097_SET_SURFACE_ZETA_OFFSET, NV4097_SET_SURFACE_PITCH_Z,
		NV4097_SET_VERTEX_ATTRIB_OUTPUT_MASK, NV4097_SET_SHADER_CONTROL,
		NV4097_SET_VERTEX_DATA_BASE_OFFSET, NV4097_SET_INDEX_ARRAY_ADDRESS,
		NV4097_SET_VERTEX_DATA_BASE_INDEX, NV4097_SET_SHADER_PROGRAM,
		NV4097_SET_TRANSFORM_PROGRAM_START, NV406E_SET_CONTEXT_DMA_SEMAPHORE, NV406E_SEMAPHORE_OFFSET, NV4097_SET_SEMAPHORE_OFFSET,
		NV3089_IMAGE_IN_OFFSET, NV3062_SET_OFFSET_DESTIN, NV309E_SET_OFFSET, NV3089_DS_DX, NV3089_DT_DY,
		NV0039_PITCH_IN, NV0039_PITCH_OUT, NV0039_LINE_LENGTH_IN, NV0039_LINE_COUNT, NV0039_OFFSET_OUT,
		NV0039_OFFSET_IN, NV4097_SET_VERTEX_ATTRIB_INPUT_MASK, NV4097_SET_FREQUENCY_DIVIDER_OPERATION,
		NV4097_SET_DEPTH_BOUNDS_MIN, NV4097_SET_DEPTH_BOUNDS_MAX, NV4097_SET_FOG_PARAMS,
		NV4097_SET_FOG_PARAMS + 1, NV4097_SET_CLIP_MIN, NV4097_SET_CLIP_MAX,
		NV4097_SET_POLYGON_OFFSET_SCALE_FACTOR, NV4097_SET_POLYGON_OFFSET_BIAS,
		NV4097_SET_VIEWPORT_SCALE, NV4097_SET_VIEWPORT_SCALE + 1, NV4097_SET_VIEWPORT_SCALE + 2,
		NV4097_SET_VIEWPORT_SCALE + 3, NV4097_SET_VIEWPORT_OFFSET, NV4097_SET_VIEWPORT_OFFSET + 1,
		NV4097_SET_VIEWPORT_OFFSET + 2, NV4097_SET_VIEWPORT_OFFSET + 3, NV4097_SET_DEPTH_FUNC,
		NV4097_SET_STENCIL_FUNC, NV4097_SET_BACK_STENCIL_FUNC, NV4097_SET_STENCIL_OP_FAIL,
		NV4097_SET_STENCIL_OP_ZFAIL, NV4097_SET_STENCIL_OP_ZPASS, NV4097_SET_BACK_STENCIL_OP_FAIL,
		NV4097_SET_BACK_STENCIL_OP_ZFAIL, NV4097_SET_BACK_STENCIL_OP_ZPASS, NV4097_SET_LOGIC_OP,
		NV4097_SET_FRONT_FACE, NV4097_SET_CULL_FACE, NV4097_SET_SURFACE_COLOR_TARGET,
		NV4097_SET_FOG_MODE, NV4097_SET_ALPHA_FUNC, NV4097_SET_BEGIN_END, NV3089_SET_OPERATION,
		NV3089_SET_COLOR_FORMAT, NV3089_SET_CONTEXT_SURFACE, NV3062_SET_COLOR_FORMAT,
		NV4097_SET_STENCIL_FUNC_REF, NV4097_SET_BACK_STENCIL_FUNC_REF, NV4097_SET_STENCIL_FUNC_MASK,
		NV4097_SET_BACK_STENCIL_FUNC_MASK, NV4097_SET_ALPHA_REF, NV4097_SET_COLOR_CLEAR_VALUE,
		NV4097_SET_STENCIL_MASK, NV4097_SET_BACK_STENCIL_MASK, NV4097_SET_BLEND_EQUATION,
		NV4097_SET_BLEND_FUNC_SFACTOR, NV4097_SET_BLEND_FUNC_DFACTOR, NV4097_SET_COLOR_MASK,
		NV4097_SET_SHADER_WINDOW, NV4097_SET_BLEND_ENABLE_MRT, NV4097_SET_USER_CLIP_PLANE_CONTROL,
		NV4097_SET_LINE_WIDTH, NV4097_SET_SURFACE_FORMAT, NV4097_SET_WINDOW_OFFSET,
		NV4097_SET_ZSTENCIL_CLEAR_VALUE, NV4097_SET_INDEX_ARRAY_DMA, NV4097_SET_CONTEXT_DMA_COLOR_A,
		NV4097_SET_CONTEXT_DMA_COLOR_B, NV4097_SET_CONTEXT_DMA_COLOR_C, NV4097_SET_CONTEXT_DMA_COLOR_D,
		NV4097_SET_CONTEXT_DMA_ZETA, NV3089_SET_CONTEXT_DMA_IMAGE, NV3062_SET_CONTEXT_DMA_IMAGE_DESTIN,
		NV309E_SET_CONTEXT_DMA_IMAGE, NV0039_SET_CONTEXT_DMA_BUFFER_OUT,
		NV0039_SET_CONTEXT_DMA_BUFFER_IN, NV4097_SET_CONTEXT_DMA_REPORT, NV3089_IMAGE_IN_FORMAT,
		NV309E_SET_FORMAT, NV0039_FORMAT, NV4097_SET_BLEND_COLOR2, NV4097_SET_BLEND_COLOR,
		NV3089_IMAGE_IN, NV4097_NO_OPERATION, NV4097_INVALIDATE_VERTEX_CACHE_FILE,
		NV4097_INVALIDATE_VERTEX_FILE, NV4097_SET_ANTI_ALIASING_CONTROL, NV4097_SET_FRONT_POLYGON_MODE,
		NV4097_SET_BACK_POLYGON_MODE, NV406E_SET_REFERENCE, NV406E_SEMAPHORE_RELEASE, NV406E_SEMAPHORE_ACQUIRE,
		NV4097_SET_ZCULL_EN, NV4097_SET_ZCULL_STATS_ENABLE, NV4097_SET_ZPASS_PIXEL_COUNT_ENABLE,
		EXPAND_RANGE_16(0, DECLARE_VERTEX_DATA_ARRAY_FORMAT)
	    	EXPAND_RANGE_16(0, DECLARE_VERTEX_DATA_ARRAY_OFFSET)
	    		EXPAND_RANGE_32(0, DECLARE_TRANSFORM_CONSTANT) NV4097_SET_TRANSFORM_CONSTANT_LOAD,
		NV4097_DRAW_ARRAYS, NV4097_DRAW_INDEX_ARRAY,
		EXPAND_RANGE_32(0, DECLARE_TRANSFORM_PROGRAM) NV4097_SET_TRANSFORM_PROGRAM_LOAD,
		EXPAND_RANGE_16(0, DECLARE_TEXTURE_OFFSET) EXPAND_RANGE_16(0, DECLARE_TEXTURE_FORMAT)
		EXPAND_RANGE_16(0, DECLARE_TEXTURE_IMAGE_RECT) EXPAND_RANGE_16(0, DECLARE_TEXTURE_CONTROL0)
		EXPAND_RANGE_16(0, DECLARE_TEXTURE_CONTROL3) EXPAND_RANGE_4(0, DECLARE_VERTEX_TEXTURE_CONTROL0)};

	#define KEY_STR(key) { key, #key }

	const std::unordered_map<u32, std::string_view> methods_name =
	{
		{NV406E_SET_REFERENCE, "NV406E_SET_REFERENCE"},
		{NV406E_SET_CONTEXT_DMA_SEMAPHORE, "NV406E_SET_CONTEXT_DMA_SEMAPHORE"},
		{NV406E_SEMAPHORE_OFFSET, "NV406E_SEMAPHORE_OFFSET"},
		{NV406E_SEMAPHORE_ACQUIRE, "NV406E_SEMAPHORE_ACQUIRE"},
		{NV406E_SEMAPHORE_RELEASE, "NV406E_SEMAPHORE_RELEASE"},
		{NV4097_SET_OBJECT, "NV4097_SET_OBJECT"},
		{NV4097_NO_OPERATION, "NV4097_NO_OPERATION"},
		{NV4097_NOTIFY, "NV4097_NOTIFY"},
		{NV4097_WAIT_FOR_IDLE, "NV4097_WAIT_FOR_IDLE"},
		{NV4097_PM_TRIGGER, "NV4097_PM_TRIGGER"},
		{NV4097_SET_CONTEXT_DMA_NOTIFIES, "NV4097_SET_CONTEXT_DMA_NOTIFIES"},
		{NV4097_SET_CONTEXT_DMA_A, "NV4097_SET_CONTEXT_DMA_A"},
		{NV4097_SET_CONTEXT_DMA_B, "NV4097_SET_CONTEXT_DMA_B"},
		{NV4097_SET_CONTEXT_DMA_COLOR_B, "NV4097_SET_CONTEXT_DMA_COLOR_B"},
		{NV4097_SET_CONTEXT_DMA_STATE, "NV4097_SET_CONTEXT_DMA_STATE"},
		{NV4097_SET_CONTEXT_DMA_COLOR_A, "NV4097_SET_CONTEXT_DMA_COLOR_A"},
		{NV4097_SET_CONTEXT_DMA_ZETA, "NV4097_SET_CONTEXT_DMA_ZETA"},
		{NV4097_SET_CONTEXT_DMA_VERTEX_A, "NV4097_SET_CONTEXT_DMA_VERTEX_A"},
		{NV4097_SET_CONTEXT_DMA_VERTEX_B, "NV4097_SET_CONTEXT_DMA_VERTEX_B"},
		{NV4097_SET_CONTEXT_DMA_SEMAPHORE, "NV4097_SET_CONTEXT_DMA_SEMAPHORE"},
		{NV4097_SET_CONTEXT_DMA_REPORT, "NV4097_SET_CONTEXT_DMA_REPORT"},
		{NV4097_SET_CONTEXT_DMA_CLIP_ID, "NV4097_SET_CONTEXT_DMA_CLIP_ID"},
		{NV4097_SET_CONTEXT_DMA_CULL_DATA, "NV4097_SET_CONTEXT_DMA_CULL_DATA"},
		{NV4097_SET_CONTEXT_DMA_COLOR_C, "NV4097_SET_CONTEXT_DMA_COLOR_C"},
		{NV4097_SET_CONTEXT_DMA_COLOR_D, "NV4097_SET_CONTEXT_DMA_COLOR_D"},
		{NV4097_SET_SURFACE_CLIP_HORIZONTAL, "NV4097_SET_SURFACE_CLIP_HORIZONTAL"},
		{NV4097_SET_SURFACE_CLIP_VERTICAL, "NV4097_SET_SURFACE_CLIP_VERTICAL"},
		{NV4097_SET_SURFACE_FORMAT, "NV4097_SET_SURFACE_FORMAT"},
		{NV4097_SET_SURFACE_PITCH_A, "NV4097_SET_SURFACE_PITCH_A"},
		{NV4097_SET_SURFACE_COLOR_AOFFSET, "NV4097_SET_SURFACE_COLOR_AOFFSET"},
		{NV4097_SET_SURFACE_ZETA_OFFSET, "NV4097_SET_SURFACE_ZETA_OFFSET"},
		{NV4097_SET_SURFACE_COLOR_BOFFSET, "NV4097_SET_SURFACE_COLOR_BOFFSET"},
		{NV4097_SET_SURFACE_PITCH_B, "NV4097_SET_SURFACE_PITCH_B"},
		{NV4097_SET_SURFACE_COLOR_TARGET, "NV4097_SET_SURFACE_COLOR_TARGET"},
		{NV4097_SET_SURFACE_PITCH_Z, "NV4097_SET_SURFACE_PITCH_Z"},
		{NV4097_INVALIDATE_ZCULL, "NV4097_INVALIDATE_ZCULL"},
		{NV4097_SET_CYLINDRICAL_WRAP, "NV4097_SET_CYLINDRICAL_WRAP"},
		{NV4097_SET_CYLINDRICAL_WRAP1, "NV4097_SET_CYLINDRICAL_WRAP1"},
		{NV4097_SET_SURFACE_PITCH_C, "NV4097_SET_SURFACE_PITCH_C"},
		{NV4097_SET_SURFACE_PITCH_D, "NV4097_SET_SURFACE_PITCH_D"},
		{NV4097_SET_SURFACE_COLOR_COFFSET, "NV4097_SET_SURFACE_COLOR_COFFSET"},
		{NV4097_SET_SURFACE_COLOR_DOFFSET, "NV4097_SET_SURFACE_COLOR_DOFFSET"},
		{NV4097_SET_WINDOW_OFFSET, "NV4097_SET_WINDOW_OFFSET"},
		{NV4097_SET_WINDOW_CLIP_TYPE, "NV4097_SET_WINDOW_CLIP_TYPE"},
		{NV4097_SET_WINDOW_CLIP_HORIZONTAL, "NV4097_SET_WINDOW_CLIP_HORIZONTAL"},
		{NV4097_SET_WINDOW_CLIP_VERTICAL, "NV4097_SET_WINDOW_CLIP_VERTICAL"},
		{NV4097_SET_DITHER_ENABLE, "NV4097_SET_DITHER_ENABLE"},
		{NV4097_SET_ALPHA_TEST_ENABLE, "NV4097_SET_ALPHA_TEST_ENABLE"},
		{NV4097_SET_ALPHA_FUNC, "NV4097_SET_ALPHA_FUNC"},
		{NV4097_SET_ALPHA_REF, "NV4097_SET_ALPHA_REF"},
		{NV4097_SET_BLEND_ENABLE, "NV4097_SET_BLEND_ENABLE"},
		{NV4097_SET_BLEND_FUNC_SFACTOR, "NV4097_SET_BLEND_FUNC_SFACTOR"},
		{NV4097_SET_BLEND_FUNC_DFACTOR, "NV4097_SET_BLEND_FUNC_DFACTOR"},
		{NV4097_SET_BLEND_COLOR, "NV4097_SET_BLEND_COLOR"},
		{NV4097_SET_BLEND_EQUATION, "NV4097_SET_BLEND_EQUATION"},
		{NV4097_SET_COLOR_MASK, "NV4097_SET_COLOR_MASK"},
		{NV4097_SET_STENCIL_TEST_ENABLE, "NV4097_SET_STENCIL_TEST_ENABLE"},
		{NV4097_SET_STENCIL_MASK, "NV4097_SET_STENCIL_MASK"},
		{NV4097_SET_STENCIL_FUNC, "NV4097_SET_STENCIL_FUNC"},
		{NV4097_SET_STENCIL_FUNC_REF, "NV4097_SET_STENCIL_FUNC_REF"},
		{NV4097_SET_STENCIL_FUNC_MASK, "NV4097_SET_STENCIL_FUNC_MASK"},
		{NV4097_SET_STENCIL_OP_FAIL, "NV4097_SET_STENCIL_OP_FAIL"},
		{NV4097_SET_STENCIL_OP_ZFAIL, "NV4097_SET_STENCIL_OP_ZFAIL"},
		{NV4097_SET_STENCIL_OP_ZPASS, "NV4097_SET_STENCIL_OP_ZPASS"},
		{NV4097_SET_TWO_SIDED_STENCIL_TEST_ENABLE, "NV4097_SET_TWO_SIDED_STENCIL_TEST_ENABLE"},
		{NV4097_SET_BACK_STENCIL_MASK, "NV4097_SET_BACK_STENCIL_MASK"},
		{NV4097_SET_BACK_STENCIL_FUNC, "NV4097_SET_BACK_STENCIL_FUNC"},
		{NV4097_SET_BACK_STENCIL_FUNC_REF, "NV4097_SET_BACK_STENCIL_FUNC_REF"},
		{NV4097_SET_BACK_STENCIL_FUNC_MASK, "NV4097_SET_BACK_STENCIL_FUNC_MASK"},
		{NV4097_SET_BACK_STENCIL_OP_FAIL, "NV4097_SET_BACK_STENCIL_OP_FAIL"},
		{NV4097_SET_BACK_STENCIL_OP_ZFAIL, "NV4097_SET_BACK_STENCIL_OP_ZFAIL"},
		{NV4097_SET_BACK_STENCIL_OP_ZPASS, "NV4097_SET_BACK_STENCIL_OP_ZPASS"},
		{NV4097_SET_SHADE_MODE, "NV4097_SET_SHADE_MODE"},
		{NV4097_SET_BLEND_ENABLE_MRT, "NV4097_SET_BLEND_ENABLE_MRT"},
		{NV4097_SET_COLOR_MASK_MRT, "NV4097_SET_COLOR_MASK_MRT"},
		{NV4097_SET_LOGIC_OP_ENABLE, "NV4097_SET_LOGIC_OP_ENABLE"},
		{NV4097_SET_LOGIC_OP, "NV4097_SET_LOGIC_OP"},
		{NV4097_SET_BLEND_COLOR2, "NV4097_SET_BLEND_COLOR2"},
		{NV4097_SET_DEPTH_BOUNDS_TEST_ENABLE, "NV4097_SET_DEPTH_BOUNDS_TEST_ENABLE"},
		{NV4097_SET_DEPTH_BOUNDS_MIN, "NV4097_SET_DEPTH_BOUNDS_MIN"},
		{NV4097_SET_DEPTH_BOUNDS_MAX, "NV4097_SET_DEPTH_BOUNDS_MAX"},
		{NV4097_SET_CLIP_MIN, "NV4097_SET_CLIP_MIN"},
		{NV4097_SET_CLIP_MAX, "NV4097_SET_CLIP_MAX"},
		{NV4097_SET_CONTROL0, "NV4097_SET_CONTROL0"},
		{NV4097_SET_LINE_WIDTH, "NV4097_SET_LINE_WIDTH"},
		{NV4097_SET_LINE_SMOOTH_ENABLE, "NV4097_SET_LINE_SMOOTH_ENABLE"},
		{NV4097_SET_ANISO_SPREAD, "NV4097_SET_ANISO_SPREAD"},
		{NV4097_SET_ANISO_SPREAD + 4 / 4, "NV4097_SET_ANISO_SPREAD + 4"},
		{NV4097_SET_ANISO_SPREAD + 8 / 4, "NV4097_SET_ANISO_SPREAD + 8"},
		{NV4097_SET_ANISO_SPREAD + 12 / 4, "NV4097_SET_ANISO_SPREAD + 12"},
		{NV4097_SET_ANISO_SPREAD + 16 / 4, "NV4097_SET_ANISO_SPREAD + 16"},
		{NV4097_SET_ANISO_SPREAD + 20 / 4, "NV4097_SET_ANISO_SPREAD + 20"},
		{NV4097_SET_ANISO_SPREAD + 24 / 4, "NV4097_SET_ANISO_SPREAD + 24"},
		{NV4097_SET_ANISO_SPREAD + 28 / 4, "NV4097_SET_ANISO_SPREAD + 28"},
		{NV4097_SET_ANISO_SPREAD + 32 / 4, "NV4097_SET_ANISO_SPREAD + 32"},
		{NV4097_SET_ANISO_SPREAD + 36 / 4, "NV4097_SET_ANISO_SPREAD + 36"},
		{NV4097_SET_ANISO_SPREAD + 40 / 4, "NV4097_SET_ANISO_SPREAD + 40"},
		{NV4097_SET_ANISO_SPREAD + 44 / 4, "NV4097_SET_ANISO_SPREAD + 44"},
		{NV4097_SET_ANISO_SPREAD + 48 / 4, "NV4097_SET_ANISO_SPREAD + 48"},
		{NV4097_SET_ANISO_SPREAD + 52 / 4, "NV4097_SET_ANISO_SPREAD + 52"},
		{NV4097_SET_ANISO_SPREAD + 56 / 4, "NV4097_SET_ANISO_SPREAD + 56"},
		{NV4097_SET_ANISO_SPREAD + 60 / 4, "NV4097_SET_ANISO_SPREAD + 60"},
		{NV4097_SET_SCISSOR_HORIZONTAL, "NV4097_SET_SCISSOR_HORIZONTAL"},
		{NV4097_SET_SCISSOR_VERTICAL, "NV4097_SET_SCISSOR_VERTICAL"},
		{NV4097_SET_FOG_MODE, "NV4097_SET_FOG_MODE"},
		{NV4097_SET_FOG_PARAMS, "NV4097_SET_FOG_PARAMS"},
		{NV4097_SET_FOG_PARAMS + 4 / 4, "NV4097_SET_FOG_PARAMS + 4"},
		{NV4097_SET_FOG_PARAMS + 8 / 4, "NV4097_SET_FOG_PARAMS + 8"},
		{NV4097_SET_SHADER_PROGRAM, "NV4097_SET_SHADER_PROGRAM"},
		{NV4097_SET_VERTEX_TEXTURE_OFFSET, "NV4097_SET_VERTEX_TEXTURE_OFFSET"},
		{NV4097_SET_VERTEX_TEXTURE_FORMAT, "NV4097_SET_VERTEX_TEXTURE_FORMAT"},
		{NV4097_SET_VERTEX_TEXTURE_ADDRESS, "NV4097_SET_VERTEX_TEXTURE_ADDRESS"},
		{NV4097_SET_VERTEX_TEXTURE_CONTROL0, "NV4097_SET_VERTEX_TEXTURE_CONTROL0"},
		{NV4097_SET_VERTEX_TEXTURE_CONTROL3, "NV4097_SET_VERTEX_TEXTURE_CONTROL3"},
		{NV4097_SET_VERTEX_TEXTURE_FILTER, "NV4097_SET_VERTEX_TEXTURE_FILTER"},
		{NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT, "NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT"},
		{NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR, "NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR"},
		{NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x20"},
		{NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x20"},
		{NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x20"},
		{NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x20"},
		{NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x20"},
		{NV4097_SET_VERTEX_TEXTURE_FILTER + 0x20 / 4, "NV4097_SET_VERTEX_TEXTURE_FILTER + 0x20"},
		{NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x20 / 4,
			"NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x20"},
		{NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x20 / 4,
			"NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x20"},
		{NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x40"},
		{NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x40"},
		{NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x40"},
		{NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x40"},
		{NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x40"},
		{NV4097_SET_VERTEX_TEXTURE_FILTER + 0x40 / 4, "NV4097_SET_VERTEX_TEXTURE_FILTER + 0x40"},
		{NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x40 / 4,
			"NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x40"},
		{NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x40 / 4,
			"NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x40"},
		{NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_OFFSET + 0x60"},
		{NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_FORMAT + 0x60"},
		{NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_ADDRESS + 0x60"},
		{NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL0 + 0x60"},
		{NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_CONTROL3 + 0x60"},
		{NV4097_SET_VERTEX_TEXTURE_FILTER + 0x60 / 4, "NV4097_SET_VERTEX_TEXTURE_FILTER + 0x60"},
		{NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x60 / 4,
			"NV4097_SET_VERTEX_TEXTURE_IMAGE_RECT + 0x60"},
		{NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x60 / 4,
			"NV4097_SET_VERTEX_TEXTURE_BORDER_COLOR + 0x60"},
		{NV4097_SET_VIEWPORT_HORIZONTAL, "NV4097_SET_VIEWPORT_HORIZONTAL"},
		{NV4097_SET_VIEWPORT_VERTICAL, "NV4097_SET_VIEWPORT_VERTICAL"},
		{NV4097_SET_POINT_CENTER_MODE, "NV4097_SET_POINT_CENTER_MODE"},
		{NV4097_ZCULL_SYNC, "NV4097_ZCULL_SYNC"},
		{NV4097_SET_VIEWPORT_OFFSET, "NV4097_SET_VIEWPORT_OFFSET"},
		{NV4097_SET_VIEWPORT_SCALE, "NV4097_SET_VIEWPORT_SCALE"},
		{NV4097_SET_POLY_OFFSET_POINT_ENABLE, "NV4097_SET_POLY_OFFSET_POINT_ENABLE"},
		{NV4097_SET_POLY_OFFSET_LINE_ENABLE, "NV4097_SET_POLY_OFFSET_LINE_ENABLE"},
		{NV4097_SET_POLY_OFFSET_FILL_ENABLE, "NV4097_SET_POLY_OFFSET_FILL_ENABLE"},
		{NV4097_SET_DEPTH_FUNC, "NV4097_SET_DEPTH_FUNC"},
		{NV4097_SET_DEPTH_MASK, "NV4097_SET_DEPTH_MASK"},
		{NV4097_SET_DEPTH_TEST_ENABLE, "NV4097_SET_DEPTH_TEST_ENABLE"},
		{NV4097_SET_POLYGON_OFFSET_SCALE_FACTOR, "NV4097_SET_POLYGON_OFFSET_SCALE_FACTOR"},
		{NV4097_SET_POLYGON_OFFSET_BIAS, "NV4097_SET_POLYGON_OFFSET_BIAS"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M, "NV4097_SET_VERTEX_DATA_SCALED4S_M"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 4 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 4"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 8 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 8"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 12 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 12"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 16 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 16"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 20 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 20"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 24 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 24"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 28 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 28"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 32 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 32"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 36 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 36"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 40 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 40"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 44 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 44"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 48 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 48"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 52 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 52"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 56 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 56"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 60 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 60"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 64 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 64"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 68 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 68"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 72 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 72"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 76 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 76"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 80 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 80"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 84 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 84"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 88 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 88"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 92 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 92"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 96 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 96"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 100 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 100"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 104 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 104"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 108 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 108"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 112 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 112"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 116 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 116"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 120 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 120"},
		{NV4097_SET_VERTEX_DATA_SCALED4S_M + 124 / 4, "NV4097_SET_VERTEX_DATA_SCALED4S_M + 124"},
		{NV4097_SET_TEXTURE_CONTROL2, "NV4097_SET_TEXTURE_CONTROL2"},
		{NV4097_SET_TEXTURE_CONTROL2 + 4 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 4"},
		{NV4097_SET_TEXTURE_CONTROL2 + 8 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 8"},
		{NV4097_SET_TEXTURE_CONTROL2 + 12 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 12"},
		{NV4097_SET_TEXTURE_CONTROL2 + 16 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 16"},
		{NV4097_SET_TEXTURE_CONTROL2 + 20 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 20"},
		{NV4097_SET_TEXTURE_CONTROL2 + 24 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 24"},
		{NV4097_SET_TEXTURE_CONTROL2 + 28 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 28"},
		{NV4097_SET_TEXTURE_CONTROL2 + 32 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 32"},
		{NV4097_SET_TEXTURE_CONTROL2 + 36 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 36"},
		{NV4097_SET_TEXTURE_CONTROL2 + 40 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 40"},
		{NV4097_SET_TEXTURE_CONTROL2 + 44 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 44"},
		{NV4097_SET_TEXTURE_CONTROL2 + 48 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 48"},
		{NV4097_SET_TEXTURE_CONTROL2 + 52 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 52"},
		{NV4097_SET_TEXTURE_CONTROL2 + 56 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 56"},
		{NV4097_SET_TEXTURE_CONTROL2 + 60 / 4, "NV4097_SET_TEXTURE_CONTROL2 + 60"},
		{NV4097_SET_TEX_COORD_CONTROL, "NV4097_SET_TEX_COORD_CONTROL"},
		{NV4097_SET_TEX_COORD_CONTROL + 4 / 4, "NV4097_SET_TEX_COORD_CONTROL + 4"},
		{NV4097_SET_TEX_COORD_CONTROL + 8 / 4, "NV4097_SET_TEX_COORD_CONTROL + 8"},
		{NV4097_SET_TEX_COORD_CONTROL + 12 / 4, "NV4097_SET_TEX_COORD_CONTROL + 12"},
		{NV4097_SET_TEX_COORD_CONTROL + 16 / 4, "NV4097_SET_TEX_COORD_CONTROL + 16"},
		{NV4097_SET_TEX_COORD_CONTROL + 20 / 4, "NV4097_SET_TEX_COORD_CONTROL + 20"},
		{NV4097_SET_TEX_COORD_CONTROL + 24 / 4, "NV4097_SET_TEX_COORD_CONTROL + 24"},
		{NV4097_SET_TEX_COORD_CONTROL + 28 / 4, "NV4097_SET_TEX_COORD_CONTROL + 28"},
		{NV4097_SET_TEX_COORD_CONTROL + 32 / 4, "NV4097_SET_TEX_COORD_CONTROL + 32"},
		{NV4097_SET_TEX_COORD_CONTROL + 36 / 4, "NV4097_SET_TEX_COORD_CONTROL + 36"},
		{NV4097_SET_TRANSFORM_PROGRAM, "NV4097_SET_TRANSFORM_PROGRAM"},
		{NV4097_SET_TRANSFORM_PROGRAM + 4 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 4"},
		{NV4097_SET_TRANSFORM_PROGRAM + 8 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 8"},
		{NV4097_SET_TRANSFORM_PROGRAM + 12 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 12"},
		{NV4097_SET_TRANSFORM_PROGRAM + 16 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 16"},
		{NV4097_SET_TRANSFORM_PROGRAM + 20 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 20"},
		{NV4097_SET_TRANSFORM_PROGRAM + 24 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 24"},
		{NV4097_SET_TRANSFORM_PROGRAM + 28 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 28"},
		{NV4097_SET_TRANSFORM_PROGRAM + 32 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 32"},
		{NV4097_SET_TRANSFORM_PROGRAM + 36 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 36"},
		{NV4097_SET_TRANSFORM_PROGRAM + 40 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 40"},
		{NV4097_SET_TRANSFORM_PROGRAM + 44 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 44"},
		{NV4097_SET_TRANSFORM_PROGRAM + 48 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 48"},
		{NV4097_SET_TRANSFORM_PROGRAM + 52 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 52"},
		{NV4097_SET_TRANSFORM_PROGRAM + 56 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 56"},
		{NV4097_SET_TRANSFORM_PROGRAM + 60 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 60"},
		{NV4097_SET_TRANSFORM_PROGRAM + 64 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 64"},
		{NV4097_SET_TRANSFORM_PROGRAM + 68 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 68"},
		{NV4097_SET_TRANSFORM_PROGRAM + 72 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 72"},
		{NV4097_SET_TRANSFORM_PROGRAM + 76 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 76"},
		{NV4097_SET_TRANSFORM_PROGRAM + 80 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 80"},
		{NV4097_SET_TRANSFORM_PROGRAM + 84 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 84"},
		{NV4097_SET_TRANSFORM_PROGRAM + 88 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 88"},
		{NV4097_SET_TRANSFORM_PROGRAM + 92 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 92"},
		{NV4097_SET_TRANSFORM_PROGRAM + 96 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 96"},
		{NV4097_SET_TRANSFORM_PROGRAM + 100 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 100"},
		{NV4097_SET_TRANSFORM_PROGRAM + 104 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 104"},
		{NV4097_SET_TRANSFORM_PROGRAM + 108 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 108"},
		{NV4097_SET_TRANSFORM_PROGRAM + 112 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 112"},
		{NV4097_SET_TRANSFORM_PROGRAM + 116 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 116"},
		{NV4097_SET_TRANSFORM_PROGRAM + 120 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 120"},
		{NV4097_SET_TRANSFORM_PROGRAM + 124 / 4, "NV4097_SET_TRANSFORM_PROGRAM + 124"},
		{NV4097_SET_SPECULAR_ENABLE, "NV4097_SET_SPECULAR_ENABLE"},
		{NV4097_SET_TWO_SIDE_LIGHT_EN, "NV4097_SET_TWO_SIDE_LIGHT_EN"},
		{NV4097_CLEAR_ZCULL_SURFACE, "NV4097_CLEAR_ZCULL_SURFACE"},
		{NV4097_SET_PERFORMANCE_PARAMS, "NV4097_SET_PERFORMANCE_PARAMS"},
		{NV4097_SET_FLAT_SHADE_OP, "NV4097_SET_FLAT_SHADE_OP"},
		{NV4097_SET_EDGE_FLAG, "NV4097_SET_EDGE_FLAG"},
		{NV4097_SET_USER_CLIP_PLANE_CONTROL, "NV4097_SET_USER_CLIP_PLANE_CONTROL"},
		{NV4097_SET_POLYGON_STIPPLE, "NV4097_SET_POLYGON_STIPPLE"},
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 1),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 2),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 3),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 4),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 5),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 6),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 7),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 8),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 9),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 10),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 11),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 12),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 13),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 14),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 15),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 16),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 17),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 18),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 19),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 20),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 21),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 22),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 23),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 24),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 25),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 26),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 28),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 29),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 30),
		KEY_STR(NV4097_SET_POLYGON_STIPPLE_PATTERN + 31),
		{NV4097_SET_VERTEX_DATA3F_M, "NV4097_SET_VERTEX_DATA3F_M"},
		{NV4097_SET_VERTEX_DATA3F_M + 4 / 4, "NV4097_SET_VERTEX_DATA3F_M + 4"},
		{NV4097_SET_VERTEX_DATA3F_M + 8 / 4, "NV4097_SET_VERTEX_DATA3F_M + 8"},
		{NV4097_SET_VERTEX_DATA3F_M + 12 / 4, "NV4097_SET_VERTEX_DATA3F_M + 12"},
		{NV4097_SET_VERTEX_DATA3F_M + 16 / 4, "NV4097_SET_VERTEX_DATA3F_M + 16"},
		{NV4097_SET_VERTEX_DATA3F_M + 20 / 4, "NV4097_SET_VERTEX_DATA3F_M + 20"},
		{NV4097_SET_VERTEX_DATA3F_M + 24 / 4, "NV4097_SET_VERTEX_DATA3F_M + 24"},
		{NV4097_SET_VERTEX_DATA3F_M + 28 / 4, "NV4097_SET_VERTEX_DATA3F_M + 28"},
		{NV4097_SET_VERTEX_DATA3F_M + 32 / 4, "NV4097_SET_VERTEX_DATA3F_M + 32"},
		{NV4097_SET_VERTEX_DATA3F_M + 36 / 4, "NV4097_SET_VERTEX_DATA3F_M + 36"},
		{NV4097_SET_VERTEX_DATA3F_M + 40 / 4, "NV4097_SET_VERTEX_DATA3F_M + 40"},
		{NV4097_SET_VERTEX_DATA3F_M + 44 / 4, "NV4097_SET_VERTEX_DATA3F_M + 44"},
		{NV4097_SET_VERTEX_DATA3F_M + 48 / 4, "NV4097_SET_VERTEX_DATA3F_M + 48"},
		{NV4097_SET_VERTEX_DATA3F_M + 52 / 4, "NV4097_SET_VERTEX_DATA3F_M + 52"},
		{NV4097_SET_VERTEX_DATA3F_M + 56 / 4, "NV4097_SET_VERTEX_DATA3F_M + 56"},
		{NV4097_SET_VERTEX_DATA3F_M + 60 / 4, "NV4097_SET_VERTEX_DATA3F_M + 60"},
		{NV4097_SET_VERTEX_DATA3F_M + 64 / 4, "NV4097_SET_VERTEX_DATA3F_M + 64"},
		{NV4097_SET_VERTEX_DATA3F_M + 68 / 4, "NV4097_SET_VERTEX_DATA3F_M + 68"},
		{NV4097_SET_VERTEX_DATA3F_M + 72 / 4, "NV4097_SET_VERTEX_DATA3F_M + 72"},
		{NV4097_SET_VERTEX_DATA3F_M + 76 / 4, "NV4097_SET_VERTEX_DATA3F_M + 76"},
		{NV4097_SET_VERTEX_DATA3F_M + 80 / 4, "NV4097_SET_VERTEX_DATA3F_M + 80"},
		{NV4097_SET_VERTEX_DATA3F_M + 84 / 4, "NV4097_SET_VERTEX_DATA3F_M + 84"},
		{NV4097_SET_VERTEX_DATA3F_M + 88 / 4, "NV4097_SET_VERTEX_DATA3F_M + 88"},
		{NV4097_SET_VERTEX_DATA3F_M + 92 / 4, "NV4097_SET_VERTEX_DATA3F_M + 92"},
		{NV4097_SET_VERTEX_DATA3F_M + 96 / 4, "NV4097_SET_VERTEX_DATA3F_M + 96"},
		{NV4097_SET_VERTEX_DATA3F_M + 100 / 4, "NV4097_SET_VERTEX_DATA3F_M + 100"},
		{NV4097_SET_VERTEX_DATA3F_M + 104 / 4, "NV4097_SET_VERTEX_DATA3F_M + 104"},
		{NV4097_SET_VERTEX_DATA3F_M + 108 / 4, "NV4097_SET_VERTEX_DATA3F_M + 108"},
		{NV4097_SET_VERTEX_DATA3F_M + 112 / 4, "NV4097_SET_VERTEX_DATA3F_M + 112"},
		{NV4097_SET_VERTEX_DATA3F_M + 116 / 4, "NV4097_SET_VERTEX_DATA3F_M + 116"},
		{NV4097_SET_VERTEX_DATA3F_M + 120 / 4, "NV4097_SET_VERTEX_DATA3F_M + 120"},
		{NV4097_SET_VERTEX_DATA3F_M + 124 / 4, "NV4097_SET_VERTEX_DATA3F_M + 124"},
		{NV4097_SET_VERTEX_DATA3F_M + 128 / 4, "NV4097_SET_VERTEX_DATA3F_M + 128"},
		{NV4097_SET_VERTEX_DATA3F_M + 132 / 4, "NV4097_SET_VERTEX_DATA3F_M + 132"},
		{NV4097_SET_VERTEX_DATA3F_M + 136 / 4, "NV4097_SET_VERTEX_DATA3F_M + 136"},
		{NV4097_SET_VERTEX_DATA3F_M + 140 / 4, "NV4097_SET_VERTEX_DATA3F_M + 140"},
		{NV4097_SET_VERTEX_DATA3F_M + 144 / 4, "NV4097_SET_VERTEX_DATA3F_M + 144"},
		{NV4097_SET_VERTEX_DATA3F_M + 148 / 4, "NV4097_SET_VERTEX_DATA3F_M + 148"},
		{NV4097_SET_VERTEX_DATA3F_M + 152 / 4, "NV4097_SET_VERTEX_DATA3F_M + 152"},
		{NV4097_SET_VERTEX_DATA3F_M + 156 / 4, "NV4097_SET_VERTEX_DATA3F_M + 156"},
		{NV4097_SET_VERTEX_DATA3F_M + 160 / 4, "NV4097_SET_VERTEX_DATA3F_M + 160"},
		{NV4097_SET_VERTEX_DATA3F_M + 164 / 4, "NV4097_SET_VERTEX_DATA3F_M + 164"},
		{NV4097_SET_VERTEX_DATA3F_M + 168 / 4, "NV4097_SET_VERTEX_DATA3F_M + 168"},
		{NV4097_SET_VERTEX_DATA3F_M + 172 / 4, "NV4097_SET_VERTEX_DATA3F_M + 172"},
		{NV4097_SET_VERTEX_DATA3F_M + 176 / 4, "NV4097_SET_VERTEX_DATA3F_M + 176"},
		{NV4097_SET_VERTEX_DATA3F_M + 180 / 4, "NV4097_SET_VERTEX_DATA3F_M + 180"},
		{NV4097_SET_VERTEX_DATA3F_M + 184 / 4, "NV4097_SET_VERTEX_DATA3F_M + 184"},
		{NV4097_SET_VERTEX_DATA3F_M + 188 / 4, "NV4097_SET_VERTEX_DATA3F_M + 188"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 4 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 4"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 8 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 8"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 12 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 12"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 16 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 16"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 20 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 20"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 24 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 24"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 28 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 28"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 32 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 32"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 36 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 36"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 40 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 40"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 44 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 44"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 48 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 48"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 52 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 52"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 56 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 56"},
		{NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 60 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_OFFSET + 60"},
		{NV4097_INVALIDATE_VERTEX_CACHE_FILE, "NV4097_INVALIDATE_VERTEX_CACHE_FILE"},
		{NV4097_INVALIDATE_VERTEX_FILE, "NV4097_INVALIDATE_VERTEX_FILE"},
		{NV4097_PIPE_NOP, "NV4097_PIPE_NOP"},
		{NV4097_SET_VERTEX_DATA_BASE_OFFSET, "NV4097_SET_VERTEX_DATA_BASE_OFFSET"},
		{NV4097_SET_VERTEX_DATA_BASE_INDEX, "NV4097_SET_VERTEX_DATA_BASE_INDEX"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 4 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 4"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 8 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 8"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 12 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 12"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 16 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 16"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 20 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 20"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 24 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 24"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 28 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 28"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 32 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 32"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 36 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 36"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 40 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 40"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 44 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 44"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 48 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 48"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 52 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 52"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 56 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 56"},
		{NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 60 / 4, "NV4097_SET_VERTEX_DATA_ARRAY_FORMAT + 60"},
		{NV4097_CLEAR_REPORT_VALUE, "NV4097_CLEAR_REPORT_VALUE"},
		{NV4097_SET_ZPASS_PIXEL_COUNT_ENABLE, "NV4097_SET_ZPASS_PIXEL_COUNT_ENABLE"},
		{NV4097_GET_REPORT, "NV4097_GET_REPORT"},
		{NV4097_SET_ZCULL_STATS_ENABLE, "NV4097_SET_ZCULL_STATS_ENABLE"},
		{NV4097_SET_BEGIN_END, "NV4097_SET_BEGIN_END"},
		{NV4097_ARRAY_ELEMENT16, "NV4097_ARRAY_ELEMENT16"},
		{NV4097_ARRAY_ELEMENT32, "NV4097_ARRAY_ELEMENT32"},
		{NV4097_DRAW_ARRAYS, "NV4097_DRAW_ARRAYS"},
		{NV4097_INLINE_ARRAY, "NV4097_INLINE_ARRAY"},
		{NV4097_SET_INDEX_ARRAY_ADDRESS, "NV4097_SET_INDEX_ARRAY_ADDRESS"},
		{NV4097_SET_INDEX_ARRAY_DMA, "NV4097_SET_INDEX_ARRAY_DMA"},
		{NV4097_DRAW_INDEX_ARRAY, "NV4097_DRAW_INDEX_ARRAY"},
		{NV4097_SET_FRONT_POLYGON_MODE, "NV4097_SET_FRONT_POLYGON_MODE"},
		{NV4097_SET_BACK_POLYGON_MODE, "NV4097_SET_BACK_POLYGON_MODE"},
		{NV4097_SET_CULL_FACE, "NV4097_SET_CULL_FACE"},
		{NV4097_SET_FRONT_FACE, "NV4097_SET_FRONT_FACE"},
		{NV4097_SET_POLY_SMOOTH_ENABLE, "NV4097_SET_POLY_SMOOTH_ENABLE"},
		{NV4097_SET_CULL_FACE_ENABLE, "NV4097_SET_CULL_FACE_ENABLE"},
		{NV4097_SET_TEXTURE_CONTROL3, "NV4097_SET_TEXTURE_CONTROL3"},
		{NV4097_SET_TEXTURE_CONTROL3 + 4 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 4"},
		{NV4097_SET_TEXTURE_CONTROL3 + 8 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 8"},
		{NV4097_SET_TEXTURE_CONTROL3 + 12 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 12"},
		{NV4097_SET_TEXTURE_CONTROL3 + 16 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 16"},
		{NV4097_SET_TEXTURE_CONTROL3 + 20 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 20"},
		{NV4097_SET_TEXTURE_CONTROL3 + 24 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 24"},
		{NV4097_SET_TEXTURE_CONTROL3 + 28 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 28"},
		{NV4097_SET_TEXTURE_CONTROL3 + 32 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 32"},
		{NV4097_SET_TEXTURE_CONTROL3 + 36 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 36"},
		{NV4097_SET_TEXTURE_CONTROL3 + 40 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 40"},
		{NV4097_SET_TEXTURE_CONTROL3 + 44 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 44"},
		{NV4097_SET_TEXTURE_CONTROL3 + 48 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 48"},
		{NV4097_SET_TEXTURE_CONTROL3 + 52 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 52"},
		{NV4097_SET_TEXTURE_CONTROL3 + 56 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 56"},
		{NV4097_SET_TEXTURE_CONTROL3 + 60 / 4, "NV4097_SET_TEXTURE_CONTROL3 + 60"},
		{NV4097_SET_VERTEX_DATA2F_M, "NV4097_SET_VERTEX_DATA2F_M"},
		{NV4097_SET_VERTEX_DATA2F_M + 4 / 4, "NV4097_SET_VERTEX_DATA2F_M + 4"},
		{NV4097_SET_VERTEX_DATA2F_M + 8 / 4, "NV4097_SET_VERTEX_DATA2F_M + 8"},
		{NV4097_SET_VERTEX_DATA2F_M + 12 / 4, "NV4097_SET_VERTEX_DATA2F_M + 12"},
		{NV4097_SET_VERTEX_DATA2F_M + 16 / 4, "NV4097_SET_VERTEX_DATA2F_M + 16"},
		{NV4097_SET_VERTEX_DATA2F_M + 20 / 4, "NV4097_SET_VERTEX_DATA2F_M + 20"},
		{NV4097_SET_VERTEX_DATA2F_M + 24 / 4, "NV4097_SET_VERTEX_DATA2F_M + 24"},
		{NV4097_SET_VERTEX_DATA2F_M + 28 / 4, "NV4097_SET_VERTEX_DATA2F_M + 28"},
		{NV4097_SET_VERTEX_DATA2F_M + 32 / 4, "NV4097_SET_VERTEX_DATA2F_M + 32"},
		{NV4097_SET_VERTEX_DATA2F_M + 36 / 4, "NV4097_SET_VERTEX_DATA2F_M + 36"},
		{NV4097_SET_VERTEX_DATA2F_M + 40 / 4, "NV4097_SET_VERTEX_DATA2F_M + 40"},
		{NV4097_SET_VERTEX_DATA2F_M + 44 / 4, "NV4097_SET_VERTEX_DATA2F_M + 44"},
		{NV4097_SET_VERTEX_DATA2F_M + 48 / 4, "NV4097_SET_VERTEX_DATA2F_M + 48"},
		{NV4097_SET_VERTEX_DATA2F_M + 52 / 4, "NV4097_SET_VERTEX_DATA2F_M + 52"},
		{NV4097_SET_VERTEX_DATA2F_M + 56 / 4, "NV4097_SET_VERTEX_DATA2F_M + 56"},
		{NV4097_SET_VERTEX_DATA2F_M + 60 / 4, "NV4097_SET_VERTEX_DATA2F_M + 60"},
		{NV4097_SET_VERTEX_DATA2F_M + 64 / 4, "NV4097_SET_VERTEX_DATA2F_M + 64"},
		{NV4097_SET_VERTEX_DATA2F_M + 68 / 4, "NV4097_SET_VERTEX_DATA2F_M + 68"},
		{NV4097_SET_VERTEX_DATA2F_M + 72 / 4, "NV4097_SET_VERTEX_DATA2F_M + 72"},
		{NV4097_SET_VERTEX_DATA2F_M + 76 / 4, "NV4097_SET_VERTEX_DATA2F_M + 76"},
		{NV4097_SET_VERTEX_DATA2F_M + 80 / 4, "NV4097_SET_VERTEX_DATA2F_M + 80"},
		{NV4097_SET_VERTEX_DATA2F_M + 84 / 4, "NV4097_SET_VERTEX_DATA2F_M + 84"},
		{NV4097_SET_VERTEX_DATA2F_M + 88 / 4, "NV4097_SET_VERTEX_DATA2F_M + 88"},
		{NV4097_SET_VERTEX_DATA2F_M + 92 / 4, "NV4097_SET_VERTEX_DATA2F_M + 92"},
		{NV4097_SET_VERTEX_DATA2F_M + 96 / 4, "NV4097_SET_VERTEX_DATA2F_M + 96"},
		{NV4097_SET_VERTEX_DATA2F_M + 100 / 4, "NV4097_SET_VERTEX_DATA2F_M + 100"},
		{NV4097_SET_VERTEX_DATA2F_M + 104 / 4, "NV4097_SET_VERTEX_DATA2F_M + 104"},
		{NV4097_SET_VERTEX_DATA2F_M + 108 / 4, "NV4097_SET_VERTEX_DATA2F_M + 108"},
		{NV4097_SET_VERTEX_DATA2F_M + 112 / 4, "NV4097_SET_VERTEX_DATA2F_M + 112"},
		{NV4097_SET_VERTEX_DATA2F_M + 116 / 4, "NV4097_SET_VERTEX_DATA2F_M + 116"},
		{NV4097_SET_VERTEX_DATA2F_M + 120 / 4, "NV4097_SET_VERTEX_DATA2F_M + 120"},
		{NV4097_SET_VERTEX_DATA2F_M + 124 / 4, "NV4097_SET_VERTEX_DATA2F_M + 124"},
		{NV4097_SET_VERTEX_DATA2S_M, "NV4097_SET_VERTEX_DATA2S_M"},
		{NV4097_SET_VERTEX_DATA2S_M + 4 / 4, "NV4097_SET_VERTEX_DATA2S_M + 4"},
		{NV4097_SET_VERTEX_DATA2S_M + 8 / 4, "NV4097_SET_VERTEX_DATA2S_M + 8"},
		{NV4097_SET_VERTEX_DATA2S_M + 12 / 4, "NV4097_SET_VERTEX_DATA2S_M + 12"},
		{NV4097_SET_VERTEX_DATA2S_M + 16 / 4, "NV4097_SET_VERTEX_DATA2S_M + 16"},
		{NV4097_SET_VERTEX_DATA2S_M + 20 / 4, "NV4097_SET_VERTEX_DATA2S_M + 20"},
		{NV4097_SET_VERTEX_DATA2S_M + 24 / 4, "NV4097_SET_VERTEX_DATA2S_M + 24"},
		{NV4097_SET_VERTEX_DATA2S_M + 28 / 4, "NV4097_SET_VERTEX_DATA2S_M + 28"},
		{NV4097_SET_VERTEX_DATA2S_M + 32 / 4, "NV4097_SET_VERTEX_DATA2S_M + 32"},
		{NV4097_SET_VERTEX_DATA2S_M + 36 / 4, "NV4097_SET_VERTEX_DATA2S_M + 36"},
		{NV4097_SET_VERTEX_DATA2S_M + 40 / 4, "NV4097_SET_VERTEX_DATA2S_M + 40"},
		{NV4097_SET_VERTEX_DATA2S_M + 44 / 4, "NV4097_SET_VERTEX_DATA2S_M + 44"},
		{NV4097_SET_VERTEX_DATA2S_M + 48 / 4, "NV4097_SET_VERTEX_DATA2S_M + 48"},
		{NV4097_SET_VERTEX_DATA2S_M + 52 / 4, "NV4097_SET_VERTEX_DATA2S_M + 52"},
		{NV4097_SET_VERTEX_DATA2S_M + 56 / 4, "NV4097_SET_VERTEX_DATA2S_M + 56"},
		{NV4097_SET_VERTEX_DATA2S_M + 60 / 4, "NV4097_SET_VERTEX_DATA2S_M + 60"},
		{NV4097_SET_VERTEX_DATA4UB_M, "NV4097_SET_VERTEX_DATA4UB_M"},
		{NV4097_SET_VERTEX_DATA4UB_M + 4 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 4"},
		{NV4097_SET_VERTEX_DATA4UB_M + 8 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 8"},
		{NV4097_SET_VERTEX_DATA4UB_M + 12 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 12"},
		{NV4097_SET_VERTEX_DATA4UB_M + 16 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 16"},
		{NV4097_SET_VERTEX_DATA4UB_M + 20 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 20"},
		{NV4097_SET_VERTEX_DATA4UB_M + 24 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 24"},
		{NV4097_SET_VERTEX_DATA4UB_M + 28 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 28"},
		{NV4097_SET_VERTEX_DATA4UB_M + 32 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 32"},
		{NV4097_SET_VERTEX_DATA4UB_M + 36 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 36"},
		{NV4097_SET_VERTEX_DATA4UB_M + 40 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 40"},
		{NV4097_SET_VERTEX_DATA4UB_M + 44 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 44"},
		{NV4097_SET_VERTEX_DATA4UB_M + 48 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 48"},
		{NV4097_SET_VERTEX_DATA4UB_M + 52 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 52"},
		{NV4097_SET_VERTEX_DATA4UB_M + 56 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 56"},
		{NV4097_SET_VERTEX_DATA4UB_M + 60 / 4, "NV4097_SET_VERTEX_DATA4UB_M + 60"},
		{NV4097_SET_VERTEX_DATA4S_M, "NV4097_SET_VERTEX_DATA4S_M"},
		{NV4097_SET_VERTEX_DATA4S_M + 4 / 4, "NV4097_SET_VERTEX_DATA4S_M + 4"},
		{NV4097_SET_VERTEX_DATA4S_M + 8 / 4, "NV4097_SET_VERTEX_DATA4S_M + 8"},
		{NV4097_SET_VERTEX_DATA4S_M + 12 / 4, "NV4097_SET_VERTEX_DATA4S_M + 12"},
		{NV4097_SET_VERTEX_DATA4S_M + 16 / 4, "NV4097_SET_VERTEX_DATA4S_M + 16"},
		{NV4097_SET_VERTEX_DATA4S_M + 20 / 4, "NV4097_SET_VERTEX_DATA4S_M + 20"},
		{NV4097_SET_VERTEX_DATA4S_M + 24 / 4, "NV4097_SET_VERTEX_DATA4S_M + 24"},
		{NV4097_SET_VERTEX_DATA4S_M + 28 / 4, "NV4097_SET_VERTEX_DATA4S_M + 28"},
		{NV4097_SET_VERTEX_DATA4S_M + 32 / 4, "NV4097_SET_VERTEX_DATA4S_M + 32"},
		{NV4097_SET_VERTEX_DATA4S_M + 36 / 4, "NV4097_SET_VERTEX_DATA4S_M + 36"},
		{NV4097_SET_VERTEX_DATA4S_M + 40 / 4, "NV4097_SET_VERTEX_DATA4S_M + 40"},
		{NV4097_SET_VERTEX_DATA4S_M + 44 / 4, "NV4097_SET_VERTEX_DATA4S_M + 44"},
		{NV4097_SET_VERTEX_DATA4S_M + 48 / 4, "NV4097_SET_VERTEX_DATA4S_M + 48"},
		{NV4097_SET_VERTEX_DATA4S_M + 52 / 4, "NV4097_SET_VERTEX_DATA4S_M + 52"},
		{NV4097_SET_VERTEX_DATA4S_M + 56 / 4, "NV4097_SET_VERTEX_DATA4S_M + 56"},
		{NV4097_SET_VERTEX_DATA4S_M + 60 / 4, "NV4097_SET_VERTEX_DATA4S_M + 60"},
		{NV4097_SET_VERTEX_DATA4S_M + 64 / 4, "NV4097_SET_VERTEX_DATA4S_M + 64"},
		{NV4097_SET_VERTEX_DATA4S_M + 68 / 4, "NV4097_SET_VERTEX_DATA4S_M + 68"},
		{NV4097_SET_VERTEX_DATA4S_M + 72 / 4, "NV4097_SET_VERTEX_DATA4S_M + 72"},
		{NV4097_SET_VERTEX_DATA4S_M + 76 / 4, "NV4097_SET_VERTEX_DATA4S_M + 76"},
		{NV4097_SET_VERTEX_DATA4S_M + 80 / 4, "NV4097_SET_VERTEX_DATA4S_M + 80"},
		{NV4097_SET_VERTEX_DATA4S_M + 84 / 4, "NV4097_SET_VERTEX_DATA4S_M + 84"},
		{NV4097_SET_VERTEX_DATA4S_M + 88 / 4, "NV4097_SET_VERTEX_DATA4S_M + 88"},
		{NV4097_SET_VERTEX_DATA4S_M + 92 / 4, "NV4097_SET_VERTEX_DATA4S_M + 92"},
		{NV4097_SET_VERTEX_DATA4S_M + 96 / 4, "NV4097_SET_VERTEX_DATA4S_M + 96"},
		{NV4097_SET_VERTEX_DATA4S_M + 100 / 4, "NV4097_SET_VERTEX_DATA4S_M + 100"},
		{NV4097_SET_VERTEX_DATA4S_M + 104 / 4, "NV4097_SET_VERTEX_DATA4S_M + 104"},
		{NV4097_SET_VERTEX_DATA4S_M + 108 / 4, "NV4097_SET_VERTEX_DATA4S_M + 108"},
		{NV4097_SET_VERTEX_DATA4S_M + 112 / 4, "NV4097_SET_VERTEX_DATA4S_M + 112"},
		{NV4097_SET_VERTEX_DATA4S_M + 116 / 4, "NV4097_SET_VERTEX_DATA4S_M + 116"},
		{NV4097_SET_VERTEX_DATA4S_M + 120 / 4, "NV4097_SET_VERTEX_DATA4S_M + 120"},
		{NV4097_SET_VERTEX_DATA4S_M + 124 / 4, "NV4097_SET_VERTEX_DATA4S_M + 124"},
		{NV4097_SET_TEXTURE_OFFSET, "NV4097_SET_TEXTURE_OFFSET"},
		{NV4097_SET_TEXTURE_FORMAT, "NV4097_SET_TEXTURE_FORMAT"},
		{NV4097_SET_TEXTURE_ADDRESS, "NV4097_SET_TEXTURE_ADDRESS"},
		{NV4097_SET_TEXTURE_CONTROL0, "NV4097_SET_TEXTURE_CONTROL0"},
		{NV4097_SET_TEXTURE_CONTROL1, "NV4097_SET_TEXTURE_CONTROL1"},
		{NV4097_SET_TEXTURE_FILTER, "NV4097_SET_TEXTURE_FILTER"},
		{NV4097_SET_TEXTURE_IMAGE_RECT, "NV4097_SET_TEXTURE_IMAGE_RECT"},
		{NV4097_SET_TEXTURE_BORDER_COLOR, "NV4097_SET_TEXTURE_BORDER_COLOR"},
		{NV4097_SET_TEXTURE_OFFSET + 0x20 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x20"},
		{NV4097_SET_TEXTURE_FORMAT + 0x20 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x20"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x20 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x20"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x20 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x20"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x20 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x20"},
		{NV4097_SET_TEXTURE_FILTER + 0x20 / 4, "NV4097_SET_TEXTURE_FILTER + 0x20"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x20 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x20"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x20 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x20"},
		{NV4097_SET_TEXTURE_OFFSET + 0x40 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x40"},
		{NV4097_SET_TEXTURE_FORMAT + 0x40 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x40"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x40 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x40"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x40 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x40"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x40 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x40"},
		{NV4097_SET_TEXTURE_FILTER + 0x40 / 4, "NV4097_SET_TEXTURE_FILTER + 0x40"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x40 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x40"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x40 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x40"},
		{NV4097_SET_TEXTURE_OFFSET + 0x60 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x60"},
		{NV4097_SET_TEXTURE_FORMAT + 0x60 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x60"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x60 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x60"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x60 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x60"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x60 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x60"},
		{NV4097_SET_TEXTURE_FILTER + 0x60 / 4, "NV4097_SET_TEXTURE_FILTER + 0x60"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x60 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x60"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x60 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x60"},
		{NV4097_SET_TEXTURE_OFFSET + 0x80 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x80"},
		{NV4097_SET_TEXTURE_FORMAT + 0x80 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x80"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x80 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x80"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x80 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x80"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x80 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x80"},
		{NV4097_SET_TEXTURE_FILTER + 0x80 / 4, "NV4097_SET_TEXTURE_FILTER + 0x80"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x80 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x80"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x80 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x80"},
		{NV4097_SET_TEXTURE_OFFSET + 0xa0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0xa0"},
		{NV4097_SET_TEXTURE_FORMAT + 0xa0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0xa0"},
		{NV4097_SET_TEXTURE_ADDRESS + 0xa0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0xa0"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0xa0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0xa0"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0xa0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0xa0"},
		{NV4097_SET_TEXTURE_FILTER + 0xa0 / 4, "NV4097_SET_TEXTURE_FILTER + 0xa0"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0xa0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0xa0"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0xa0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0xa0"},
		{NV4097_SET_TEXTURE_OFFSET + 0xc0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0xc0"},
		{NV4097_SET_TEXTURE_FORMAT + 0xc0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0xc0"},
		{NV4097_SET_TEXTURE_ADDRESS + 0xc0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0xc0"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0xc0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0xc0"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0xc0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0xc0"},
		{NV4097_SET_TEXTURE_FILTER + 0xc0 / 4, "NV4097_SET_TEXTURE_FILTER + 0xc0"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0xc0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0xc0"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0xc0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0xc0"},
		{NV4097_SET_TEXTURE_OFFSET + 0xe0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0xe0"},
		{NV4097_SET_TEXTURE_FORMAT + 0xe0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0xe0"},
		{NV4097_SET_TEXTURE_ADDRESS + 0xe0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0xe0"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0xe0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0xe0"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0xe0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0xe0"},
		{NV4097_SET_TEXTURE_FILTER + 0xe0 / 4, "NV4097_SET_TEXTURE_FILTER + 0xe0"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0xe0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0xe0"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0xe0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0xe0"},
		{NV4097_SET_TEXTURE_OFFSET + 0x100 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x100"},
		{NV4097_SET_TEXTURE_FORMAT + 0x100 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x100"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x100 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x100"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x100 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x100"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x100 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x100"},
		{NV4097_SET_TEXTURE_FILTER + 0x100 / 4, "NV4097_SET_TEXTURE_FILTER + 0x100"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x100 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x100"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x100 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x100"},
		{NV4097_SET_TEXTURE_OFFSET + 0x120 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x120"},
		{NV4097_SET_TEXTURE_FORMAT + 0x120 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x120"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x120 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x120"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x120 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x120"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x120 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x120"},
		{NV4097_SET_TEXTURE_FILTER + 0x120 / 4, "NV4097_SET_TEXTURE_FILTER + 0x120"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x120 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x120"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x120 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x120"},
		{NV4097_SET_TEXTURE_OFFSET + 0x140 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x140"},
		{NV4097_SET_TEXTURE_FORMAT + 0x140 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x140"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x140 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x140"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x140 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x140"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x140 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x140"},
		{NV4097_SET_TEXTURE_FILTER + 0x140 / 4, "NV4097_SET_TEXTURE_FILTER + 0x140"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x140 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x140"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x140 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x140"},
		{NV4097_SET_TEXTURE_OFFSET + 0x160 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x160"},
		{NV4097_SET_TEXTURE_FORMAT + 0x160 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x160"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x160 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x160"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x160 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x160"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x160 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x160"},
		{NV4097_SET_TEXTURE_FILTER + 0x160 / 4, "NV4097_SET_TEXTURE_FILTER + 0x160"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x160 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x160"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x160 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x160"},
		{NV4097_SET_TEXTURE_OFFSET + 0x180 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x180"},
		{NV4097_SET_TEXTURE_FORMAT + 0x180 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x180"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x180 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x180"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x180 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x180"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x180 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x180"},
		{NV4097_SET_TEXTURE_FILTER + 0x180 / 4, "NV4097_SET_TEXTURE_FILTER + 0x180"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x180 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x180"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x180 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x180"},
		{NV4097_SET_TEXTURE_OFFSET + 0x1a0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x1a0"},
		{NV4097_SET_TEXTURE_FORMAT + 0x1a0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x1a0"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x1a0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x1a0"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x1a0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x1a0"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x1a0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x1a0"},
		{NV4097_SET_TEXTURE_FILTER + 0x1a0 / 4, "NV4097_SET_TEXTURE_FILTER + 0x1a0"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x1a0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x1a0"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x1a0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x1a0"},
		{NV4097_SET_TEXTURE_OFFSET + 0x1c0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x1c0"},
		{NV4097_SET_TEXTURE_FORMAT + 0x1c0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x1c0"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x1c0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x1c0"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x1c0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x1c0"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x1c0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x1c0"},
		{NV4097_SET_TEXTURE_FILTER + 0x1c0 / 4, "NV4097_SET_TEXTURE_FILTER + 0x1c0"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x1c0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x1c0"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x1c0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x1c0"},
		{NV4097_SET_TEXTURE_OFFSET + 0x1e0 / 4, "NV4097_SET_TEXTURE_OFFSET + 0x1e0"},
		{NV4097_SET_TEXTURE_FORMAT + 0x1e0 / 4, "NV4097_SET_TEXTURE_FORMAT + 0x1e0"},
		{NV4097_SET_TEXTURE_ADDRESS + 0x1e0 / 4, "NV4097_SET_TEXTURE_ADDRESS + 0x1e0"},
		{NV4097_SET_TEXTURE_CONTROL0 + 0x1e0 / 4, "NV4097_SET_TEXTURE_CONTROL0 + 0x1e0"},
		{NV4097_SET_TEXTURE_CONTROL1 + 0x1e0 / 4, "NV4097_SET_TEXTURE_CONTROL1 + 0x1e0"},
		{NV4097_SET_TEXTURE_FILTER + 0x1e0 / 4, "NV4097_SET_TEXTURE_FILTER + 0x1e0"},
		{NV4097_SET_TEXTURE_IMAGE_RECT + 0x1e0 / 4, "NV4097_SET_TEXTURE_IMAGE_RECT + 0x1e0"},
		{NV4097_SET_TEXTURE_BORDER_COLOR + 0x1e0 / 4, "NV4097_SET_TEXTURE_BORDER_COLOR + 0x1e0"},
		{NV4097_SET_VERTEX_DATA4F_M, "NV4097_SET_VERTEX_DATA4F_M"},
		{NV4097_SET_VERTEX_DATA4F_M + 4 / 4, "NV4097_SET_VERTEX_DATA4F_M + 4"},
		{NV4097_SET_VERTEX_DATA4F_M + 8 / 4, "NV4097_SET_VERTEX_DATA4F_M + 8"},
		{NV4097_SET_VERTEX_DATA4F_M + 12 / 4, "NV4097_SET_VERTEX_DATA4F_M + 12"},
		{NV4097_SET_VERTEX_DATA4F_M + 16 / 4, "NV4097_SET_VERTEX_DATA4F_M + 16"},
		{NV4097_SET_VERTEX_DATA4F_M + 20 / 4, "NV4097_SET_VERTEX_DATA4F_M + 20"},
		{NV4097_SET_VERTEX_DATA4F_M + 24 / 4, "NV4097_SET_VERTEX_DATA4F_M + 24"},
		{NV4097_SET_VERTEX_DATA4F_M + 28 / 4, "NV4097_SET_VERTEX_DATA4F_M + 28"},
		{NV4097_SET_VERTEX_DATA4F_M + 32 / 4, "NV4097_SET_VERTEX_DATA4F_M + 32"},
		{NV4097_SET_VERTEX_DATA4F_M + 36 / 4, "NV4097_SET_VERTEX_DATA4F_M + 36"},
		{NV4097_SET_VERTEX_DATA4F_M + 40 / 4, "NV4097_SET_VERTEX_DATA4F_M + 40"},
		{NV4097_SET_VERTEX_DATA4F_M + 44 / 4, "NV4097_SET_VERTEX_DATA4F_M + 44"},
		{NV4097_SET_VERTEX_DATA4F_M + 48 / 4, "NV4097_SET_VERTEX_DATA4F_M + 48"},
		{NV4097_SET_VERTEX_DATA4F_M + 52 / 4, "NV4097_SET_VERTEX_DATA4F_M + 52"},
		{NV4097_SET_VERTEX_DATA4F_M + 56 / 4, "NV4097_SET_VERTEX_DATA4F_M + 56"},
		{NV4097_SET_VERTEX_DATA4F_M + 60 / 4, "NV4097_SET_VERTEX_DATA4F_M + 60"},
		{NV4097_SET_VERTEX_DATA4F_M + 64 / 4, "NV4097_SET_VERTEX_DATA4F_M + 64"},
		{NV4097_SET_VERTEX_DATA4F_M + 68 / 4, "NV4097_SET_VERTEX_DATA4F_M + 68"},
		{NV4097_SET_VERTEX_DATA4F_M + 72 / 4, "NV4097_SET_VERTEX_DATA4F_M + 72"},
		{NV4097_SET_VERTEX_DATA4F_M + 76 / 4, "NV4097_SET_VERTEX_DATA4F_M + 76"},
		{NV4097_SET_VERTEX_DATA4F_M + 80 / 4, "NV4097_SET_VERTEX_DATA4F_M + 80"},
		{NV4097_SET_VERTEX_DATA4F_M + 84 / 4, "NV4097_SET_VERTEX_DATA4F_M + 84"},
		{NV4097_SET_VERTEX_DATA4F_M + 88 / 4, "NV4097_SET_VERTEX_DATA4F_M + 88"},
		{NV4097_SET_VERTEX_DATA4F_M + 92 / 4, "NV4097_SET_VERTEX_DATA4F_M + 92"},
		{NV4097_SET_VERTEX_DATA4F_M + 96 / 4, "NV4097_SET_VERTEX_DATA4F_M + 96"},
		{NV4097_SET_VERTEX_DATA4F_M + 100 / 4, "NV4097_SET_VERTEX_DATA4F_M + 100"},
		{NV4097_SET_VERTEX_DATA4F_M + 104 / 4, "NV4097_SET_VERTEX_DATA4F_M + 104"},
		{NV4097_SET_VERTEX_DATA4F_M + 108 / 4, "NV4097_SET_VERTEX_DATA4F_M + 108"},
		{NV4097_SET_VERTEX_DATA4F_M + 112 / 4, "NV4097_SET_VERTEX_DATA4F_M + 112"},
		{NV4097_SET_VERTEX_DATA4F_M + 116 / 4, "NV4097_SET_VERTEX_DATA4F_M + 116"},
		{NV4097_SET_VERTEX_DATA4F_M + 120 / 4, "NV4097_SET_VERTEX_DATA4F_M + 120"},
		{NV4097_SET_VERTEX_DATA4F_M + 124 / 4, "NV4097_SET_VERTEX_DATA4F_M + 124"},
		{NV4097_SET_VERTEX_DATA4F_M + 128 / 4, "NV4097_SET_VERTEX_DATA4F_M + 128"},
		{NV4097_SET_VERTEX_DATA4F_M + 132 / 4, "NV4097_SET_VERTEX_DATA4F_M + 132"},
		{NV4097_SET_VERTEX_DATA4F_M + 136 / 4, "NV4097_SET_VERTEX_DATA4F_M + 136"},
		{NV4097_SET_VERTEX_DATA4F_M + 140 / 4, "NV4097_SET_VERTEX_DATA4F_M + 140"},
		{NV4097_SET_VERTEX_DATA4F_M + 144 / 4, "NV4097_SET_VERTEX_DATA4F_M + 144"},
		{NV4097_SET_VERTEX_DATA4F_M + 148 / 4, "NV4097_SET_VERTEX_DATA4F_M + 148"},
		{NV4097_SET_VERTEX_DATA4F_M + 152 / 4, "NV4097_SET_VERTEX_DATA4F_M + 152"},
		{NV4097_SET_VERTEX_DATA4F_M + 156 / 4, "NV4097_SET_VERTEX_DATA4F_M + 156"},
		{NV4097_SET_VERTEX_DATA4F_M + 160 / 4, "NV4097_SET_VERTEX_DATA4F_M + 160"},
		{NV4097_SET_VERTEX_DATA4F_M + 164 / 4, "NV4097_SET_VERTEX_DATA4F_M + 164"},
		{NV4097_SET_VERTEX_DATA4F_M + 168 / 4, "NV4097_SET_VERTEX_DATA4F_M + 168"},
		{NV4097_SET_VERTEX_DATA4F_M + 172 / 4, "NV4097_SET_VERTEX_DATA4F_M + 172"},
		{NV4097_SET_VERTEX_DATA4F_M + 176 / 4, "NV4097_SET_VERTEX_DATA4F_M + 176"},
		{NV4097_SET_VERTEX_DATA4F_M + 180 / 4, "NV4097_SET_VERTEX_DATA4F_M + 180"},
		{NV4097_SET_VERTEX_DATA4F_M + 184 / 4, "NV4097_SET_VERTEX_DATA4F_M + 184"},
		{NV4097_SET_VERTEX_DATA4F_M + 188 / 4, "NV4097_SET_VERTEX_DATA4F_M + 188"},
		{NV4097_SET_VERTEX_DATA4F_M + 192 / 4, "NV4097_SET_VERTEX_DATA4F_M + 192"},
		{NV4097_SET_VERTEX_DATA4F_M + 196 / 4, "NV4097_SET_VERTEX_DATA4F_M + 196"},
		{NV4097_SET_VERTEX_DATA4F_M + 200 / 4, "NV4097_SET_VERTEX_DATA4F_M + 200"},
		{NV4097_SET_VERTEX_DATA4F_M + 204 / 4, "NV4097_SET_VERTEX_DATA4F_M + 204"},
		{NV4097_SET_VERTEX_DATA4F_M + 208 / 4, "NV4097_SET_VERTEX_DATA4F_M + 208"},
		{NV4097_SET_VERTEX_DATA4F_M + 212 / 4, "NV4097_SET_VERTEX_DATA4F_M + 212"},
		{NV4097_SET_VERTEX_DATA4F_M + 216 / 4, "NV4097_SET_VERTEX_DATA4F_M + 216"},
		{NV4097_SET_VERTEX_DATA4F_M + 220 / 4, "NV4097_SET_VERTEX_DATA4F_M + 220"},
		{NV4097_SET_VERTEX_DATA4F_M + 224 / 4, "NV4097_SET_VERTEX_DATA4F_M + 224"},
		{NV4097_SET_VERTEX_DATA4F_M + 228 / 4, "NV4097_SET_VERTEX_DATA4F_M + 228"},
		{NV4097_SET_VERTEX_DATA4F_M + 232 / 4, "NV4097_SET_VERTEX_DATA4F_M + 232"},
		{NV4097_SET_VERTEX_DATA4F_M + 236 / 4, "NV4097_SET_VERTEX_DATA4F_M + 236"},
		{NV4097_SET_VERTEX_DATA4F_M + 240 / 4, "NV4097_SET_VERTEX_DATA4F_M + 240"},
		{NV4097_SET_VERTEX_DATA4F_M + 244 / 4, "NV4097_SET_VERTEX_DATA4F_M + 244"},
		{NV4097_SET_VERTEX_DATA4F_M + 248 / 4, "NV4097_SET_VERTEX_DATA4F_M + 248"},
		{NV4097_SET_VERTEX_DATA4F_M + 252 / 4, "NV4097_SET_VERTEX_DATA4F_M + 252"},
		{NV4097_SET_COLOR_KEY_COLOR, "NV4097_SET_COLOR_KEY_COLOR"},
		{NV4097_SET_SHADER_CONTROL, "NV4097_SET_SHADER_CONTROL"},
		{NV4097_SET_INDEXED_CONSTANT_READ_LIMITS, "NV4097_SET_INDEXED_CONSTANT_READ_LIMITS"},
		{NV4097_SET_SEMAPHORE_OFFSET, "NV4097_SET_SEMAPHORE_OFFSET"},
		{NV4097_BACK_END_WRITE_SEMAPHORE_RELEASE, "NV4097_BACK_END_WRITE_SEMAPHORE_RELEASE"},
		{NV4097_TEXTURE_READ_SEMAPHORE_RELEASE, "NV4097_TEXTURE_READ_SEMAPHORE_RELEASE"},
		{NV4097_SET_ZMIN_MAX_CONTROL, "NV4097_SET_ZMIN_MAX_CONTROL"},
		{NV4097_SET_ANTI_ALIASING_CONTROL, "NV4097_SET_ANTI_ALIASING_CONTROL"},
		{NV4097_SET_SURFACE_COMPRESSION, "NV4097_SET_SURFACE_COMPRESSION"},
		{NV4097_SET_ZCULL_EN, "NV4097_SET_ZCULL_EN"},
		{NV4097_SET_SHADER_WINDOW, "NV4097_SET_SHADER_WINDOW"},
		{NV4097_SET_ZSTENCIL_CLEAR_VALUE, "NV4097_SET_ZSTENCIL_CLEAR_VALUE"},
		{NV4097_SET_COLOR_CLEAR_VALUE, "NV4097_SET_COLOR_CLEAR_VALUE"},
		{NV4097_CLEAR_SURFACE, "NV4097_CLEAR_SURFACE"},
		{NV4097_SET_CLEAR_RECT_HORIZONTAL, "NV4097_SET_CLEAR_RECT_HORIZONTAL"},
		{NV4097_SET_CLEAR_RECT_VERTICAL, "NV4097_SET_CLEAR_RECT_VERTICAL"},
		{NV4097_SET_CLIP_ID_TEST_ENABLE, "NV4097_SET_CLIP_ID_TEST_ENABLE"},
		{NV4097_SET_RESTART_INDEX_ENABLE, "NV4097_SET_RESTART_INDEX_ENABLE"},
		{NV4097_SET_RESTART_INDEX, "NV4097_SET_RESTART_INDEX"},
		{NV4097_SET_LINE_STIPPLE, "NV4097_SET_LINE_STIPPLE"},
		{NV4097_SET_LINE_STIPPLE_PATTERN, "NV4097_SET_LINE_STIPPLE_PATTERN"},
		{NV4097_SET_VERTEX_DATA1F_M, "NV4097_SET_VERTEX_DATA1F_M"},
		{NV4097_SET_VERTEX_DATA1F_M + 4 / 4, "NV4097_SET_VERTEX_DATA1F_M + 4"},
		{NV4097_SET_VERTEX_DATA1F_M + 8 / 4, "NV4097_SET_VERTEX_DATA1F_M + 8"},
		{NV4097_SET_VERTEX_DATA1F_M + 12 / 4, "NV4097_SET_VERTEX_DATA1F_M + 12"},
		{NV4097_SET_VERTEX_DATA1F_M + 16 / 4, "NV4097_SET_VERTEX_DATA1F_M + 16"},
		{NV4097_SET_VERTEX_DATA1F_M + 20 / 4, "NV4097_SET_VERTEX_DATA1F_M + 20"},
		{NV4097_SET_VERTEX_DATA1F_M + 24 / 4, "NV4097_SET_VERTEX_DATA1F_M + 24"},
		{NV4097_SET_VERTEX_DATA1F_M + 28 / 4, "NV4097_SET_VERTEX_DATA1F_M + 28"},
		{NV4097_SET_VERTEX_DATA1F_M + 32 / 4, "NV4097_SET_VERTEX_DATA1F_M + 32"},
		{NV4097_SET_VERTEX_DATA1F_M + 36 / 4, "NV4097_SET_VERTEX_DATA1F_M + 36"},
		{NV4097_SET_VERTEX_DATA1F_M + 40 / 4, "NV4097_SET_VERTEX_DATA1F_M + 40"},
		{NV4097_SET_VERTEX_DATA1F_M + 44 / 4, "NV4097_SET_VERTEX_DATA1F_M + 44"},
		{NV4097_SET_VERTEX_DATA1F_M + 48 / 4, "NV4097_SET_VERTEX_DATA1F_M + 48"},
		{NV4097_SET_VERTEX_DATA1F_M + 52 / 4, "NV4097_SET_VERTEX_DATA1F_M + 52"},
		{NV4097_SET_VERTEX_DATA1F_M + 56 / 4, "NV4097_SET_VERTEX_DATA1F_M + 56"},
		{NV4097_SET_VERTEX_DATA1F_M + 60 / 4, "NV4097_SET_VERTEX_DATA1F_M + 60"},
		{NV4097_SET_TRANSFORM_EXECUTION_MODE, "NV4097_SET_TRANSFORM_EXECUTION_MODE"},
		{NV4097_SET_RENDER_ENABLE, "NV4097_SET_RENDER_ENABLE"},
		{NV4097_SET_TRANSFORM_PROGRAM_LOAD, "NV4097_SET_TRANSFORM_PROGRAM_LOAD"},
		{NV4097_SET_TRANSFORM_PROGRAM_START, "NV4097_SET_TRANSFORM_PROGRAM_START"},
		{NV4097_SET_ZCULL_CONTROL0, "NV4097_SET_ZCULL_CONTROL0"},
		{NV4097_SET_ZCULL_CONTROL1, "NV4097_SET_ZCULL_CONTROL1"},
		{NV4097_SET_SCULL_CONTROL, "NV4097_SET_SCULL_CONTROL"},
		{NV4097_SET_POINT_SIZE, "NV4097_SET_POINT_SIZE"},
		{NV4097_SET_POINT_PARAMS_ENABLE, "NV4097_SET_POINT_PARAMS_ENABLE"},
		{NV4097_SET_POINT_SPRITE_CONTROL, "NV4097_SET_POINT_SPRITE_CONTROL"},
		{NV4097_SET_TRANSFORM_TIMEOUT, "NV4097_SET_TRANSFORM_TIMEOUT"},
		{NV4097_SET_TRANSFORM_CONSTANT_LOAD, "NV4097_SET_TRANSFORM_CONSTANT_LOAD"},
		{NV4097_SET_FREQUENCY_DIVIDER_OPERATION, "NV4097_SET_FREQUENCY_DIVIDER_OPERATION"},
		{NV4097_SET_ATTRIB_COLOR, "NV4097_SET_ATTRIB_COLOR"},
		{NV4097_SET_ATTRIB_TEX_COORD, "NV4097_SET_ATTRIB_TEX_COORD"},
		{NV4097_SET_ATTRIB_TEX_COORD_EX, "NV4097_SET_ATTRIB_TEX_COORD_EX"},
		{NV4097_SET_ATTRIB_UCLIP0, "NV4097_SET_ATTRIB_UCLIP0"},
		{NV4097_SET_ATTRIB_UCLIP1, "NV4097_SET_ATTRIB_UCLIP1"},
		{NV4097_INVALIDATE_L2, "NV4097_INVALIDATE_L2"},
		{NV4097_SET_REDUCE_DST_COLOR, "NV4097_SET_REDUCE_DST_COLOR"},
		{NV4097_SET_NO_PARANOID_TEXTURE_FETCHES, "NV4097_SET_NO_PARANOID_TEXTURE_FETCHES"},
		{NV4097_SET_SHADER_PACKER, "NV4097_SET_SHADER_PACKER"},
		{NV4097_SET_VERTEX_ATTRIB_INPUT_MASK, "NV4097_SET_VERTEX_ATTRIB_INPUT_MASK"},
		{NV4097_SET_VERTEX_ATTRIB_OUTPUT_MASK, "NV4097_SET_VERTEX_ATTRIB_OUTPUT_MASK"},
		{NV4097_SET_TRANSFORM_BRANCH_BITS, "NV4097_SET_TRANSFORM_BRANCH_BITS"},
		{NV0039_SET_OBJECT, "NV0039_SET_OBJECT"},
		{NV0039_SET_CONTEXT_DMA_NOTIFIES, "NV0039_SET_CONTEXT_DMA_NOTIFIES"},
		{NV0039_SET_CONTEXT_DMA_BUFFER_IN, "NV0039_SET_CONTEXT_DMA_BUFFER_IN"},
		{NV0039_SET_CONTEXT_DMA_BUFFER_OUT, "NV0039_SET_CONTEXT_DMA_BUFFER_OUT"},
		{NV0039_OFFSET_IN, "NV0039_OFFSET_IN"},
		{NV0039_OFFSET_OUT, "NV0039_OFFSET_OUT"},
		{NV0039_PITCH_IN, "NV0039_PITCH_IN"},
		{NV0039_PITCH_OUT, "NV0039_PITCH_OUT"},
		{NV0039_LINE_LENGTH_IN, "NV0039_LINE_LENGTH_IN"},
		{NV0039_LINE_COUNT, "NV0039_LINE_COUNT"},
		{NV0039_FORMAT, "NV0039_FORMAT"},
		{NV0039_BUFFER_NOTIFY, "NV0039_BUFFER_NOTIFY"},
		{NV3062_SET_OBJECT, "NV3062_SET_OBJECT"},
		{NV3062_SET_CONTEXT_DMA_NOTIFIES, "NV3062_SET_CONTEXT_DMA_NOTIFIES"},
		{NV3062_SET_CONTEXT_DMA_IMAGE_SOURCE, "NV3062_SET_CONTEXT_DMA_IMAGE_SOURCE"},
		{NV3062_SET_CONTEXT_DMA_IMAGE_DESTIN, "NV3062_SET_CONTEXT_DMA_IMAGE_DESTIN"},
		{NV3062_SET_COLOR_FORMAT, "NV3062_SET_COLOR_FORMAT"},
		{NV3062_SET_PITCH, "NV3062_SET_PITCH"},
		{NV3062_SET_OFFSET_SOURCE, "NV3062_SET_OFFSET_SOURCE"},
		{NV3062_SET_OFFSET_DESTIN, "NV3062_SET_OFFSET_DESTIN"},
		{NV309E_SET_OBJECT, "NV309E_SET_OBJECT"},
		{NV309E_SET_CONTEXT_DMA_NOTIFIES, "NV309E_SET_CONTEXT_DMA_NOTIFIES"},
		{NV309E_SET_CONTEXT_DMA_IMAGE, "NV309E_SET_CONTEXT_DMA_IMAGE"},
		{NV309E_SET_FORMAT, "NV309E_SET_FORMAT"},
		{NV309E_SET_OFFSET, "NV309E_SET_OFFSET"},
		{NV308A_SET_OBJECT, "NV308A_SET_OBJECT"},
		{NV308A_SET_CONTEXT_DMA_NOTIFIES, "NV308A_SET_CONTEXT_DMA_NOTIFIES"},
		{NV308A_SET_CONTEXT_COLOR_KEY, "NV308A_SET_CONTEXT_COLOR_KEY"},
		{NV308A_SET_CONTEXT_CLIP_RECTANGLE, "NV308A_SET_CONTEXT_CLIP_RECTANGLE"},
		{NV308A_SET_CONTEXT_PATTERN, "NV308A_SET_CONTEXT_PATTERN"},
		{NV308A_SET_CONTEXT_ROP, "NV308A_SET_CONTEXT_ROP"},
		{NV308A_SET_CONTEXT_BETA1, "NV308A_SET_CONTEXT_BETA1"},
		{NV308A_SET_CONTEXT_BETA4, "NV308A_SET_CONTEXT_BETA4"},
		{NV308A_SET_CONTEXT_SURFACE, "NV308A_SET_CONTEXT_SURFACE"},
		{NV308A_SET_COLOR_CONVERSION, "NV308A_SET_COLOR_CONVERSION"},
		{NV308A_SET_OPERATION, "NV308A_SET_OPERATION"},
		{NV308A_SET_COLOR_FORMAT, "NV308A_SET_COLOR_FORMAT"},
		{NV308A_POINT, "NV308A_POINT"},
		{NV308A_SIZE_OUT, "NV308A_SIZE_OUT"},
		{NV308A_SIZE_IN, "NV308A_SIZE_IN"},
		{NV308A_COLOR, "NV308A_COLOR"},
		{NV3089_SET_OBJECT, "NV3089_SET_OBJECT"},
		{NV3089_SET_CONTEXT_DMA_NOTIFIES, "NV3089_SET_CONTEXT_DMA_NOTIFIES"},
		{NV3089_SET_CONTEXT_DMA_IMAGE, "NV3089_SET_CONTEXT_DMA_IMAGE"},
		{NV3089_SET_CONTEXT_PATTERN, "NV3089_SET_CONTEXT_PATTERN"},
		{NV3089_SET_CONTEXT_ROP, "NV3089_SET_CONTEXT_ROP"},
		{NV3089_SET_CONTEXT_BETA1, "NV3089_SET_CONTEXT_BETA1"},
		{NV3089_SET_CONTEXT_BETA4, "NV3089_SET_CONTEXT_BETA4"},
		{NV3089_SET_CONTEXT_SURFACE, "NV3089_SET_CONTEXT_SURFACE"},
		{NV3089_SET_COLOR_CONVERSION, "NV3089_SET_COLOR_CONVERSION"},
		{NV3089_SET_COLOR_FORMAT, "NV3089_SET_COLOR_FORMAT"},
		{NV3089_SET_OPERATION, "NV3089_SET_OPERATION"},
		{NV3089_CLIP_POINT, "NV3089_CLIP_POINT"},
		{NV3089_CLIP_SIZE, "NV3089_CLIP_SIZE"},
		{NV3089_IMAGE_OUT_POINT, "NV3089_IMAGE_OUT_POINT"},
		{NV3089_IMAGE_OUT_SIZE, "NV3089_IMAGE_OUT_SIZE"},
		{NV3089_DS_DX, "NV3089_DS_DX"},
		{NV3089_DT_DY, "NV3089_DT_DY"},
		{NV3089_IMAGE_IN_SIZE, "NV3089_IMAGE_IN_SIZE"},
		{NV3089_IMAGE_IN_FORMAT, "NV3089_IMAGE_IN_FORMAT"},
		{NV3089_IMAGE_IN_OFFSET, "NV3089_IMAGE_IN_OFFSET"},
		{NV3089_IMAGE_IN, "NV3089_IMAGE_IN"},
		{GCM_SET_DRIVER_OBJECT, "SET_DRIVER_OBJECT"},
		{GCM_DRIVER_QUEUE, "DRIVER_QUEUE + 0x0"},
		{GCM_DRIVER_QUEUE+1, "DRIVER_QUEUE + 0x4"},
		{GCM_FLIP_HEAD, "FLIP_HEAD"},
		{GCM_FLIP_HEAD+1, "FLIP_HEAD + 0x4"},
		{GCM_SET_USER_COMMAND, "SET_USER_COMMAND"},
		{GCM_FLIP_COMMAND, "FLIP_COMMAND"},
	};

	#undef KEY_STR
}

std::pair<std::string_view, std::string_view> rsx::get_method_name(u32 id, std::string& string_name)
{
	const auto found = methods_name.find(id);

	if (found != methods_name.end())
	{
		constexpr std::string_view prefix = "CELL_GCM_";

		return {prefix, found->second};
	}

	string_name.clear();
	fmt::append(string_name, "Unnamed method 0x%04x", id);
	return {};
}

// Various parameter pretty printing function
namespace
{
	/*
	std::string get_texture_wrap_mode(u8 wrap)
	{
		switch (rsx::to_texture_wrap_mode(wrap))
		{
		case rsx::texture_wrap_mode::wrap: return "WRAP";
		case rsx::texture_wrap_mode::mirror: return "MIRROR";
		case rsx::texture_wrap_mode::clamp_to_edge: return "CLAMP_TO_EDGE";
		case rsx::texture_wrap_mode::border: return "BORDER";
		case rsx::texture_wrap_mode::clamp: return "CLAMP";
		case rsx::texture_wrap_mode::mirror_once_clamp_to_edge: return "MIRROR_ONCE_CLAMP_TO_EDGE";
		case rsx::texture_wrap_mode::mirror_once_border: return "MIRROR_ONCE_BORDER";
		case rsx::texture_wrap_mode::mirror_once_clamp: return "MIRROR_ONCE_CLAMP";
		}
		return "Error";
	}

	std::string texture_address(usz index, u32 arg)
	{
		return "Texture " + std::to_string(index) + ": wrap_s = " + get_texture_wrap_mode(arg & 0xF) +
		       " wrap_t = " + get_texture_wrap_mode((arg >> 8) & 0xF) + " wrap_r = " +
		       get_texture_wrap_mode((arg >> 16) & 0xF) + " unsigned remap = " +
		       std::to_string((arg >> 12) & 0xF) + " zfunc = " + get_zfunc_name((arg >> 28) & 0xF) +
		       " gamma = " + std::to_string((arg >> 20) & 0xF) + " aniso bias = " +
		       std::to_string((arg >> 4) & 0xF) + " signed remap = " + std::to_string((arg >> 24) & 0xF);
	}

	std::string get_remap_channel(u8 op) noexcept
	{
		switch (op)
		{
		case 0: return "A";
		case 1: return "R";
		case 2: return "G";
		case 3: return "B";
		}
		return "Error";
	}

	std::string texture_control1(usz index, u32 arg) noexcept
	{
		return "Texture " + std::to_string(index) + " Component 0 = " + get_remap_channel(arg & 0x3) +
		       " Component 1 = " + get_remap_channel((arg >> 2) & 0x3) + " Component 2 = " +
		       get_remap_channel((arg >> 4) & 0x3) + " Component 3 = " +
		       get_remap_channel((arg >> 6) & 0x3);
	}

	std::string texture_border_color(usz index, u32 arg)
	{
		return "Texture " + std::to_string(index) + " border color = " + std::to_string(arg);
	}

	std::string texture_filter(usz index, u32 arg)
	{
		return "Texture " + std::to_string(index) + " bias = " + std::to_string(arg & 0x1fff) +
		       " min_filter = " + std::to_string((arg >> 16) & 0x7) + " mag_filter = " +
		       std::to_string((arg >> 24) & 0x7) + " convolution_filter = " +
		       std::to_string((arg >> 13) & 0xF) + " a_signed = " + std::to_string((arg >> 28) & 0x1) +
		       " r_signed = " + std::to_string((arg >> 29) & 0x1) + " g_signed = " +
		       std::to_string((arg >> 30) & 0x1) + " b_signed = " + std::to_string((arg >> 31) & 0x1);
	}*/

	namespace
	{
		template <u32 Opcode>
		void register_pretty_function(std::string& out, u32 /*id*/, u32 arg)
		{
			rsx::registers_decoder<Opcode>::dump(out, arg);
		}

		template <typename T, T... Index>
		std::array<void(*)(std::string&, u32, u32), 1 << 14> create_printing_table(std::integer_sequence<T, Index...>)
		{
			std::array<void(*)(std::string&, u32, u32), 1 << 14> result{};

			((result[opcode_list[Index * 5 + 0]] = &register_pretty_function<opcode_list[Index * 5 + 0]>,
			result[opcode_list[Index * 5 + 1]] = &register_pretty_function<opcode_list[Index * 5 + 1]>,
			result[opcode_list[Index * 5 + 2]] = &register_pretty_function<opcode_list[Index * 5 + 2]>,
			result[opcode_list[Index * 5 + 3]] = &register_pretty_function<opcode_list[Index * 5 + 3]>,
			result[opcode_list[Index * 5 + 4]] = &register_pretty_function<opcode_list[Index * 5 + 4]>
			), ...);

			return result;
		}
	}

	const auto printing_functions =
		create_printing_table(std::make_index_sequence<std::size(opcode_list) / 5>());

	static_assert(std::size(opcode_list) % 5 == 0);
	/*	{
	  { NV4097_DRAW_ARRAYS, [](u32 arg) -> std::string { return "Draw " + std::to_string((arg >> 24) +
	 1) + " vertex starting from " + std::to_string(arg & 0xFFFFFF); } },
	  { NV4097_DRAW_INDEX_ARRAY, [](u32 arg) -> std::string { return "Draw " + std::to_string((arg >>
	 24) + 1) + " index starting from " + std::to_string(arg & 0xFFFFFF); } },
	  { NV4097_TEXTURE_READ_SEMAPHORE_RELEASE, [](u32 arg) -> std::string { return "Write semaphore
	 value " + std::to_string(arg); } },
	  { NV4097_CLEAR_SURFACE, [](u32 arg) -> std::string { return "Clear surface " + std::string(arg &
	 0x1 ? "Depth " : "") + std::string(arg & 0x2 ? "Stencil " : "") + std::string(arg & 0xF0 ? "Color
	 " : ""); } },
	 };*/
}

std::add_pointer_t<void(std::string&, u32, u32)> rsx::get_pretty_printing_function(u32 id)
{
	const auto found = id < printing_functions.size() ? printing_functions[id] : nullptr;

	if (found)
	{
		return found;
	}

	return [](std::string& result, u32 id, u32 v)
	{
		std::string string_name;
		const auto [name_prefix, name] = rsx::get_method_name(id, string_name);

		if (!string_name.empty())
		{
			fmt::append(result, "%s: 0x%08x", string_name, v);
			return;
		}

		fmt::append(result, "%s: 0x%08x", name, v);
	};
}
